/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.ProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.ClassificationRegKeyBuilder;
import de.statspez.pleditor.generator.codegen.support.HelperVisitor;
import de.statspez.pleditor.generator.codegen.support.LiteralManager;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaNoValue;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaValue;

class GetValueStrategy
extends HelperVisitor {
    private ProgramCodeGenerator generator;
    private String derefPrefix = null;
    private String derefMethod = null;
    private LiteralManager literalManager = null;

    public GetValueStrategy(String derefMethod, ProgramCodeGenerator generator) {
        super(generator);
        this.generator = generator;
        this.derefPrefix = ".get(context)";
        this.derefMethod = derefMethod;
    }

    public GetValueStrategy(ProgramCodeGenerator generator) {
        super(generator);
        this.generator = generator;
        this.derefPrefix = "";
        this.derefMethod = "";
    }

    public void setLiteralManager(LiteralManager literalManager) {
        this.literalManager = literalManager;
    }

    private void printLiteral(MetaValue value) {
        String literal;
        if (!this.literalManager.literalDefinedFor(value)) {
            this.literalManager.defineLiteral(value);
        }
        if ((literal = this.literalManager.literalFor(value)).indexOf(46) < 0 && this.generator.withinSegment()) {
            this.out().print(this.generator.getPlausiClassName());
            this.out().print(".");
        }
        this.out().print(literal);
    }

    public void visitFieldAccess(MetaFieldAccess anAccess) {
        if (!this.scope().isDefined(anAccess.accessedField(), this.namespace())) {
            this.error(anAccess, String.valueOf(anAccess.accessedField().toString()) + " ist nicht in diesem Gueltigkeitsbereich definiert " + "(Scope:" + this.namespace() + ")");
            return;
        }
        SymbolDescriptor sd = this.scope().symbolDescriptor(anAccess.accessedField(), this.namespace());
        String name = StringHelper.getEscapedName(anAccess.accessedField().value());
        if (!this.generator.withinStructureAccess() && this.generator.withinSegment()) {
            if (sd.isLokaleVariable() || sd.isParameter()) {
                this.out().print("context.getVariable(\"");
                this.out().print(name);
                this.out().print("\")");
            } else {
                this.out().print("tb");
                this.out().print(".");
                this.out().print(name);
            }
        } else {
            this.out().print(name);
        }
        this.out().print(this.derefPrefix);
        this.out().print(this.derefMethod);
    }

    public void visitArrayAccess(MetaArrayAccess anAccess) {
        this.out().print(this.derefPrefix);
        this.out().print(this.derefMethod);
    }

    public void visitClassificationReference(MetaClassificationReference anAccess) {
        ClassificationRegKeyBuilder keyBuilder = new ClassificationRegKeyBuilder();
        anAccess.accept(keyBuilder);
        String regKey = keyBuilder.regKey();
        if (this.generator.withinSegment()) {
            this.out().print("plausi");
            this.out().print(".");
        }
        if (anAccess.referenceByCode()) {
            this.out().print("classificationByCode");
        } else {
            this.out().print("classificationByValue");
        }
        this.out().print("(\"");
        this.out().print(regKey);
        this.out().print("\")");
        this.out().print(this.derefMethod);
    }

    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        anAccess.accessedLiteral().accept(this);
        this.out().print(this.derefMethod);
    }

    public void visitNumber(MetaNumber aNumber) {
        this.printLiteral(aNumber);
    }

    public void visitBoolean(MetaBoolean aBoolean) {
        if (aBoolean.value().equals(Boolean.TRUE)) {
            this.out().print("BooleanValue.TRUE");
        } else {
            this.out().print("BooleanValue.FALSE");
        }
    }

    public void visitString(MetaString aString) {
        this.printLiteral(aString);
    }

    public void visitNoValue(MetaNoValue noValue) {
        this.out().print("InvalidValue.instance()");
    }
}

