/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.pl;

import de.statspez.pleditor.generator.codegen.pl.HierarchicalCodeConverter;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaWithOperator;
import java.util.Iterator;
import java.util.Vector;

public class HierarchicalStructureConverter
extends AbstractElementVisitor {
    private HierarchicalCodeConverter codeConverter;
    private boolean firstRun;
    private String structure;
    private Vector indexVariables;

    public HierarchicalStructureConverter(HierarchicalCodeConverter codeConverter) {
        this.codeConverter = codeConverter;
        this.indexVariables = new Vector();
    }

    public void enterStructure(MetaElement structureElement) {
        this.firstRun = true;
        this.structure = this.codeConverter.getNamespace();
        this.indexVariables.clear();
        structureElement.accept(this);
    }

    public void leaveStructure(MetaElement structureElement) {
        this.firstRun = false;
        this.structure = this.codeConverter.getNamespace();
        structureElement.accept(this);
    }

    public String getStructureField() {
        return this.structure;
    }

    public int getIndexVariablesCount() {
        return this.indexVariables.size();
    }

    public String getIndexVariable(int i) {
        return (String)this.indexVariables.get(i);
    }

    protected boolean hasStructure() {
        return this.structure.length() > 0;
    }

    protected void appendIdentifierToStructure(String prefix) {
        if (this.hasStructure()) {
            this.structure = String.valueOf(this.structure) + ".";
        }
        this.structure = String.valueOf(this.structure) + prefix;
    }

    protected void appendIndexVariableToStructure(String index) {
        this.appendIndexToStructure(index);
        this.indexVariables.add(index);
    }

    protected void appendIndexToStructure(String index) {
        this.structure = String.valueOf(this.structure) + "[" + index + "]";
    }

    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        aStructureAccess.structureAccess().accept(this);
        aStructureAccess.selectedElement().accept(this);
    }

    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
        this.appendIdentifierToStructure(anArrayAccess.accessedArray().value());
        Iterator iter = anArrayAccess.indices();
        while (iter != null && iter.hasNext()) {
            MetaFactor index = (MetaFactor)iter.next();
            if (index == null || index.adaptedObject() instanceof MetaWithOperator || index.adaptedObject() instanceof MetaRangeSeries) {
                if (this.firstRun) {
                    String generatedCode;
                    HierarchicalCodeConverter subConverter;
                    String iterVarName = this.codeConverter.getNextGeneratedVariable();
                    if (index != null && index.adaptedObject() instanceof MetaRangeSeries) {
                        subConverter = new HierarchicalCodeConverter(this.codeConverter.getSuperConverter(), "");
                        generatedCode = subConverter.generate(index);
                        this.codeConverter.superIndent();
                        this.codeConverter.superPrint("FUER JEDES ");
                        this.codeConverter.superPrint(iterVarName);
                        this.codeConverter.superPrint(" IN ");
                        this.codeConverter.superPrint(generatedCode);
                        this.codeConverter.superNewLine();
                        this.codeConverter.superIncreaseIndentLevel();
                        this.appendIndexVariableToStructure(iterVarName);
                        continue;
                    }
                    this.codeConverter.superIndent();
                    this.codeConverter.superPrint("VAR ");
                    this.codeConverter.superPrint(iterVarName);
                    this.codeConverter.superIndentNewLine();
                    this.codeConverter.superPrint("WIEDERHOLE FUER ");
                    this.codeConverter.superPrint(iterVarName);
                    this.codeConverter.superPrint(" := 1 BIS ");
                    this.codeConverter.superPrint(iterVarName);
                    this.codeConverter.superPrint(" > ANZAHL VON ");
                    this.codeConverter.superPrint(this.getStructureField());
                    this.codeConverter.superNewLine();
                    this.codeConverter.superIncreaseIndentLevel();
                    this.appendIndexVariableToStructure(iterVarName);
                    if (index == null) continue;
                    subConverter = new HierarchicalCodeConverter(this.codeConverter.getSuperConverter(), this.getStructureField());
                    generatedCode = subConverter.generate(((MetaWithOperator)index.adaptedObject()).operand());
                    this.codeConverter.superIndent();
                    this.codeConverter.superPrint("WENN ");
                    this.codeConverter.superPrint(generatedCode);
                    this.codeConverter.superPrint(" DANN");
                    this.codeConverter.superNewLine();
                    this.codeConverter.superIncreaseIndentLevel();
                    continue;
                }
                if (index != null && index.adaptedObject() instanceof MetaWithOperator) {
                    this.codeConverter.superDecreaseIndentLevel();
                    this.codeConverter.superIndent();
                    this.codeConverter.superPrint("ENDE");
                    this.codeConverter.superNewLine();
                }
                this.codeConverter.superDecreaseIndentLevel();
                this.codeConverter.superIndent();
                this.codeConverter.superPrint("ENDE");
                this.codeConverter.superNewLine();
                continue;
            }
            HierarchicalCodeConverter subConverter = new HierarchicalCodeConverter(this.codeConverter.getSuperConverter(), "");
            this.appendIndexToStructure(subConverter.generate(index));
        }
    }

    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        this.appendIdentifierToStructure(aFieldAccess.accessedField().value());
    }
}

