/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.pl;

import de.statspez.pleditor.generator.codegen.support.AbstractCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaBooleanOperator;
import de.statspez.pleditor.generator.meta.MetaBreakStatement;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaContextOperator;
import de.statspez.pleditor.generator.meta.MetaDate;
import de.statspez.pleditor.generator.meta.MetaDualOperator;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaErrorStatement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaHierarchicalOperator;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaIndexOfOperator;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMapStatement;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaMathOperator;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaNoValue;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaPrintStatement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaSelfAccess;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaSizeTestingOperator;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaTypeCheck;
import de.statspez.pleditor.generator.meta.MetaUnaryBoolOperator;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.meta.MetaWithOperator;
import java.io.StringWriter;
import java.util.Iterator;

public class PrettyPrinter
extends AbstractCodeGenerator {
    public String generate(MetaProgram program) {
        StringWriter writer = new StringWriter();
        this.setOutput(writer);
        program.accept(this);
        this.flush();
        return writer.toString();
    }

    protected void printParameter(Iterator parameter) {
        if (parameter != null && parameter.hasNext()) {
            this.print("(");
            while (parameter.hasNext()) {
                ((MetaElement)parameter.next()).accept(this);
                if (!parameter.hasNext()) continue;
                this.print(", ");
            }
            this.print(")");
        }
    }

    protected void printDualOperand(MetaFactor operand) {
        boolean operandIsComplex = operand.adaptedObject() instanceof MetaDualOperator;
        if (operandIsComplex) {
            this.print("(");
        }
        operand.accept(this);
        if (operandIsComplex) {
            this.print(")");
        }
    }

    protected void printTestingOperator(int type) {
        this.print(" ");
        switch (type) {
            case 1: {
                this.print("=");
                break;
            }
            case 4: {
                this.print("/=");
                break;
            }
            case 3: {
                this.print(">");
                break;
            }
            case 6: {
                this.print(">=");
                break;
            }
            case 2: {
                this.print("<");
                break;
            }
            case 5: {
                this.print("<=");
                break;
            }
            case 7: {
                this.print("IN");
            }
        }
        this.print(" ");
    }

    public void visitProgram(MetaProgram aProgram) {
        aProgram.statements().accept(this);
    }

    public void visitStatementSequence(MetaStatementSequence aSequence) {
        Iterator iter = aSequence.statements();
        while (iter != null && iter.hasNext()) {
            this.indent();
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.newLine();
        }
    }

    public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
        this.print("VAR ");
        Iterator iter = aDeclaration.identifiers();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
    }

    public void visitErrorStatement(MetaErrorStatement aStatement) {
        this.print("FEHLER");
        if (aStatement.errorNumber() != 0) {
            this.print(" ");
            this.print(aStatement.errorNumber());
        }
    }

    public void visitMapStatement(MetaMapStatement aStatement) {
        this.print("MAPPEN");
    }

    public void visitReturnStatement(MetaReturnStatement aStatement) {
        this.print("RUECKGABE ");
        aStatement.returnValue().accept(this);
    }

    public void visitPrintStatement(MetaPrintStatement aStatement) {
        this.print("GIB ");
        Iterator iter = aStatement.toPrint();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print(" AUS");
        if (aStatement.leftValue() != null) {
            this.print(" NACH ");
            aStatement.leftValue().accept(this);
        }
    }

    public void visitFunctionCall(MetaFunctionCall aStatement) {
        if (aStatement.isProperty()) {
            this.print("IST ");
            aStatement.function().accept(this);
        } else {
            this.print("FUNKTION ");
            aStatement.function().accept(this);
            this.print("(");
            Iterator iter = aStatement.parameters();
            while (iter != null && iter.hasNext()) {
                ((MetaElement)iter.next()).accept(this);
                if (!iter.hasNext()) continue;
                this.print(", ");
            }
            this.print(")");
        }
    }

    public void visitAblaufStatement(MetaAblaufStatement aStatement) {
        if (aStatement.function().adaptedObject() instanceof MetaStructureAccess) {
            MetaStructureAccess structureAccess = (MetaStructureAccess)aStatement.function().adaptedObject();
            this.print("THEMENBEREICH ");
            structureAccess.structureAccess().accept(this);
            this.print(" MIT ABLAUF ");
            structureAccess.selectedElement().accept(this);
        } else {
            this.print("ABLAUF ");
            aStatement.function().accept(this);
        }
        this.printParameter(aStatement.parameters());
    }

    public void visitPruefeStatement(MetaPruefeStatement aStatement) {
        this.print("PRUEFE ");
        aStatement.function().accept(this);
    }

    public void visitCheckFeldStatement(MetaCheckFeldStatement aStatement) {
        this.print("FELD ");
        aStatement.field().accept(this);
    }

    public void visitWhileLoop(MetaWhileLoop aStatement) {
        this.print("WIEDERHOLE SOLANGE ");
        aStatement.condition().accept(this);
        this.increaseIndentLevel();
        this.newLine();
        aStatement.loopBody().accept(this);
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.print("ENDE");
    }

    public void visitForNextLoop(MetaForNextLoop aStatement) {
        MetaNumber number;
        MetaLiteralAccess literalAccess;
        this.print("WIEDERHOLE FUER ");
        aStatement.startAssignment().accept(this);
        this.print(" BIS ");
        aStatement.endCondition().accept(this);
        boolean defaultStepExpression = false;
        if (aStatement.stepExpression().adaptedObject() instanceof MetaLiteralAccess && (literalAccess = (MetaLiteralAccess)aStatement.stepExpression().adaptedObject()).accessedLiteral() instanceof MetaNumber && (number = (MetaNumber)literalAccess.accessedLiteral()).value() == 1.0) {
            defaultStepExpression = true;
        }
        if (!defaultStepExpression) {
            this.print(" SCHRITTWEITE ");
            aStatement.stepExpression().accept(this);
        }
        this.increaseIndentLevel();
        this.newLine();
        aStatement.loopBody().accept(this);
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.print("ENDE");
    }

    public void visitForEachLoop(MetaForEachLoop aStatement) {
        this.print("FUER JEDES ");
        Iterator iter = aStatement.variables();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print(" IN ");
        aStatement.value().accept(this);
        if (aStatement.restrictions() != null && !aStatement.restrictions().isEmpty()) {
            this.print(" ");
            iter = aStatement.restrictions().iterator();
            while (iter != null && iter.hasNext()) {
                MetaElement restriction = (MetaElement)iter.next();
                if (restriction != null) {
                    restriction.accept(this);
                } else {
                    this.print("ALLE");
                }
                if (!iter.hasNext()) continue;
                this.print(", ");
            }
        }
        this.increaseIndentLevel();
        this.newLine();
        aStatement.loopBody().accept(this);
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.print("ENDE");
    }

    public void visitForEachCheck(MetaForEachCheck aStatement) {
        this.print("FUER JEDES ");
        Iterator iter = aStatement.variables();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print(" IN ");
        aStatement.value().accept(this);
        if (aStatement.restrictions() != null && !aStatement.restrictions().isEmpty()) {
            this.print(" ");
            iter = aStatement.restrictions().iterator();
            while (iter != null && iter.hasNext()) {
                MetaElement restriction = (MetaElement)iter.next();
                if (restriction != null) {
                    restriction.accept(this);
                } else {
                    this.print("ALLE");
                }
                if (!iter.hasNext()) continue;
                this.print(", ");
            }
        }
        this.print(" GILT (");
        aStatement.condition().accept(this);
        this.print(")");
    }

    public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
        this.print("FUER ");
        aStatement.value().accept(this);
        this.increaseIndentLevel();
        this.newLine();
        aStatement.loopBody().accept(this);
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.print("ENDE");
    }

    public void visitBreakStatement(MetaBreakStatement aStatement) {
        this.print("ABBRUCH");
    }

    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        this.print("WENN ");
        aStatement.condition().accept(this);
        this.print(" DANN");
        this.increaseIndentLevel();
        this.newLine();
        aStatement.ifTrue().accept(this);
        this.decreaseIndentLevel();
        if (aStatement.ifFalse().numberOfStatements() > 0) {
            this.indentNewLine();
            this.print("SONST");
            this.increaseIndentLevel();
            this.newLine();
            aStatement.ifFalse().accept(this);
            this.decreaseIndentLevel();
        }
        this.indentNewLine();
        this.print("ENDE");
    }

    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        anAssignment.leftValue().accept(this);
        this.print(" := ");
        anAssignment.rightValue().accept(this);
    }

    public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
        Iterator iter = anAssignment.leftValues();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print(" := ");
        anAssignment.rightValue().accept(this);
    }

    public void visitBooleanOperator(MetaBooleanOperator anOperator) {
        this.printDualOperand(anOperator.firstOperand());
        this.print(" ");
        switch (anOperator.type()) {
            case 1: {
                this.print("UND");
                break;
            }
            case 2: {
                this.print("ODER");
            }
        }
        this.print(" ");
        this.printDualOperand(anOperator.secondOperand());
    }

    public void visitUnaryBoolOperator(MetaUnaryBoolOperator anOperator) {
        this.print("NICHT ");
        anOperator.operand().accept(this);
    }

    public void visitTestingOperator(MetaTestingOperator anOperator) {
        this.printDualOperand(anOperator.firstOperand());
        this.printTestingOperator(anOperator.type());
        this.printDualOperand(anOperator.secondOperand());
    }

    public void visitMathOperator(MetaMathOperator anOperator) {
        this.printDualOperand(anOperator.firstOperand());
        this.print(" ");
        switch (anOperator.type()) {
            case 1: {
                this.print("+");
                break;
            }
            case 2: {
                this.print("-");
                break;
            }
            case 4: {
                this.print("*");
                break;
            }
            case 3: {
                this.print("/");
            }
        }
        this.print(" ");
        this.printDualOperand(anOperator.secondOperand());
    }

    public void visitSignOperator(MetaSignOperator anOperator) {
        if (anOperator.type() == 2) {
            this.print("-");
        }
        anOperator.operand().accept(this);
    }

    public void visitTypeCheck(MetaTypeCheck anOperator) {
        anOperator.value().accept(this);
        this.print(" HAT TYP ");
        switch (anOperator.type()) {
            case 1: {
                this.print("KOMMAZAHL");
                break;
            }
            case 5: {
                this.print("GANZZAHL");
                break;
            }
            case 2: {
                this.print("ZEICHENKETTE");
                break;
            }
            case 3: 
            case 4: {
                this.print("DATUM");
                break;
            }
            case 6: {
                this.print("KATEGORIE");
                break;
            }
            case 7: {
                this.print("WAHRHEITSWERT");
            }
        }
        if (anOperator.maske() != null) {
            this.print("(");
            anOperator.maske().accept(this);
            this.print(")");
        }
    }

    public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
        this.print("ANZAHL VON ");
        anOperator.operand().accept(this);
    }

    public void visitSizeTestingOperator(MetaSizeTestingOperator anOperator) {
        MetaNumber number;
        MetaLiteralAccess literalAccess;
        this.print("EXISTIERT ");
        boolean defaultTestingOperator = false;
        if (anOperator.type() == 1 && anOperator.firstOperand().adaptedObject() instanceof MetaLiteralAccess && (literalAccess = (MetaLiteralAccess)anOperator.firstOperand().adaptedObject()).accessedLiteral() instanceof MetaNumber && (number = (MetaNumber)literalAccess.accessedLiteral()).value() == 1.0) {
            defaultTestingOperator = true;
        }
        if (!defaultTestingOperator) {
            switch (anOperator.type()) {
                case 1: {
                    this.print("MINDESTENS");
                    break;
                }
                case 2: {
                    this.print("GENAU");
                    break;
                }
                case 3: {
                    this.print("HOECHSTENS");
                }
            }
            this.print(" ");
            anOperator.firstOperand().accept(this);
            this.print(" ");
        }
        anOperator.secondOperand().accept(this);
    }

    public void visitHierarchicalOperator(MetaHierarchicalOperator anOperator) {
        switch (anOperator.type()) {
            case 1: {
                this.print("IDENTISCH");
                break;
            }
            case 2: {
                this.print("MIN");
                break;
            }
            case 3: {
                this.print("MAX");
                break;
            }
            case 4: {
                this.print("SUMME");
                break;
            }
            case 5: {
                this.print("MITTEL");
                break;
            }
            case 6: {
                this.print("MEDIAN");
                break;
            }
            case 7: {
                this.print("VARIANZ");
                break;
            }
            case 8: {
                this.print("STABW");
            }
        }
        this.print(" ");
        anOperator.operand().accept(this);
    }

    public void visitIndexOfOperator(MetaIndexOfOperator anOperator) {
        this.print("INDEX VON ");
        anOperator.operand().accept(this);
    }

    public void visitContextOperator(MetaContextOperator anOperator) {
        if (anOperator.type() == 1) {
            this.print("GLOBAL ");
        }
        anOperator.operand().accept(this);
    }

    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        aStructureAccess.structureAccess().accept(this);
        this.print(".");
        aStructureAccess.selectedElement().accept(this);
    }

    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
        anArrayAccess.accessedArray().accept(this);
        Iterator iter = anArrayAccess.indices();
        while (iter != null && iter.hasNext()) {
            MetaElement index = (MetaElement)iter.next();
            this.print("[");
            if (index != null) {
                index.accept(this);
            } else {
                this.print("ALLE");
            }
            this.print("]");
        }
    }

    public void visitWithOperator(MetaWithOperator anOperator) {
        this.print("MIT ");
        anOperator.operand().accept(this);
    }

    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        aFieldAccess.accessedField().accept(this);
    }

    public void visitSelfAccess(MetaSelfAccess aSelfAccess) {
        this.print("WERT");
    }

    public void visitClassificationReference(MetaClassificationReference aReference) {
        this.print("#");
        Iterator iter = aReference.levels();
        while (iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(".");
        }
    }

    public void visitMaterialAccess(MetaMaterialAccess anAccess) {
        this.print("MATERIAL ");
        anAccess.material().accept(this);
        this.print("(");
        Iterator iter = anAccess.selectionConditions();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (iter.hasNext()) {
                this.print(", ");
                continue;
            }
            this.print("; ");
        }
        iter = anAccess.selectedFields();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print(")");
    }

    public void visitIdentifier(MetaIdentifier anIdentifier) {
        this.print(anIdentifier.value());
    }

    public void visitLiteralAccess(MetaLiteralAccess aLiteralAccess) {
        aLiteralAccess.accessedLiteral().accept(this);
    }

    public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
        this.print("{");
        Iterator iter = aRangeSeries.ranges();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
            if (!iter.hasNext()) continue;
            this.print(", ");
        }
        this.print("}");
    }

    public void visitInterval(MetaInterval anInterval) {
        anInterval.first().accept(this);
        switch (anInterval.type()) {
            case 4: {
                this.print("++");
                break;
            }
            case 3: {
                this.print("+-");
                break;
            }
            case 2: {
                this.print("-+");
                break;
            }
            case 1: {
                this.print("--");
            }
        }
        anInterval.last().accept(this);
    }

    public void visitSequence(MetaSequence aSequence) {
        aSequence.first().accept(this);
        this.print(", ");
        aSequence.second().accept(this);
        this.print("..");
        aSequence.last().accept(this);
    }

    public void visitSingleValueRange(MetaSingleValueRange aRange) {
        aRange.value().accept(this);
    }

    public void visitNumber(MetaNumber aNumber) {
        this.print(aNumber.getMyStringValue());
    }

    public void visitString(MetaString aString) {
        this.print("'");
        this.print(CodegenUtil.getEscapedStringLiteral(aString.value()));
        this.print("'");
    }

    public void visitBoolean(MetaBoolean aBoolean) {
        if (aBoolean.value().booleanValue()) {
            this.print("WAHR");
        } else {
            this.print("FALSCH");
        }
    }

    public void visitDate(MetaDate aDate) {
        this.print("DATUMSWERT(");
        aDate.specification().accept(this);
        if (aDate.format() != null && aDate.format().length() > 0) {
            this.print(", '");
            this.print(CodegenUtil.getEscapedStringLiteral(aDate.format()));
            this.print("'");
        }
        this.print(")");
    }

    public void visitNoValue(MetaNoValue value) {
        this.print("LEER");
    }
}

