/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomEinzelfeld;
import de.statspez.pleditor.generator.meta.generated.MetaDsbComps;
import de.statspez.pleditor.generator.meta.generated.MetaDsbFeld;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaSatzart;
import java.util.Stack;

public class DSBStructureBuilder
extends AbstractElementVisitor {
    public void visitPlausibilisierung(MetaPlausibilisierung aPlausi) {
        this.visitElements(aPlausi.getDsbs());
    }

    public void visitDsbObjekt(MetaDsbObjekt aDsb) {
        if (aDsb != null) {
            DSBStructureBuilderHelper helper = new DSBStructureBuilderHelper();
            aDsb.accept(helper);
        }
    }

    public static boolean istStrukturTyp(String typ) {
        boolean erg = false;
        if ("Str".equals(typ) || "Wfgr".equals(typ) || "VKWG".equals(typ)) {
            erg = true;
        }
        return erg;
    }

    public class DSBStructureBuilderHelper
    extends AbstractElementVisitor {
        private Stack aktuelleFeldhierarchie = null;

        public void visitDsbObjekt(MetaDsbObjekt aDsb) {
            this.aktuelleFeldhierarchie = new Stack();
            if (aDsb.getComps() != null) {
                aDsb.getComps().accept(this);
            }
        }

        public void visitDsbComps(MetaDsbComps anObject) {
            this.visitElements(anObject.getCompList());
            this.visitElements(anObject.getSatzList());
        }

        public void visitEinzelfeld(MetaEinzelfeld anObject) {
            this.aktualisiereFieldhierarchie(anObject.getStufenNr());
            this.addField(anObject);
            if (anObject instanceof MetaCustomEinzelfeld && DSBStructureBuilder.istStrukturTyp(anObject.getTyp())) {
                this.aktuelleFeldhierarchie.push(anObject);
            }
        }

        public void visitSatzart(MetaSatzart anObject) {
            this.aktualisiereFieldhierarchie((short)0);
            this.visitElements(anObject.getFelder());
        }

        private void aktualisiereFieldhierarchie(short stufenNr) {
            if (!this.aktuelleFeldhierarchie.isEmpty()) {
                while (!this.aktuelleFeldhierarchie.isEmpty() && ((MetaCustomEinzelfeld)this.aktuelleFeldhierarchie.peek()).getStufenNr() >= stufenNr) {
                    this.aktuelleFeldhierarchie.pop();
                }
            }
        }

        private void addField(MetaDsbFeld field) {
            if (!this.aktuelleFeldhierarchie.isEmpty()) {
                ((MetaCustomEinzelfeld)this.aktuelleFeldhierarchie.peek()).addToCompList(field);
            }
        }
    }
}

