/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptorFactory;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;

public class GenericSymbolDescriptorFactory
extends AbstractElementVisitor
implements SymbolDescriptorFactory {
    private GenericSymbolDescriptor currentDescriptor = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public SymbolDescriptor createSymbolDescriptor(MetaElement anElement) {
        this.currentDescriptor = null;
        anElement.accept(this);
        if (this.currentDescriptor == null) {
            throw new IllegalArgumentException("Erzeugung eines Symbol-Deskriptors fuer " + anElement.toString() + " nicht moeglich.");
        }
        return this.currentDescriptor;
    }

    public void visitPLAuspraegung(MetaPLAuspraegung anApg) {
        MetaCustomAuspraegung apg = (MetaCustomAuspraegung)anApg;
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsClassification(true);
        this.currentDescriptor.setDisplayName(anApg.getName());
    }

    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe apg) {
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsClassification(true);
        this.currentDescriptor.setIsClassificationGroup(true);
        this.currentDescriptor.setDisplayName(apg.getName());
    }

    public void visitTBFeld(MetaTBFeld aFeld) {
        MetaCustomTBFeld feld = (MetaCustomTBFeld)aFeld;
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsTbField(true);
        MetaStatspezObjekt klasse = aFeld.getKlasse();
        if (klasse instanceof MetaCustomMerkmal) {
            MetaCustomMerkmal merkmal = (MetaCustomMerkmal)klasse;
            this.currentDescriptor.setFieldReferencesTb(false);
            this.setType(this.currentDescriptor, merkmal.getTyp());
            this.currentDescriptor.setMerkmal(merkmal.getName());
        } else if (klasse instanceof MetaCustomThemenbereich) {
            MetaCustomThemenbereich tb = (MetaCustomThemenbereich)klasse;
            this.currentDescriptor.setFieldReferencesTb(true);
            this.currentDescriptor.setMerkmal(tb.getName());
        }
        if (feld.dimensions() != null) {
            this.currentDescriptor.setIsArray(true);
            this.currentDescriptor.setDimensions(feld.dimensions());
        }
        this.currentDescriptor.setDisplayName(aFeld.getName());
    }

    public void visitPLInitwert(MetaPLInitwert anInitwert) {
        MetaCustomInitwert initwert = (MetaCustomInitwert)anInitwert;
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsInitwert(true);
        if (initwert.dimensions() != null) {
            this.currentDescriptor.setIsArray(true);
            this.currentDescriptor.setDimensions(initwert.dimensions());
        }
        this.setType(this.currentDescriptor, initwert.getTyp());
        this.currentDescriptor.setDisplayName(initwert.getName());
    }

    public void visitPLPruefung(MetaPLPruefung pruefung) {
        if (!$assertionsDisabled && this.currentDescriptor != null) {
            throw new AssertionError();
        }
        ((MetaCustomPruefung)pruefung).getMetaSpezifikation().accept(this);
        if (!$assertionsDisabled && this.currentDescriptor == null) {
            throw new AssertionError();
        }
        this.currentDescriptor.setIsPruefung(true);
        this.currentDescriptor.setIsBoolean(true);
    }

    public void visitPLAblauf(MetaPLAblauf ablauf) {
        MetaCustomAblauf anAblauf = (MetaCustomAblauf)ablauf;
        if (!$assertionsDisabled && this.currentDescriptor != null) {
            throw new AssertionError();
        }
        anAblauf.getMetaSpezifikation().accept(this);
        if (!$assertionsDisabled && this.currentDescriptor == null) {
            throw new AssertionError();
        }
        this.currentDescriptor.setIsAblauf(true);
        this.currentDescriptor.setDisplayName(ablauf.getName());
        GenericSymbolDescriptor ablDesc = this.currentDescriptor;
        SymbolDescriptor[] params = new SymbolDescriptor[anAblauf.getThemenbereich().sizeOfInitialisierungswerte()];
        int i = 0;
        while (i < params.length) {
            params[i] = this.createSymbolDescriptor(anAblauf.getThemenbereich().getFromInitialisierungswerte(i));
            ++i;
        }
        ablDesc.setFunctionParameters(params);
        this.currentDescriptor = ablDesc;
    }

    public void visitPLFunktion(MetaPLFunktion funktion) {
        if (!$assertionsDisabled && this.currentDescriptor != null) {
            throw new AssertionError();
        }
        ((MetaCustomFunktion)funktion).getMetaSpezifikation().accept(this);
        if (!$assertionsDisabled && this.currentDescriptor == null) {
            throw new AssertionError();
        }
        if (funktion instanceof MetaCustomFunktion && ((MetaCustomFunktion)funktion).getFunctionType() == 1) {
            this.currentDescriptor.setIsEigenschaft(true);
        }
        this.currentDescriptor.setIsFunction(true);
        this.currentDescriptor.setDisplayName(funktion.getName());
    }

    public void visitProgram(MetaProgram program) {
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setHasGenericType(true);
        GenericSymbolDescriptor prgDesc = this.currentDescriptor;
        SymbolDescriptor[] params = new SymbolDescriptor[program.numberOfParameters()];
        int i = 0;
        while (i < params.length) {
            params[i] = this.createSymbolDescriptor(program.parameterAt(i));
            ++i;
        }
        prgDesc.setFunctionParameters(params);
        this.currentDescriptor = prgDesc;
    }

    public void visitProgramParameter(MetaProgramParameter param) {
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsParameter(true);
        this.currentDescriptor.setDisplayName(param.name().value());
        this.currentDescriptor.setIsArray(param.isList());
        if (param.isList()) {
            this.currentDescriptor.setDimensions(param.dimensions());
        }
        this.currentDescriptor.setHasGenericType(true);
    }

    public void visitPLVariable(MetaPLVariable aVariable) {
        MetaCustomVariable variable = (MetaCustomVariable)aVariable;
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsHilfsvariable(true);
        this.currentDescriptor.setDisplayName(aVariable.getName());
        this.setType(this.currentDescriptor, variable.getTyp());
        if (variable.getListe()) {
            this.currentDescriptor.setIsArray(true);
            this.currentDescriptor.setDimensions(variable.dimensions());
        }
    }

    public void visitPLMaterial(MetaPLMaterial aMaterial) {
        this.currentDescriptor = new GenericSymbolDescriptor();
        this.currentDescriptor.setIsMaterial(true);
        this.currentDescriptor.setHasGenericType(true);
    }

    public void visitTBMaterialReferenz(MetaTBMaterialReferenz aReference) {
        aReference.getMaterialbeschreibung().accept(this);
        if (!$assertionsDisabled && this.currentDescriptor == null) {
            throw new AssertionError((Object)"SymbolDescriptor fuer referenziertes Material wurde nicht erzeugt");
        }
        this.currentDescriptor.setIsReference(true);
    }

    private void setType(GenericSymbolDescriptor descriptor, int ilType) {
        switch (ilType) {
            case 1: 
            case 5: {
                descriptor.setIsNumeric(true);
                break;
            }
            case 2: {
                descriptor.setIsString(true);
                break;
            }
            case 7: {
                descriptor.setIsBoolean(true);
                break;
            }
            case 3: 
            case 4: {
                descriptor.setIsDate(true);
                break;
            }
            case 6: {
                descriptor.setIsCategory(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unbekannter Typ-Code der Zwischensprache: " + ilType);
            }
        }
    }
}

