/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.common;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.common.MessageContextInterface;

public class DefaultMessageContext
implements MessageContextInterface {
    private static final long serialVersionUID = 4385390139260816306L;
    protected String textContext = null;

    public DefaultMessageContext(String context) {
        this.textContext = context;
    }

    public String toString(AbstractMessage message) {
        StringBuffer text = new StringBuffer();
        if (message != null) {
            boolean spalte;
            text.append(message.messageType());
            text.append(" (");
            text.append(this.textContext);
            text.append(")");
            text.append(": ");
            text.append(message.message());
            int aktLine = this.getLineForDisplay(message.line());
            boolean zeile = aktLine > -1;
            boolean bl = spalte = message.column() > -1;
            if (zeile || spalte) {
                text.append(" [");
            }
            if (zeile) {
                text.append("Zeile ");
                text.append(Integer.toString(aktLine));
            }
            if (zeile && spalte) {
                text.append(", ");
            }
            if (spalte) {
                text.append("Position ");
                text.append(Integer.toString(message.column()));
            }
            if (zeile || spalte) {
                text.append("]");
            }
        } else {
            text.append(" (");
            text.append(this.textContext);
            text.append(")");
            text.append(": Leere Fehlermeldung.");
        }
        return text.toString();
    }

    public String toStringHTML(AbstractMessage message) {
        return this.toString(message);
    }

    public int getLineForDisplay(int line) {
        int erg = line;
        if (this.textContext != null) {
            if (this.textContext.startsWith("Eigenschaft")) {
                --erg;
            } else if (this.textContext.startsWith("Merkmal")) {
                erg -= 2;
            } else if (this.textContext.startsWith("Pruefung")) {
                --erg;
            }
        }
        return erg;
    }

    public String toString() {
        if (this.textContext != null && this.textContext.length() > 0) {
            return this.textContext;
        }
        return "Kontext";
    }
}

