/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.common;

import de.statspez.pleditor.generator.codegen.java.CodegenFacade;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import de.statspez.pleditor.generator.parser.speclanguage.SpecLangParseException;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.Arrays;

public class GeneratorInvocation {
    public static void main(String[] args) throws Exception {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Es muessen die folgenden Parameter angegeben werden:");
            System.err.println("1. (erforderlich) Name der Eingabe-Datei oder des Pfades.");
            System.err.println("2. (optional) Verzeichnis, in dem die Ausgabe-Datei erzeugt");
            System.err.println("   werden soll. Wenn dieser Parameter nicht angegeben ist wird");
            System.err.println("   das aktuelle Verzeichnis verwendet.");
            System.err.println("   Falls f\u00fcr 1. ein Pfad vorgegeben wird, werden die enthaltenen");
            System.err.println("   Dateien mit dem Muster Plausi_*.xml verarbeitet.");
            System.exit(1);
        }
        File file = new File(args[0]);
        File targetPath = null;
        if (file.isFile()) {
            targetPath = args.length == 1 ? file.getParentFile() : new File(args[1]);
            GeneratorInvocation.generate(file, targetPath);
        } else if (file.isDirectory()) {
            targetPath = args.length == 1 ? file : new File(args[1]);
            Object[] filesInDir = file.list(new FilenameFilter(){

                public boolean accept(File f, String s) {
                    return s.startsWith("Plausi_") && s.endsWith(".xml");
                }
            });
            if (filesInDir.length != 0) {
                Arrays.sort(filesInDir);
                int i = 0;
                while (i < filesInDir.length) {
                    GeneratorInvocation.generate(new File(file, (String)filesInDir[i]), targetPath);
                    ++i;
                }
            } else {
                System.out.println("Keine EDT-DAteien in " + file + " gefunden ...");
            }
        }
    }

    public static void generate(File file, File targetPath) throws Exception {
        MetaPlausibilisierung plausi = null;
        FileReader in = new FileReader(file);
        try {
            try {
                System.out.println("Parsen der Eingabe-Datei " + file + " ...");
                IntermediateLanguageParser parser = new IntermediateLanguageParser();
                plausi = (MetaPlausibilisierung)parser.parse(in);
            }
            catch (ILParseException exc) {
                System.err.println("Beim Parsen der Eingabe-Datei " + file + " ist ein Fehler aufgetreten:");
                System.err.println(exc.getMessage());
                exc.printStackTrace();
                System.exit(1);
            }
            catch (SpecLangParseException exc) {
                System.err.println("Beim Parsen der Eingabe-Datei " + file + " ist ein Fehler aufgetreten:");
                System.err.println(exc.getMessage());
                System.err.println(exc.messagesAsText());
                System.exit(1);
            }
            catch (Throwable thr) {
                System.err.println("Beim Parsen der Eingabe-Datei " + file + " ist ein Fehler aufgetreten:");
                System.err.println(thr.getMessage());
                thr.printStackTrace();
                System.exit(1);
            }
        }
        finally {
            in.close();
        }
        try {
            CodegenFacade generator = new CodegenFacade();
            generator.generate(plausi, targetPath.getAbsolutePath());
        }
        catch (CodegenException exc) {
            System.err.println("Bei der Code-Erzeugung von " + file + " sind Fehler/Warnungen aufgetreten:");
            System.err.println(exc.getMessage());
            System.err.println(exc.errorsAsText());
            System.err.println(exc.warningsAsText());
            if (exc.hasErrors()) {
                System.exit(1);
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            System.exit(1);
        }
    }
}

