/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ValueResolver;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;

public class IdentifierResolver
extends AbstractElementVisitor {
    private InterpreterContext context;
    private ValueResolver privateValueResolver;
    private String currentName;
    private int[] currentIndices;
    private FeldDeskriptorImpl currentField;
    private boolean identifiesMethod;
    private boolean firstStructureAccess;

    public IdentifierResolver(InterpreterContext context) {
        this.context = context;
        this.privateValueResolver = null;
        this.currentName = null;
        this.currentIndices = null;
        this.currentField = null;
        this.identifiesMethod = false;
        this.firstStructureAccess = true;
    }

    public void resolve(MetaElement element) {
        this.resolve(element, false);
    }

    public void resolve(MetaElement element, boolean identifiesMethod) {
        this.currentName = null;
        this.currentIndices = null;
        this.currentField = null;
        this.identifiesMethod = identifiesMethod;
        this.firstStructureAccess = true;
        this.currentField = identifiesMethod ? this.context.getCurrentStructure() : null;
        element.accept(this);
    }

    public boolean isVariable() {
        return this.currentField == null;
    }

    public String getName() {
        return this.currentName;
    }

    public int[] getIndices() {
        return this.currentIndices;
    }

    public FeldDeskriptorImpl getFieldDescriptor() {
        return this.currentField;
    }

    private ValueResolver valueResolver() {
        if (this.privateValueResolver == null) {
            this.privateValueResolver = new ValueResolver(this.context);
        }
        return this.privateValueResolver;
    }

    private void checkCurrentIdentifier() {
        if (this.currentField == null) {
            if (!this.context.isVariableDeclared(this.currentName)) {
                try {
                    this.currentField = this.context.getFieldDescriptorFactory().getFieldDecriptor(this.currentName, this.currentIndices, this.context.getCurrentStructure());
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException("Feld " + this.currentName + " ist in diesem G\u00fcltigkeitsbereich nicht definiert.");
                }
            }
        } else {
            try {
                this.currentField = this.context.getFieldDescriptorFactory().getFieldDecriptor(this.currentName, this.currentIndices, this.currentField);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("Feld " + this.currentName + " ist in diesem G\u00fcltigkeitsbereich nicht definiert.");
            }
        }
    }

    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        boolean accessSelectedElementDirectly;
        if (this.identifiesMethod) {
            if (this.firstStructureAccess) {
                this.firstStructureAccess = false;
                accessSelectedElementDirectly = true;
            } else {
                accessSelectedElementDirectly = false;
            }
        } else {
            accessSelectedElementDirectly = false;
        }
        aStructureAccess.structureAccess().accept(this);
        if (accessSelectedElementDirectly) {
            this.currentIndices = null;
            MetaFieldAccess aFieldAccess = (MetaFieldAccess)aStructureAccess.selectedElement();
            aFieldAccess.accessedField().accept(this);
        } else {
            aStructureAccess.selectedElement().accept(this);
        }
    }

    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
        this.currentIndices = new int[anArrayAccess.numberOfIndices()];
        int i = 0;
        while (i < anArrayAccess.numberOfIndices()) {
            this.currentIndices[i] = (int)this.valueResolver().resolve(anArrayAccess.indexAt(i)).asLong() - 1;
            ++i;
        }
        anArrayAccess.accessedArray().accept(this);
        this.checkCurrentIdentifier();
    }

    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        this.currentIndices = null;
        aFieldAccess.accessedField().accept(this);
        this.checkCurrentIdentifier();
    }

    public void visitIdentifier(MetaIdentifier anIdentifier) {
        this.currentName = anIdentifier.value();
    }
}

