/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.interpreter.ClassificationFactory;
import de.statspez.pleditor.generator.interpreter.DefaultClassificationFactory;
import de.statspez.pleditor.generator.interpreter.DefaultProgramFactory;
import de.statspez.pleditor.generator.interpreter.FieldDescriptorFactory;
import de.statspez.pleditor.generator.interpreter.InterpreterPlausi;
import de.statspez.pleditor.generator.interpreter.ProgramFactory;
import de.statspez.pleditor.generator.interpreter.StringFieldDescriptiorFactory;
import de.statspez.pleditor.generator.runtime.ClassificationGroup;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Stack;

public class InterpreterContext
extends PlausiRuntimeContext {
    private static final String SCOPE_TYPE_KEY = "##SCOPE_TYPE##";
    private static final String SCOPE_TYPE_ROOT = "ROOT";
    private static final String SCOPE_TYPE_PROGRAM = "PROGRAM";
    private static final String SCOPE_TYPE_BLOCK = "BLOCK";
    private static final String CURRENT_STRUCTURE_KEY = "##CURRENT_STRUCTURE##";
    private FieldDescriptorFactory fieldDescriptorFactory = new StringFieldDescriptiorFactory();
    private ProgramFactory programFactory = new DefaultProgramFactory();
    private ClassificationFactory classificationFactory = new DefaultClassificationFactory();
    private ValueFactory privateValueFactory = ValueFactory.instance();
    private Stack variables = new Stack();
    private int currentScopeLevel = 0;
    private PrintStream console;

    public InterpreterContext() {
        super(new InterpreterPlausi());
        this.variables.add(this.createScope(SCOPE_TYPE_ROOT));
        this.console = System.out;
    }

    public void setFieldDescriptorFactory(FieldDescriptorFactory fieldDescriptorFactory) {
        this.fieldDescriptorFactory = fieldDescriptorFactory;
    }

    public FieldDescriptorFactory getFieldDescriptorFactory() {
        return this.fieldDescriptorFactory;
    }

    public void setProgramFactory(ProgramFactory programFactory) {
        this.programFactory = programFactory;
    }

    public ProgramFactory getProgramFactory() {
        return this.programFactory;
    }

    public void setClassificationFactory(ClassificationFactory classificationFactory) {
        this.classificationFactory = classificationFactory;
    }

    public ClassificationFactory getClassificationFactory() {
        return this.classificationFactory;
    }

    public boolean isClassificationRegistered(String reference) {
        return this.classificationFactory.isClassificationRegistered(reference);
    }

    public void registerClassificationGroup(String name, ClassificationGroup classificationGroup) {
        this.classificationFactory.registerClassificationGroup(name, classificationGroup);
    }

    public ValueFactory valueFactory() {
        return this.privateValueFactory;
    }

    public void enterProgram(FeldDeskriptorImpl currentStrucure) {
        ++this.currentScopeLevel;
        HashMap scope = this.createScope(SCOPE_TYPE_PROGRAM);
        if (currentStrucure != null) {
            scope.put(CURRENT_STRUCTURE_KEY, currentStrucure);
        }
        this.variables.push(scope);
    }

    public void enterBlock() {
        ++this.currentScopeLevel;
        this.variables.push(this.createScope(SCOPE_TYPE_BLOCK));
    }

    public void leaveScope() {
        --this.currentScopeLevel;
        this.variables.pop();
    }

    public FeldDeskriptorImpl getCurrentStructure() {
        FeldDeskriptorImpl currentStructure = null;
        int i = this.variables.size() - 1;
        while (i >= 0) {
            HashMap scope = (HashMap)this.variables.get(i);
            if (scope.get(SCOPE_TYPE_KEY) == SCOPE_TYPE_PROGRAM && scope.containsKey(CURRENT_STRUCTURE_KEY)) {
                currentStructure = (FeldDeskriptorImpl)scope.get(CURRENT_STRUCTURE_KEY);
                break;
            }
            --i;
        }
        return currentStructure;
    }

    public void declareVariable(String name) {
        this.declareVariable(name, null);
    }

    public void declareVariable(String name, int[] indicies) {
        if (this.isVariableDeclared(name)) {
            throw new RuntimeException("Die Variable " + name + " ist in diesem G\u00fcltigkeitsbereich bereits definiert.");
        }
        HashMap values = this.getCurrentScope();
        values.put(name, NilValue.instance());
        if (indicies != null && indicies.length > 0) {
            int i = 0;
            while (i < indicies.length) {
                values.put(String.valueOf(name) + "[" + indicies[i] + "]", NilValue.instance());
                ++i;
            }
        }
    }

    public boolean isVariableDeclared(String name) {
        return this.findScopeFromVariable(name) != null;
    }

    public void setVariableValue(String name, Value value) {
        this.setVariableValue(name, null, value);
    }

    public void setVariableValue(String name, int[] indicies, Value value) {
        HashMap values = this.findScopeFromVariable(name);
        if (values == null) {
            throw new RuntimeException("Die Variable " + name + " ist in diesem G\u00fcltigkeitsbereich nicht definiert.");
        }
        StringBuffer key = new StringBuffer(name);
        if (indicies != null && indicies.length > 0) {
            int i = 0;
            while (i < indicies.length) {
                key.append("[");
                key.append(indicies[i]);
                key.append("]");
                ++i;
            }
        }
        values.put(key.toString(), value);
    }

    public Value getVariableValue(String name) {
        return this.getVariableValue(name, null);
    }

    public Value getVariableValue(String name, int[] indicies) {
        HashMap values = this.findScopeFromVariable(name);
        if (values == null) {
            throw new RuntimeException("Die Variable " + name + " ist in diesem G\u00fcltigkeitsbereich nicht definiert.");
        }
        StringBuffer key = new StringBuffer(name);
        if (indicies != null && indicies.length > 0) {
            int j = 0;
            while (j < indicies.length) {
                key.append("[");
                key.append(indicies[j]);
                key.append("]");
                ++j;
            }
        }
        return (Value)values.get(key.toString());
    }

    public void incrementVariableValue(String name, long increment) {
        this.incrementVariableValue(name, null, increment);
    }

    public void incrementVariableValue(String name, int[] indicies, long increment) {
        Value value = this.getVariableValue(name, indicies);
        this.setVariableValue(name, indicies, this.valueFactory().valueFor(value.asDouble() + (double)increment));
    }

    public void setConsole(PrintStream console) {
        this.console = console;
    }

    public PrintStream getConsole() {
        return this.console;
    }

    private HashMap createScope(String scopeType) {
        HashMap<String, String> scope = new HashMap<String, String>();
        scope.put(SCOPE_TYPE_KEY, scopeType);
        return scope;
    }

    private HashMap getCurrentScope() {
        return (HashMap)this.variables.peek();
    }

    private HashMap findScopeFromVariable(String name) {
        HashMap scope = null;
        int i = this.variables.size() - 1;
        while (i >= 0) {
            HashMap scopeTmp = (HashMap)this.variables.get(i);
            if (scopeTmp.containsKey(name)) {
                scope = scopeTmp;
                break;
            }
            if (scopeTmp.get(SCOPE_TYPE_KEY) == SCOPE_TYPE_PROGRAM) {
                i = 0;
            }
            --i;
        }
        return scope;
    }
}

