/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.interpreter.ProgramDescriptor;
import de.statspez.pleditor.generator.interpreter.ProgramFactory;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import java.util.Iterator;

public class PlausiProgramFactory
implements ProgramFactory {
    private MetaCustomPlausibilisierung plausi;

    public PlausiProgramFactory(MetaCustomPlausibilisierung plausi) {
        this.plausi = plausi;
    }

    public ProgramDescriptor getProgram(String name, FeldDeskriptorImpl structure) throws NoSuchFieldException {
        MetaThemenbereich topic = this.getTopicForStructure(this.plausi.rootThemenbereich(), structure);
        Iterator iter = topic.getFunktionen();
        while (iter.hasNext()) {
            MetaCustomFunktion function = (MetaCustomFunktion)iter.next();
            if (!function.getName().equals(name)) continue;
            String[] parameters = new String[function.sizeOfParameter()];
            int i = 0;
            while (i < function.sizeOfParameter()) {
                parameters[i] = function.getFromParameter(i).getName();
                ++i;
            }
            return new ProgramDescriptor(function.getMetaSpezifikation(), parameters);
        }
        return null;
    }

    private MetaThemenbereich getTopicForStructure(MetaThemenbereich topic, FeldDeskriptorImpl structure) throws NoSuchFieldException {
        if (structure == null) {
            return topic;
        }
        topic = this.getTopicForStructure(topic, (FeldDeskriptorImpl)structure.getVorgaenger());
        Iterator iter = topic.getFelder();
        while (iter.hasNext()) {
            MetaCustomTBFeld field = (MetaCustomTBFeld)iter.next();
            if (!field.getName().equals(structure.getFeldNameTB())) continue;
            return (MetaThemenbereich)field.getKlasse();
        }
        throw new NoSuchFieldException("Feld " + structure.getFeldNameTB() + " ist in diesem G\u00fcltigkeitsbereich nicht definiert.");
    }
}

