/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.codegen.pl.HierarchicalCodeConverter;
import de.statspez.pleditor.generator.interpreter.ErrorStatementException;
import de.statspez.pleditor.generator.interpreter.IdentifierResolver;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ProgramDescriptor;
import de.statspez.pleditor.generator.interpreter.ValueResolver;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaBreakStatement;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaErrorStatement;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaPrintStatement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.runtime.BreakStatementException;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.FunctionLib;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeIterator;
import de.statspez.pleditor.generator.runtime.ReturnStatementException;
import de.statspez.pleditor.generator.runtime.SupportLib;
import de.statspez.pleditor.generator.runtime.Value;
import java.util.Iterator;

public class ProgramInterpreter
extends AbstractElementVisitor {
    private InterpreterContext context = null;
    private ValueResolver valueResolver = null;
    private IdentifierResolver identifierResolver = null;

    public Value execute(MetaProgram program, InterpreterContext currentContext) throws ErrorStatementException {
        this.init(currentContext);
        this.context.enterProgram(null);
        Value returnValue = this.execute(program);
        this.context.leaveScope();
        return returnValue;
    }

    public Value execute(MetaFunctionCall functionCall, InterpreterContext currentContext) throws ErrorStatementException {
        this.init(currentContext);
        this.identifierResolver.resolve(functionCall.function(), true);
        String functionName = this.identifierResolver.getName();
        FeldDeskriptorImpl functionStructure = this.identifierResolver.getFieldDescriptor();
        try {
            int i;
            ProgramDescriptor programDescriptor = this.context.getProgramFactory().getProgram(functionName, functionStructure);
            if (programDescriptor == null) {
                throw new RuntimeException("Die Funktion " + functionName + " ist in diesem Kontext nicht definiert.");
            }
            this.context = currentContext;
            this.valueResolver = new ValueResolver(currentContext);
            this.identifierResolver = new IdentifierResolver(currentContext);
            String[] parameters = programDescriptor.getParameters();
            Value[] values = null;
            if (parameters != null) {
                values = new Value[parameters.length];
                i = 0;
                while (i < parameters.length) {
                    values[i] = this.valueResolver.resolve(functionCall.parameterAt(i));
                    ++i;
                }
            }
            this.context.enterProgram(functionStructure);
            if (parameters != null) {
                i = 0;
                while (i < parameters.length) {
                    this.context.declareVariable(parameters[i]);
                    this.context.setVariableValue(parameters[i], values[i]);
                    ++i;
                }
            }
            Value returnValue = this.execute(programDescriptor.getProgram());
            this.context.leaveScope();
            return returnValue;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private void init(InterpreterContext currentContext) {
        this.context = currentContext;
        this.valueResolver = new ValueResolver(currentContext);
        this.identifierResolver = new IdentifierResolver(currentContext);
    }

    private Value execute(MetaProgram program) {
        Value returnValue;
        if (program.containsHierarchicalFunction()) {
            HierarchicalCodeConverter converter = new HierarchicalCodeConverter();
            program = Helper.metaStructureFor(converter.generate(program));
        }
        try {
            program.accept(this);
            returnValue = NilValue.instance();
        }
        catch (ReturnStatementException e) {
            returnValue = e.getReturnValue();
        }
        return returnValue;
    }

    public void visitProgram(MetaProgram aProgram) {
        aProgram.statements().accept(this);
    }

    public void visitStatementSequence(MetaStatementSequence aSequence) {
        Iterator iter = aSequence.statements();
        while (iter != null && iter.hasNext()) {
            ((MetaElement)iter.next()).accept(this);
        }
    }

    public void visitErrorStatement(MetaErrorStatement aStatement) {
        throw new ErrorStatementException(aStatement.errorNumber());
    }

    public void visitReturnStatement(MetaReturnStatement aStatement) {
        throw new ReturnStatementException(this.valueResolver.resolve(aStatement.returnValue()));
    }

    public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
        Iterator iter = aDeclaration.identifiers();
        while (iter != null && iter.hasNext()) {
            MetaIdentifier variable = (MetaIdentifier)iter.next();
            this.context.declareVariable(variable.value());
        }
    }

    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        this.identifierResolver.resolve(anAssignment.leftValue());
        Value value = this.valueResolver.resolve(anAssignment.rightValue());
        if (this.identifierResolver.isVariable()) {
            this.context.setVariableValue(this.identifierResolver.getName(), this.identifierResolver.getIndices(), value);
        } else {
            this.identifierResolver.getFieldDescriptor().setValueWith(this.context.getSatz(), value);
        }
    }

    public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
        PlausiRuntimeIterator valueIter = SupportLib.iteratorFor(this.valueResolver.resolve(anAssignment.rightValue()), this.context);
        Iterator varIter = anAssignment.leftValues();
        while (varIter != null && varIter.hasNext()) {
            this.identifierResolver.resolve((MetaElement)varIter.next());
            if (valueIter == null || !valueIter.hasNext()) continue;
            Value value = (Value)valueIter.next();
            if (this.identifierResolver.isVariable()) {
                this.context.setVariableValue(this.identifierResolver.getName(), this.identifierResolver.getIndices(), value);
                continue;
            }
            this.identifierResolver.getFieldDescriptor().setValueWith(this.context.getSatz(), value);
        }
    }

    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        if (this.valueResolver.resolve(aStatement.condition()).asBoolean()) {
            if (aStatement.ifTrue() != null) {
                this.context.enterBlock();
                try {
                    aStatement.ifTrue().accept(this);
                }
                finally {
                    this.context.leaveScope();
                }
            }
        } else if (aStatement.ifFalse() != null) {
            this.context.enterBlock();
            try {
                aStatement.ifFalse().accept(this);
            }
            finally {
                this.context.leaveScope();
            }
        }
    }

    public void visitForNextLoop(MetaForNextLoop aStatement) {
        FeldDeskriptorImpl fieldDescriptor;
        int[] indices;
        String name;
        this.identifierResolver.resolve(aStatement.startAssignment().leftValue());
        boolean variable = this.identifierResolver.isVariable();
        if (variable) {
            name = this.identifierResolver.getName();
            indices = this.identifierResolver.getIndices();
            fieldDescriptor = null;
        } else {
            name = null;
            indices = null;
            fieldDescriptor = this.identifierResolver.getFieldDescriptor();
        }
        long step = 1L;
        if (aStatement.stepExpression() != null) {
            step = this.valueResolver.resolve(aStatement.stepExpression()).asLong();
        }
        aStatement.startAssignment().accept(this);
        try {
            while (!this.valueResolver.resolve(aStatement.endCondition()).asBoolean()) {
                if (aStatement.loopBody() != null) {
                    this.context.enterBlock();
                    try {
                        aStatement.loopBody().accept(this);
                    }
                    finally {
                        this.context.leaveScope();
                    }
                }
                if (variable) {
                    this.context.incrementVariableValue(name, indices, step);
                    continue;
                }
                Value value = fieldDescriptor.getValueFrom(this.context.getSatz());
                fieldDescriptor.setValueWith(this.context.getSatz(), this.context.valueFactory().valueFor(value.asDouble() + (double)step));
            }
        }
        catch (BreakStatementException breakStatementException) {
            // empty catch block
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visitForEachLoop(MetaForEachLoop aStatement) {
        this.context.enterBlock();
        try {
            Iterator iter = aStatement.variables();
            while (iter != null && iter.hasNext()) {
                MetaIdentifier variable = (MetaIdentifier)iter.next();
                if (this.context.isVariableDeclared(variable.value())) continue;
                this.context.declareVariable(variable.value());
            }
            PlausiRuntimeIterator values = SupportLib.iteratorFor(this.valueResolver.resolve(aStatement.value()), this.context);
            try {
                block15: {
                    block14: {
                        if (!true) break block14;
                        if (values == null) return;
                        if (!values.hasNext()) break block15;
                    }
                    do {
                        iter = aStatement.variables();
                        while (iter != null && iter.hasNext()) {
                            MetaIdentifier variable = (MetaIdentifier)iter.next();
                            this.context.setVariableValue(variable.value(), (Value)values.next());
                        }
                        if (aStatement.loopBody() != null) {
                            this.context.enterBlock();
                            try {
                                aStatement.loopBody().accept(this);
                            }
                            finally {
                                this.context.leaveScope();
                            }
                        }
                        if (values == null) return;
                    } while (values.hasNext());
                }
                return;
            }
            catch (BreakStatementException breakStatementException) {
                return;
            }
        }
        finally {
            this.context.leaveScope();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void visitWhileLoop(MetaWhileLoop aStatement) {
        try {
            while (true) {
                if (!this.valueResolver.resolve(aStatement.condition()).asBoolean()) {
                    return;
                }
                if (aStatement.loopBody() == null) continue;
                this.context.enterBlock();
                aStatement.loopBody().accept(this);
                continue;
                break;
            }
            finally {
                this.context.leaveScope();
            }
        }
        catch (BreakStatementException breakStatementException) {
            // empty catch block
        }
    }

    public void visitBreakStatement(MetaBreakStatement aStatement) {
        throw new BreakStatementException();
    }

    public void visitFunctionCall(MetaFunctionCall aStatement) {
        this.valueResolver.resolve(aStatement);
    }

    public void visitPrintStatement(MetaPrintStatement aStatement) {
        if (aStatement.leftValue() != null) {
            this.identifierResolver.resolve(aStatement.leftValue());
            Iterator iter = aStatement.toPrint();
            while (iter != null && iter.hasNext()) {
                Value oldValue;
                if (this.identifierResolver.isVariable()) {
                    oldValue = this.context.getVariableValue(this.identifierResolver.getName(), this.identifierResolver.getIndices());
                    this.context.setVariableValue(this.identifierResolver.getName(), this.identifierResolver.getIndices(), FunctionLib.KONKATENIEREN(this.context, oldValue, this.valueResolver.resolve((MetaElement)iter.next())));
                    continue;
                }
                oldValue = this.identifierResolver.getFieldDescriptor().getValueFrom(this.context.getSatz());
                this.identifierResolver.getFieldDescriptor().setValueWith(this.context.getSatz(), FunctionLib.KONKATENIEREN(this.context, oldValue, this.valueResolver.resolve((MetaElement)iter.next())));
            }
        } else {
            Iterator iter = aStatement.toPrint();
            while (iter != null && iter.hasNext()) {
                this.context.getConsole().print(this.valueResolver.resolve((MetaElement)iter.next()));
            }
            this.context.getConsole().println();
        }
    }
}

