/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.masken;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.MaskeException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DatumMaske
extends AbstractMaske {
    protected DatumMaske() {
    }

    public SimpleDateFormat getSimpleDateFormat() {
        if (this.maske != null) {
            return new SimpleDateFormat(this.maske);
        }
        return null;
    }

    public boolean isWertGueltigOld(String wert, StringBuffer fehler) {
        try {
            Date date = this.getWertAlsDate(wert);
            SimpleDateFormat format = new SimpleDateFormat(this.maske);
            format.setLenient(false);
            format.format(date);
            return true;
        }
        catch (MaskeException e) {
            if (fehler != null) {
                fehler.append(e.getMessage());
            }
            return false;
        }
    }

    public boolean isWertGueltig(String wert, StringBuffer fehler) {
        if (this.maske == null) {
            if (fehler != null) {
                fehler.append("Die Maske muss angegeben werden!");
            }
            return false;
        }
        if (wert == null) {
            if (fehler != null) {
                fehler.append("Der Wert muss angegeben werden!");
            }
            return false;
        }
        if (wert.length() != this.minLaenge) {
            this.gibFormatFehler(fehler, wert);
            return false;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(this.maske);
            format.setLenient(false);
            format.parse(wert);
            Date date = format.parse(wert);
            format = new SimpleDateFormat(this.maske);
            format.setLenient(false);
            String str = format.format(date);
            if (!str.equals(wert)) {
                this.gibFormatFehler(fehler, wert);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.gibFormatFehler(fehler, wert);
            return false;
        }
    }

    public Date getWertAlsDate(String wert) throws MaskeException {
        if (this.maske == null) {
            throw new MaskeException("Die Maske muss angegeben werden!");
        }
        if (wert == null) {
            throw new MaskeException("Der Wert muss angegeben werden!");
        }
        if (wert.length() != this.maske.length()) {
            throw new MaskeException("Der Wert " + wert + " muss genau " + this.maske.length() + " Zeichen enthalten!");
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(this.maske);
            format.setLenient(false);
            Date date = format.parse(wert);
            return date;
        }
        catch (Exception e) {
            throw new MaskeException("Der Wert " + wert + " entspricht nicht dem in der Maske definierten Format.");
        }
    }

    public String gibWertFormatiert(Object wert) {
        if (wert == null) {
            return null;
        }
        if (wert instanceof Date) {
            return this.gibWertFormatiert((Date)wert);
        }
        return wert.toString();
    }

    public String gibWertFormatiert(Date date) {
        String erg;
        if (date == null) {
            erg = null;
        } else {
            SimpleDateFormat format = new SimpleDateFormat(this.maske);
            format.setLenient(false);
            erg = format.format(date);
        }
        return erg;
    }

    protected char gibStandardAusrichtung() {
        return 'L';
    }
}

