/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ObjectContextParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PropertiesParser;
import de.statspez.pleditor.generator.parser.ReplacementUtil;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.speclanguage.SpecLangParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AblaufParser
extends SubParser
implements SuperParser {
    private MetaCustomAblauf currentAblauf = null;
    private ParserChain parserChain = new ParserChain();
    private PropertiesParser propertiesParser;
    private ObjectContextParser objectContextParser;

    public AblaufParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.propertiesParser = new PropertiesParser(this, resolver);
        this.parserChain.addParser(this.propertiesParser);
        this.objectContextParser = new ObjectContextParser(this, resolver);
        this.parserChain.addParser(this.objectContextParser);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "flow".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("flow".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentAblauf = new MetaCustomAblauf();
            this.propertiesParser.setCurrentElement(this.currentAblauf);
            this.objectContextParser.setCurrentElement(this.currentAblauf);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("flow".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unknownTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentAblauf;
    }

    public void notifyObjectAvailable(SubParser aParser) {
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("flow".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer den Ablauf ist kein Name definiert!");
            }
            this.currentAblauf.setName(name.trim());
            String str = atts.getValue("id");
            if (str != null && str.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentAblauf.setId(str.trim());
            } else {
                this.currentAblauf.setId(name);
            }
            String state = atts.getValue("state");
            if (state != null && state.trim().equals("approved")) {
                this.currentAblauf.setFreigabeStatus((short)1);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        handled = true;
        chars = this.superParser().charData().toString().trim();
        if ("code".equalsIgnoreCase(localName)) {
            block6: {
                util = ReplacementUtil.getInstance();
                if (util.sollErsetztWerden(this.superParser().getParserKontext().getVersion())) {
                    chars = util.replace(chars);
                }
                this.currentAblauf.setSpezifikation(chars);
                spez = null;
                try {
                    spez = Helper.metaStructureFor(new ElementMessageContext(2, this.currentAblauf.getId(), this.currentAblauf.getName()), chars);
                    break block6;
                }
                catch (SpecLangParseException e) {
                    mit = e.messageIterator();
                    ** while (mit.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    aMsg = (AbstractMessage)mit.next();
                    this.error(aMsg);
                    continue;
                }
lbl18:
                // 1 sources

                spez = new MetaProgram("Ablauf " + this.currentAblauf.getName(), new MetaStatementSequence());
            }
            spez.setName(this.currentAblauf.getName());
            this.currentAblauf.setMetaSpezifikation(spez);
        } else {
            handled = false;
        }
        return handled;
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        return "http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && tag.equalsIgnoreCase("code");
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

