/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.KommaZahlMaske;
import de.statspez.pleditor.generator.masken.MaskeException;
import de.statspez.pleditor.generator.masken.MaskenParserFaktory;
import de.statspez.pleditor.generator.masken.MaskenParserInterface;
import de.statspez.pleditor.generator.masken.ZahlMaske;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.ObjectContextParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PropertiesParser;
import de.statspez.pleditor.generator.parser.ReplacementUtil;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import de.statspez.pleditor.generator.parser.speclanguage.SpecLangParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MerkmalParser
extends SubParser
implements SuperParser {
    private MetaCustomMerkmal currentMerkmal = null;
    private ParserChain parserChain = new ParserChain();
    private PropertiesParser propertiesParser = null;
    private ObjectContextParser objectContextParser = null;
    static /* synthetic */ Class class$0;

    public MerkmalParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.propertiesParser = new PropertiesParser(this, resolver);
        this.parserChain.addParser(this.propertiesParser);
        this.objectContextParser = new ObjectContextParser(this, resolver);
        this.parserChain.addParser(this.objectContextParser);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && "statisticVariable".equalsIgnoreCase(tag)) {
            return true;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("statisticVariable".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentMerkmal = new MetaCustomMerkmal();
            this.propertiesParser.setCurrentElement(this.currentMerkmal);
            this.objectContextParser.setCurrentElement(this.currentMerkmal);
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("statisticVariable".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentMerkmal;
    }

    public void notifyObjectAvailable(SubParser aParser) {
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("statisticVariable".equalsIgnoreCase(localName)) {
            String state;
            String classifClass_id;
            String empty;
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer das Merkmal ist kein Name definiert!");
            }
            this.currentMerkmal.setName(name.trim());
            String str = atts.getValue("id");
            if (str != null && str.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentMerkmal.setId(str.trim());
            } else {
                this.currentMerkmal.setId(name);
            }
            String type = atts.getValue("type");
            if (type == null) {
                throw new ILParseException("Fuer das Merkmal " + name + " ist kein Typ definiert");
            }
            this.currentMerkmal.setTyp(Helper.typeByName(type.trim()));
            String length = atts.getValue("length");
            if (length == null) {
                throw new ILParseException("Fuer das Merkmal " + name + " ist keine Laenge angegeben!");
            }
            this.currentMerkmal.setLaenge(Long.parseLong(length));
            String mask = atts.getValue("mask");
            if (mask != null && mask.length() > 0) {
                int typ = -1;
                switch (this.currentMerkmal.getTyp()) {
                    case 1: {
                        typ = 4;
                        break;
                    }
                    case 5: {
                        typ = 1;
                        break;
                    }
                    case 3: {
                        typ = 2;
                        break;
                    }
                    case 4: {
                        typ = 3;
                        break;
                    }
                    case 2: {
                        typ = 6;
                        break;
                    }
                    default: {
                        typ = -1;
                    }
                }
                if (typ != -1) {
                    try {
                        MaskenParserFaktory faktory = MaskenParserFaktory.getInstance();
                        MaskenParserInterface parser = faktory.getMaskenParserFuerTyp(typ);
                        try {
                            AbstractMaske maske = parser.parse(mask);
                            this.currentMerkmal.setMaske(mask);
                            if (maske instanceof ZahlMaske) {
                                this.currentMerkmal.setFuehrendeNullen(((ZahlMaske)maske).hatFuehrendeNullen());
                                this.currentMerkmal.setVorzeichen(((ZahlMaske)maske).hatVorzeichen());
                                if (maske instanceof KommaZahlMaske) {
                                    this.currentMerkmal.setVorkommastellen((short)((KommaZahlMaske)maske).getVorkommastellen());
                                    this.currentMerkmal.setNachkommastellen((short)((KommaZahlMaske)maske).getNachkommastellen());
                                }
                            }
                        }
                        catch (MaskeException e) {
                            throw new ILParseException("Maske '" + mask + "' konnte nicht interpretiert werden! " + e.getMessage());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((empty = atts.getValue("empty_allowed")) != null) {
                this.currentMerkmal.setLeer(Helper.toBoolean(empty.trim()));
            } else {
                this.currentMerkmal.setLeer(true);
            }
            String resist = atts.getValue("resist_allowed");
            if (resist != null) {
                this.currentMerkmal.setVerweigerung(Helper.toBoolean(resist.trim()));
            } else {
                this.currentMerkmal.setVerweigerung(false);
            }
            String unknown = atts.getValue("uncnown_allowed");
            if (unknown != null) {
                this.currentMerkmal.setNichtWissen(Helper.toBoolean(unknown.trim()));
            } else {
                this.currentMerkmal.setNichtWissen(false);
            }
            String classifClass = atts.getValue("classifikation-class");
            if (classifClass != null && classifClass.trim().length() > 0) {
                String apgReference = "#" + classifClass;
                MetaProgram checkPrg = this.createMerkmalCheckProgram(this.currentMerkmal, apgReference);
                this.currentMerkmal.setMetaSpezifikation(checkPrg);
            }
            if ((classifClass_id = atts.getValue("classifikation-class-id")) != null && classifClass_id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                Resolver resolver = this.resolver();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resolver.registerForResolve(this.currentMerkmal, classifClass_id, classifClass, clazz);
            } else if (classifClass != null && classifClass.trim().length() > 0) {
                Resolver resolver = this.resolver();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                resolver.registerForResolve(this.currentMerkmal, classifClass, classifClass, clazz);
            }
            String misClass_id = atts.getValue("missing-values-class-id");
            if (misClass_id != null && misClass_id.trim().length() > 0) {
                this.resolver().isUseIDasRef();
            }
            if ((state = atts.getValue("state")) != null && state.trim().equals("approved")) {
                this.currentMerkmal.setFreigabeStatus((short)1);
            }
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws ILParseException {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        if ("displayName".equalsIgnoreCase(localName)) {
            this.currentMerkmal.setBezeichnung(chars);
        } else if ("values".equalsIgnoreCase(localName)) {
            if (this.currentMerkmal.getMetaSpezifikation() == null) {
                ReplacementUtil util = ReplacementUtil.getInstance();
                if (util.sollErsetztWerden(this.superParser().getParserKontext().getVersion())) {
                    chars = util.replace(chars);
                }
                this.currentMerkmal.setWertebereich(chars);
                MetaProgram checkPrg = this.createMerkmalCheckProgram(this.currentMerkmal, "{" + chars + "}");
                this.currentMerkmal.setMetaSpezifikation(checkPrg);
            }
        } else if ("question".equalsIgnoreCase(localName)) {
            this.currentMerkmal.setFrage(chars);
        } else if ("errorShort".equalsIgnoreCase(localName)) {
            this.currentMerkmal.setFehlertextKurz(chars);
            MetaProgram program = Helper.getFehlerTextAlsMetaProgram(chars, this.getMessageContext("(Fehlertext kurz)"));
            if (program != null) {
                program.setCanHaveSelfAccess(true);
                this.currentMerkmal.setFehlerTextKurzProgram(program);
            }
        } else if ("errorLong".equalsIgnoreCase(localName)) {
            this.currentMerkmal.setFehlertextLang(chars);
            MetaProgram program = Helper.getFehlerTextAlsMetaProgram(chars, this.getMessageContext("(Fehlertext lang)"));
            if (program != null) {
                program.setCanHaveSelfAccess(true);
                this.currentMerkmal.setFehlerTextLangProgram(program);
            }
        } else if ("correctionDescription".equalsIgnoreCase(localName)) {
            this.currentMerkmal.setKorrekturhinweis(chars);
            MetaProgram program = Helper.getFehlerTextAlsMetaProgram(chars, this.getMessageContext("(Korrekturhinweis)"));
            if (program != null) {
                program.setCanHaveSelfAccess(true);
                this.currentMerkmal.setKorrekturhinweisProgram(program);
            }
        } else if ("explanation".equalsIgnoreCase(localName)) {
            this.currentMerkmal.setBeschreibung(chars);
        } else {
            handled = false;
        }
        return handled;
    }

    /*
     * Unable to fully structure code
     */
    private MetaProgram createMerkmalCheckProgram(MetaCustomMerkmal merkmal, String values) throws ILParseException {
        block11: {
            code = new StringBuffer();
            if (!merkmal.getLeer()) {
                code.append("\nWENN feld = LEER DANN FEHLER ");
                code.append(1);
                code.append(" ENDE");
            }
            if (merkmal.getLaenge() > 0L) {
                if (merkmal.getLeer()) {
                    code.append("\nWENN feld /= LEER DANN");
                }
                code.append("\nWENN &WERTLAENGE(feld) > ");
                code.append(merkmal.getLaenge());
                code.append(" DANN FEHLER ");
                code.append(3);
                code.append(" ENDE");
                if (merkmal.getLeer()) {
                    code.append("\nENDE");
                }
            }
            code.append("\nWENN NICHT feld HAT TYP ");
            code.append(this.getConstantForType(merkmal.getTyp()));
            if (merkmal.getMaske() != null && merkmal.getMaske().trim().length() > 0) {
                code.append(" ('");
                code.append(merkmal.getMaske().replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'"));
                code.append("')");
            }
            code.append(" DANN FEHLER ");
            code.append(2);
            code.append(" ENDE");
            baseCode = code.toString();
            if (values != null && values.trim().length() > 0 && !"{}".equals(values)) {
                if (merkmal.getLeer()) {
                    code.append("\nWENN feld /= LEER DANN");
                }
                code.append("\nWENN NICHT feld IN ");
                code.append(values);
                code.append(" DANN FEHLER ");
                code.append(4);
                code.append(" ENDE");
                if (merkmal.getLeer()) {
                    code.append("\nENDE");
                }
            }
            prg = null;
            try {
                prg = Helper.metaStructureFor(this.getMessageContext(null), code.toString());
                break block11;
            }
            catch (SpecLangParseException e) {
                mit = e.messageIterator();
                ** while (mit.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                aMsg = (AbstractMessage)mit.next();
                this.error(aMsg);
                continue;
            }
lbl71:
            // 1 sources

            prg = Helper.metaStructureFor(this.getMessageContext(null), baseCode);
        }
        prg.setName("Merkmal_" + merkmal.getName());
        prg.setContextInfos(this.getMessageContext(null));
        feldParam = new MetaProgramParameter(new MetaIdentifier("feld"), true);
        prg.addParameter(feldParam);
        merkmal.setPLSpezifikation(code.toString());
        return prg;
    }

    private String getConstantForType(int type) throws ILParseException {
        String constant = null;
        switch (type) {
            case 1: {
                constant = "KOMMAZAHL";
                break;
            }
            case 2: {
                constant = "ZEICHENKETTE";
                break;
            }
            case 3: {
                constant = "DATUM";
                break;
            }
            case 4: {
                constant = "DATUM";
                break;
            }
            case 5: {
                constant = "GANZZAHL";
                break;
            }
            case 6: {
                constant = "KATEGORIE";
                break;
            }
            case 7: {
                constant = "WAHRHEITSWERT";
                break;
            }
            default: {
                throw new ILParseException("Der Typ " + type + " hat keine Entsprechung in " + "der Zwischensprache");
            }
        }
        return constant;
    }

    private boolean canHandleTag(String namespaceURI, String tag) {
        return "http://www.werum.de/pl-editor".equalsIgnoreCase(namespaceURI) && ("values".equalsIgnoreCase(tag) || "question".equalsIgnoreCase(tag) || "displayName".equalsIgnoreCase(tag) || "explanation".equalsIgnoreCase(tag) || "errorShort".equalsIgnoreCase(tag) || "errorLong".equalsIgnoreCase(tag) || "correctionDescription".equalsIgnoreCase(tag));
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }

    protected MessageContextInterface getMessageContext(String hint) {
        return new ElementMessageContext(5, this.currentMerkmal.getId(), this.currentMerkmal.getName(), hint);
    }
}

