/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser.speclanguage.ui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class PLSyntaxTextAreaUI
extends BasicTextAreaUI {
    public static final int TYPE_WHITESPACE = 0;
    public static final int TYPE_COMMENT = 1;
    public static final int TYPE_NUMBER = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_MISC_SYMBOL = 4;
    public static final int TYPE_OPERATOR_SYMBOL = 5;
    public static final int TYPE_OPERATOR_KEYWORD = 6;
    public static final int TYPE_KEYWORD = 7;
    public static final Color DEFAULT_COLOR = Color.black;
    public static final Color COMMENT_COLOR = Color.gray;
    public static final Color NUMBER_COLOR = Color.orange.darker();
    public static final Color STRING_COLOR = Color.green.darker();
    public static final Color MISC_SYMBOL_COLOR = Color.red.darker();
    public static final Color OPERATOR_SYMBOL_COLOR = Color.red.darker();
    public static final Color OPERATOR_KEYWORD_COLOR = Color.red.darker();
    public static final Color KEYWORD_COLOR = Color.blue;
    public static final String[] MISC_SYMBOLS = new String[]{"..", "--", "-+", "+-", "++", ":=", "#", ",", ";", "(", ")", "[", "]", "{", "}", "&", "."};
    public static final String[] OPERATOR_SYMBOLS = new String[]{"/=", "<=", ">=", "*", "/", "+", "-", "=", "<", ">"};
    public static final String[] OPERATOR_KEYWORDS = new String[]{"NICHT", "ODER", "UND", "IN"};
    public static final String[] KEYWORDS = new String[]{"THEMENBEREICH", "WAHRHEITSWERT", "SCHRITTWEITE", "ZEICHENKETTE", "EIGENSCHAFT", "DATUMSWERT", "HOECHSTENS", "MINDESTENS", "WIEDERHOLE", "EXISTIERT", "IDENTISCH", "KATEGORIE", "KOMMAZAHL", "RUECKGABE", "FUNKTION", "GANZZAHL", "MATERIAL", "ABBRUCH", "ELEMENT", "SOLANGE", "VARIANZ", "ABLAUF", "FEHLER", "FALSCH", "ANZAHL", "GLOBAL", "MAPPEN", "MADIAN", "MITTEL", "PRUEFE", "DATUM", "GENAU", "INDEX", "JEDES", "REIHE", "SONST", "STABW", "SUMME", "ALLE", "DANN", "ENDE", "FELD", "FUER", "GILT", "LEER", "NACH", "WAHR", "WENN", "WERT", "ZEIT", "AUS", "BIS", "GIB", "HAT", "IST", "MAX", "MIN", "MIT", "TYP", "VAR", "VON"};
    private Vector syntax = null;

    public static ComponentUI createUI(JComponent c) {
        return new PLSyntaxTextAreaUI();
    }

    public View create(Element element) {
        return new JavaScriptPlainView(element);
    }

    private synchronized void updateSyntax() {
        this.syntax.clear();
        char[] txt = this.getComponent().getText().toCharArray();
        int i = 0;
        int n = txt.length;
        SyntaxSegment syntaxSegment = new SyntaxSegment(0);
        while (i < n) {
            int length = this.getCommentLength(txt, i);
            if (length > 0) {
                if (syntaxSegment.offsetStart < i) {
                    syntaxSegment.offsetEnd = i - 1;
                    this.syntax.add(syntaxSegment);
                    syntaxSegment = new SyntaxSegment(i);
                }
                syntaxSegment.type = 1;
                syntaxSegment.offsetEnd = (i += length) - 1;
                this.syntax.add(syntaxSegment);
                syntaxSegment = new SyntaxSegment(i);
                continue;
            }
            length = this.getNumberLength(txt, i);
            if (length > 0) {
                if (syntaxSegment.offsetStart < i) {
                    syntaxSegment.offsetEnd = i - 1;
                    this.syntax.add(syntaxSegment);
                    syntaxSegment = new SyntaxSegment(i);
                }
                syntaxSegment.type = 2;
                syntaxSegment.offsetEnd = (i += length) - 1;
                this.syntax.add(syntaxSegment);
                syntaxSegment = new SyntaxSegment(i);
                continue;
            }
            length = this.getStringLength(txt, i);
            if (length > 0) {
                if (syntaxSegment.offsetStart < i) {
                    syntaxSegment.offsetEnd = i - 1;
                    this.syntax.add(syntaxSegment);
                    syntaxSegment = new SyntaxSegment(i);
                }
                syntaxSegment.type = 3;
                syntaxSegment.offsetEnd = (i += length) - 1;
                this.syntax.add(syntaxSegment);
                syntaxSegment = new SyntaxSegment(i);
                continue;
            }
            length = this.getMiscSymbolLength(txt, i);
            if (length > 0) {
                if (syntaxSegment.offsetStart < i) {
                    syntaxSegment.offsetEnd = i - 1;
                    this.syntax.add(syntaxSegment);
                    syntaxSegment = new SyntaxSegment(i);
                }
                syntaxSegment.type = 4;
                syntaxSegment.offsetEnd = (i += length) - 1;
                this.syntax.add(syntaxSegment);
                syntaxSegment = new SyntaxSegment(i);
                continue;
            }
            length = this.getOperatorSymbolLength(txt, i);
            if (length > 0) {
                if (syntaxSegment.offsetStart < i) {
                    syntaxSegment.offsetEnd = i - 1;
                    this.syntax.add(syntaxSegment);
                    syntaxSegment = new SyntaxSegment(i);
                }
                syntaxSegment.type = 5;
                syntaxSegment.offsetEnd = (i += length) - 1;
                this.syntax.add(syntaxSegment);
                syntaxSegment = new SyntaxSegment(i);
                continue;
            }
            length = this.getOperatorKeywordLength(txt, i);
            if (length > 0) {
                if (syntaxSegment.offsetStart < i) {
                    syntaxSegment.offsetEnd = i - 1;
                    this.syntax.add(syntaxSegment);
                    syntaxSegment = new SyntaxSegment(i);
                }
                syntaxSegment.type = 6;
                syntaxSegment.offsetEnd = (i += length) - 1;
                this.syntax.add(syntaxSegment);
                syntaxSegment = new SyntaxSegment(i);
                continue;
            }
            length = this.getKeywordLength(txt, i);
            if (length > 0) {
                if (syntaxSegment.offsetStart < i) {
                    syntaxSegment.offsetEnd = i - 1;
                    this.syntax.add(syntaxSegment);
                    syntaxSegment = new SyntaxSegment(i);
                }
                syntaxSegment.type = 7;
                syntaxSegment.offsetEnd = (i += length) - 1;
                this.syntax.add(syntaxSegment);
                syntaxSegment = new SyntaxSegment(i);
                continue;
            }
            length = this.getIndentifierLength(txt, i);
            if (length > 0) {
                i += length;
                continue;
            }
            ++i;
        }
        if (syntaxSegment.offsetStart < n && syntaxSegment.offsetEnd == -1) {
            syntaxSegment.offsetEnd = n - 1;
            this.syntax.add(syntaxSegment);
        }
    }

    private int getCommentLength(char[] txt, int offset) {
        int length = 0;
        if (txt[offset] == '\"') {
            ++length;
            int i = offset + 1;
            while (i < txt.length) {
                if (txt[i] == '\"') {
                    ++length;
                    break;
                }
                ++i;
                ++length;
            }
        }
        return length;
    }

    private int getNumberLength(char[] txt, int offset) {
        int length = 0;
        if (Character.isDigit(txt[offset])) {
            ++length;
            boolean pointParsed = false;
            int i = offset + 1;
            while (i < txt.length) {
                if (txt[i] == '.') {
                    if (pointParsed) break;
                    pointParsed = true;
                } else if (!Character.isDigit(txt[i])) break;
                ++i;
                ++length;
            }
            if (txt[offset + length - 1] == '.') {
                --length;
            }
        }
        return length;
    }

    private int getStringLength(char[] txt, int offset) {
        int length = 0;
        if (txt[offset] == '\'') {
            ++length;
            int i = offset + 1;
            while (i < txt.length) {
                if (txt[i] == '\n') break;
                if (txt[i] == '\'' && txt[i - 1] != '\\') {
                    ++length;
                    break;
                }
                ++i;
                ++length;
            }
        }
        return length;
    }

    private int getMiscSymbolLength(char[] txt, int offset) {
        int length = 0;
        int i = 0;
        while (i < MISC_SYMBOLS.length) {
            if (MISC_SYMBOLS[i].length() <= txt.length - offset && MISC_SYMBOLS[i].equals(new String(txt, offset, MISC_SYMBOLS[i].length()))) {
                length = MISC_SYMBOLS[i].length();
                break;
            }
            ++i;
        }
        return length;
    }

    private int getOperatorSymbolLength(char[] txt, int offset) {
        int length = 0;
        int i = 0;
        while (i < OPERATOR_SYMBOLS.length) {
            if (OPERATOR_SYMBOLS[i].length() <= txt.length - offset && OPERATOR_SYMBOLS[i].equals(new String(txt, offset, OPERATOR_SYMBOLS[i].length()))) {
                length = OPERATOR_SYMBOLS[i].length();
            }
            ++i;
        }
        return length;
    }

    private int getOperatorKeywordLength(char[] txt, int offset) {
        int length = 0;
        int i = 0;
        while (i < OPERATOR_KEYWORDS.length) {
            if (OPERATOR_KEYWORDS[i].length() <= txt.length - offset && OPERATOR_KEYWORDS[i].equals(new String(txt, offset, OPERATOR_KEYWORDS[i].length()))) {
                length = OPERATOR_KEYWORDS[i].length();
                break;
            }
            ++i;
        }
        if (length > 0 && txt.length > offset + length && Character.isJavaIdentifierPart(txt[offset + length])) {
            length = 0;
        }
        return length;
    }

    private int getKeywordLength(char[] txt, int offset) {
        int length = 0;
        int i = 0;
        while (i < KEYWORDS.length) {
            if (KEYWORDS[i].length() <= txt.length - offset && KEYWORDS[i].equals(new String(txt, offset, KEYWORDS[i].length()))) {
                length = KEYWORDS[i].length();
                break;
            }
            ++i;
        }
        if (length > 0 && txt.length > offset + length && Character.isJavaIdentifierPart(txt[offset + length])) {
            length = 0;
        }
        return length;
    }

    private int getIndentifierLength(char[] txt, int offset) {
        int length = 0;
        if (Character.isJavaIdentifierStart(txt[offset])) {
            ++length;
            int i = offset + 1;
            while (i < txt.length) {
                if (!Character.isJavaIdentifierPart(txt[i])) break;
                ++i;
                ++length;
            }
        }
        return length;
    }

    private SyntaxSegment getSyntaxSegment(int offset) throws BadLocationException {
        if (this.syntax == null) {
            this.syntax = new Vector();
            this.updateSyntax();
        }
        int i = 0;
        while (i < this.syntax.size()) {
            SyntaxSegment syntaxSegment = (SyntaxSegment)this.syntax.get(i);
            if (offset >= syntaxSegment.offsetStart && offset <= syntaxSegment.offsetEnd) {
                return syntaxSegment;
            }
            ++i;
        }
        throw new BadLocationException("Kein Segment lokalisiert.", offset);
    }

    private class SyntaxSegment {
        public int offsetStart;
        public int offsetEnd;
        public int type;

        public SyntaxSegment(int offsetStart) {
            this.offsetStart = offsetStart;
            this.offsetEnd = -1;
            this.type = 0;
        }
    }

    private class JavaScriptPlainView
    extends PlainView {
        public JavaScriptPlainView(Element element) {
            super(element);
        }

        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (PLSyntaxTextAreaUI.this.syntax == null) {
                PLSyntaxTextAreaUI.this.syntax = new Vector();
            }
            PLSyntaxTextAreaUI.this.updateSyntax();
            super.insertUpdate(e, a, f);
            PLSyntaxTextAreaUI.this.getComponent().repaint();
        }

        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (PLSyntaxTextAreaUI.this.syntax == null) {
                PLSyntaxTextAreaUI.this.syntax = new Vector();
            }
            PLSyntaxTextAreaUI.this.updateSyntax();
            super.removeUpdate(e, a, f);
            PLSyntaxTextAreaUI.this.getComponent().repaint();
        }

        protected int drawSelectedText(Graphics g, int x, int y, int startOffset, int endOffset) throws BadLocationException {
            if (!PLSyntaxTextAreaUI.this.getComponent().getCaret().isSelectionVisible()) {
                return this.drawText(g, x, y, startOffset, endOffset);
            }
            return super.drawSelectedText(g, x, y, startOffset, endOffset);
        }

        protected int drawUnselectedText(Graphics g, int x, int y, int startOffset, int endOffset) throws BadLocationException {
            return this.drawText(g, x, y, startOffset, endOffset);
        }

        private int drawText(Graphics g, int x, int y, int startOffset, int endOffset) throws BadLocationException {
            Segment segment = new Segment();
            this.getDocument().getText(startOffset, endOffset - startOffset, segment);
            FontMetrics fontMetrics = g.getFontMetrics();
            int nextX = x;
            char[] txt = segment.array;
            int i = segment.offset;
            int n = segment.offset + segment.count;
            while (i < n) {
                if (txt[i] == '\t') {
                    x = nextX = (int)this.nextTabStop(nextX, i);
                    ++i;
                    continue;
                }
                if (txt[i] == '\n' || txt[i] == '\r') {
                    x = nextX;
                    ++i;
                    continue;
                }
                int offset = i - segment.offset + startOffset;
                SyntaxSegment syntaxSegment = PLSyntaxTextAreaUI.this.getSyntaxSegment(offset);
                switch (syntaxSegment.type) {
                    case 1: {
                        g.setColor(COMMENT_COLOR);
                        break;
                    }
                    case 2: {
                        g.setColor(NUMBER_COLOR);
                        break;
                    }
                    case 3: {
                        g.setColor(STRING_COLOR);
                        break;
                    }
                    case 4: {
                        g.setColor(MISC_SYMBOL_COLOR);
                        break;
                    }
                    case 5: {
                        g.setColor(OPERATOR_SYMBOL_COLOR);
                        break;
                    }
                    case 6: {
                        g.setColor(OPERATOR_KEYWORD_COLOR);
                        break;
                    }
                    case 7: {
                        g.setColor(KEYWORD_COLOR);
                        break;
                    }
                    default: {
                        g.setColor(DEFAULT_COLOR);
                    }
                }
                int length = Math.min(n - i, syntaxSegment.offsetEnd - offset + 1);
                g.drawChars(txt, i, length, x, y);
                x = nextX += fontMetrics.charsWidth(txt, i, length);
                i += length;
            }
            return nextX;
        }
    }
}

