/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.DatumMaske;
import de.statspez.pleditor.generator.masken.MaskenParserFaktory;
import de.statspez.pleditor.generator.masken.MaskenParserInterface;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateValue
extends Value {
    private String myValueAsString = null;
    private Date myValue = null;
    private String format = null;
    private SimpleDateFormat formatter = null;

    public DateValue(String specification, String format) {
        this.myValueAsString = specification;
        this.format = format;
        this.formatter = DateValue.createDateFormatter(format);
        this.formatter.setLenient(false);
    }

    public DateValue(Date date, String format) {
        this.myValue = date;
        this.format = format;
        this.formatter = DateValue.createDateFormatter(format);
    }

    public String getFormat() {
        return this.format;
    }

    public double asDouble() throws ValueConversionException {
        throw new ValueConversionException("Ein Datum kann nicht in eine Zahl konvertiert werden.");
    }

    public long asLong() throws ValueConversionException {
        throw new ValueConversionException("Ein Datum kann nicht in eine Zahl konvertiert werden.");
    }

    public boolean asBoolean() throws ValueConversionException {
        throw new ValueConversionException("Ein Datum kann nicht in einen boolschen Wert werden.");
    }

    public String asString() throws ValueConversionException {
        if (this.myValueAsString != null) {
            return this.myValueAsString;
        }
        return this.formatter.format(this.date());
    }

    public Date date() {
        if (this.myValue == null) {
            try {
                if (!this.isDateValueValid(this.format)) {
                    throw new ValueConversionException("Der Wert passt nicht zur definierten Maske.");
                }
                this.myValue = this.formatter.parse(this.myValueAsString);
            }
            catch (Exception e) {
                throw new ValueConversionException("Das Datum " + this.myValueAsString + " (formatiert mit " + this.format + ") ist fehlerhaft.");
            }
        }
        return this.myValue;
    }

    public boolean isDateValueValid(String mask) {
        boolean valid;
        try {
            MaskenParserInterface parser = MaskenParserFaktory.getInstance().getMaskenParserFuerTyp(2);
            AbstractMaske maske = parser.parse(mask);
            valid = maske.isWertGueltig(this.asString());
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    protected int operatorLevel() {
        return 6;
    }

    protected boolean eqImpl(Value aValue) {
        if (aValue == null || aValue == NilValue.instance() || !aValue.isValid()) {
            return false;
        }
        this.ensureIsDateValue(aValue);
        return this.date().compareTo(((DateValue)aValue).date()) == 0;
    }

    protected boolean ltImpl(Value aValue) {
        this.ensureIsDateValue(aValue);
        return this.date().compareTo(((DateValue)aValue).date()) < 0;
    }

    protected boolean leImpl(Value aValue) {
        this.ensureIsDateValue(aValue);
        return this.date().compareTo(((DateValue)aValue).date()) <= 0;
    }

    protected boolean gtImpl(Value aValue) {
        this.ensureIsDateValue(aValue);
        return this.date().compareTo(((DateValue)aValue).date()) > 0;
    }

    protected boolean geImpl(Value aValue) {
        this.ensureIsDateValue(aValue);
        return this.date().compareTo(((DateValue)aValue).date()) >= 0;
    }

    protected boolean neImpl(Value aValue) {
        if (aValue == null || aValue == NilValue.instance() || !aValue.isValid()) {
            return true;
        }
        this.ensureIsDateValue(aValue);
        return this.date().compareTo(((DateValue)aValue).date()) != 0;
    }

    protected boolean containsImpl(Value aValue) {
        this.ensureIsDateValue(aValue);
        return this.eq(aValue);
    }

    private void ensureIsDateValue(Object anObject) {
        if (!(anObject instanceof DateValue)) {
            throw new ValueConversionException("Datumswerte koennen nur mit Datumswertenverglichen werden.");
        }
    }

    private static SimpleDateFormat createDateFormatter(String format) {
        try {
            MaskenParserInterface parser = MaskenParserFaktory.getInstance().getMaskenParserFuerTyp(2);
            DatumMaske maske = (DatumMaske)parser.parse(format);
            return maske.getSimpleDateFormat();
        }
        catch (Exception e) {
            throw new ValueConversionException("Das Datumsformat " + format + " ist fehlerhaft.");
        }
    }
}

