/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.Array;
import de.statspez.pleditor.generator.runtime.DateValue;
import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeIterator;
import de.statspez.pleditor.generator.runtime.Range;
import de.statspez.pleditor.generator.runtime.RangeSeries;
import de.statspez.pleditor.generator.runtime.SequenceRange;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;
import de.statspez.pleditor.generator.runtime.ValueFactory;
import de.statspez.pleditor.generator.runtime.Variable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.Vector;

public class FunctionLib {
    public static Value EXPONENT(PlausiRuntimeContext context, Value x, Value y) {
        return ValueFactory.instance().valueFor(Math.pow(x.asDouble(), y.asDouble()));
    }

    public static Value MODULO(PlausiRuntimeContext context, Value x, Value y) {
        if (y == null || !y.isValid() || y == NilValue.instance()) {
            String fehler = "MODULO: Division durch Null-Wert.";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        if (y.eq(ValueFactory.instance().valueFor(0.0))) {
            String fehler = "MODULO: Division durch Null (" + y + ").";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        if (x == null || !x.isValid() || x == NilValue.instance()) {
            return InvalidValue.instance();
        }
        return ValueFactory.instance().valueFor(x.asDouble() % y.asDouble());
    }

    public static Value ZUFALLSZAHL_AUS_LISTE(PlausiRuntimeContext context, Array liste) {
        Random random = new Random();
        return ((Variable)liste.getElement(context, new int[]{random.nextInt(liste.getLengthOfDimension(context, null))})).get(context);
    }

    public static Value ZUFALLSZAHL_AUS_REIHE(PlausiRuntimeContext context, Value reihe) {
        if (!(reihe instanceof RangeSeries) && !(reihe instanceof SequenceRange)) {
            throw new ValueConversionException("Der Wert ist keine Reihe oder Sequenz");
        }
        Vector<Value> v = new Vector<Value>();
        PlausiRuntimeIterator it = ((Range)reihe).iterator();
        while (it.hasNext()) {
            v.add((Value)it.next());
        }
        Random r = new Random();
        return (Value)v.elementAt(r.nextInt(v.size()));
    }

    public static Value JAHR(PlausiRuntimeContext context, Value value) throws ValueConversionException {
        if (value != null && value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            if (dateValue.getFormat() != null && dateValue.getFormat().length() > 0) {
                if (dateValue.getFormat().indexOf("JJJJ") >= 0) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
                    Double d_jahr = new Double(formatter.format(((DateValue)value).date()));
                    return ValueFactory.instance().valueFor(d_jahr);
                }
                if (dateValue.getFormat().indexOf("JJ") >= 0) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yy");
                    Double d_jahr = new Double(formatter.format(((DateValue)value).date()));
                    return ValueFactory.instance().valueFor(d_jahr);
                }
            }
            throw new ValueConversionException("Jahrwert ist im Datumswert nicht enthalten.");
        }
        throw new ValueConversionException("Jahrwert kann nur aus Datumswert berechnet werden.");
    }

    public static Value JAHR_ALS_ZEICHENKETTE(PlausiRuntimeContext context, Value value) throws ValueConversionException {
        if (value != null && value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            if (dateValue.getFormat() != null && dateValue.getFormat().length() > 0) {
                if (dateValue.getFormat().indexOf("JJJJ") >= 0) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy");
                    return ValueFactory.instance().valueFor(formatter.format(((DateValue)value).date()));
                }
                if (dateValue.getFormat().indexOf("JJ") >= 0) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yy");
                    return ValueFactory.instance().valueFor(formatter.format(((DateValue)value).date()));
                }
            }
            throw new ValueConversionException("Jahrwert ist im Datumswert nicht enthalten.");
        }
        throw new ValueConversionException("Jahrwert kann nur aus Datumswert berechnet werden.");
    }

    public static Value MONAT(PlausiRuntimeContext context, Value value) throws ValueConversionException {
        if (value != null && value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            if (dateValue.getFormat() != null && dateValue.getFormat().length() > 0 && dateValue.getFormat().indexOf("MM") >= 0) {
                SimpleDateFormat formatter = new SimpleDateFormat("MM");
                Double d_jahr = new Double(formatter.format(((DateValue)value).date()));
                return ValueFactory.instance().valueFor(d_jahr);
            }
            throw new ValueConversionException("Monatswert ist im Datumswert nicht enthalten.");
        }
        throw new ValueConversionException("Monatswert kann nur aus Datumswert berechnet werden.");
    }

    public static Value MONAT_ALS_ZEICHENKETTE(PlausiRuntimeContext context, Value value) throws ValueConversionException {
        if (value != null && value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            if (dateValue.getFormat() != null && dateValue.getFormat().length() > 0 && dateValue.getFormat().indexOf("MM") >= 0) {
                SimpleDateFormat formatter = new SimpleDateFormat("MM");
                return ValueFactory.instance().valueFor(formatter.format(((DateValue)value).date()));
            }
            throw new ValueConversionException("Monatswert ist im Datumswert nicht enthalten.");
        }
        throw new ValueConversionException("Monatswert kann nur aus Datumswert berechnet werden.");
    }

    public static Value TAG(PlausiRuntimeContext context, Value value) throws ValueConversionException {
        if (value != null && value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            if (dateValue.getFormat() != null && dateValue.getFormat().length() > 0 && dateValue.getFormat().indexOf("TT") >= 0) {
                SimpleDateFormat formatter = new SimpleDateFormat("dd");
                Double d_jahr = new Double(formatter.format(((DateValue)value).date()));
                return ValueFactory.instance().valueFor(d_jahr);
            }
            throw new ValueConversionException("Tageswert ist im Datumswert nicht enthalten.");
        }
        throw new ValueConversionException("Tageswert kann nur aus Datumswert berechnet werden.");
    }

    public static Value TAG_ALS_ZEICHENKETTE(PlausiRuntimeContext context, Value value) throws ValueConversionException {
        if (value != null && value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            if (dateValue.getFormat() != null && dateValue.getFormat().length() > 0 && dateValue.getFormat().indexOf("TT") >= 0) {
                SimpleDateFormat formatter = new SimpleDateFormat("dd");
                return ValueFactory.instance().valueFor(formatter.format(((DateValue)value).date()));
            }
            throw new ValueConversionException("Tageswert ist im Datumswert nicht enthalten.");
        }
        throw new ValueConversionException("Tageswert kann nur aus Datumswert berechnet werden.");
    }

    public static Value HEUTE(PlausiRuntimeContext context) {
        return new DateValue(new Date(), "TT.MM.JJJJ");
    }

    public static Value TEIL(PlausiRuntimeContext context, Value value, Value start, Value laenge) {
        if (value != null) {
            if (start == null || start.asLong() > Integer.MAX_VALUE) {
                throw new ValueConversionException("Der Startindex ist ungueltig: " + start);
            }
            if (laenge == null || laenge.asLong() > Integer.MAX_VALUE) {
                throw new ValueConversionException("Der Laenge des Teilstrings ist ungueltig: " + laenge);
            }
            String str_value = value.asString();
            String erg = "";
            int startIndex = (int)start.asLong() - 1;
            if (startIndex < 0) {
                startIndex = 0;
            }
            if (str_value != null && startIndex < str_value.length()) {
                int endIndex = startIndex + (int)laenge.asLong();
                erg = laenge.asLong() > 0L && endIndex < str_value.length() ? str_value.substring(startIndex, endIndex) : str_value.substring(startIndex);
            }
            return ValueFactory.instance().valueFor(erg);
        }
        throw new ValueConversionException("Die Zeichenkette kann nur aus einer Zeichenkette ausgelesen werden.");
    }

    public static Value KONKATENIEREN(PlausiRuntimeContext context, Value start, Value end) {
        String startStr = "";
        String endStr = "";
        if (start != null && start.isValid() && start != NilValue.instance()) {
            startStr = start.asString();
        }
        if (end != null && end.isValid() && end != NilValue.instance()) {
            endStr = end.asString();
        }
        return ValueFactory.instance().valueFor(String.valueOf(startStr) + endStr);
    }

    public static Value ERSETZEN(PlausiRuntimeContext context, Value text, Value zeichenfolge, Value neueZeichenfolge) {
        String s = "";
        String m = "";
        String r = "";
        if (text != null && text.isValid() && text != NilValue.instance()) {
            s = text.asString();
        }
        if (zeichenfolge != null && zeichenfolge.isValid() && zeichenfolge != NilValue.instance()) {
            m = zeichenfolge.asString();
        }
        if (neueZeichenfolge != null && neueZeichenfolge.isValid() && neueZeichenfolge != NilValue.instance()) {
            r = neueZeichenfolge.asString();
        }
        if (s.length() > 0 && m.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < s.length()) {
                if (s.substring(i).startsWith(m)) {
                    buffer.append(r);
                    i += m.length() - 1;
                } else {
                    buffer.append(s.charAt(i));
                }
                ++i;
            }
            s = buffer.toString();
        }
        return ValueFactory.instance().valueFor(s);
    }

    public static Value WERTLAENGE(PlausiRuntimeContext context, Value wert) {
        int erg = 0;
        String wertStr = "";
        if (wert != null) {
            wertStr = wert.asString();
        }
        if (wertStr != null) {
            erg = wertStr.length();
        }
        return ValueFactory.instance().valueFor(erg);
    }

    public static Value ENDET_AUF(PlausiRuntimeContext context, Value wert, Value suffix) {
        boolean erg = false;
        if (wert != null) {
            erg = suffix != null ? wert.asString().endsWith(suffix.asString()) : true;
        }
        return ValueFactory.instance().valueFor(erg);
    }

    public static Value BEGINNT_MIT(PlausiRuntimeContext context, Value wert, Value prefix) {
        boolean erg = false;
        if (wert != null) {
            erg = prefix != null ? wert.asString().startsWith(prefix.asString()) : true;
        }
        return ValueFactory.instance().valueFor(erg);
    }

    public static Value GROSSBUCHSTABEN(PlausiRuntimeContext context, Value wert) {
        String wertStr = "";
        if (wert != null) {
            wertStr = wert.asString();
        }
        return ValueFactory.instance().valueFor(wertStr.toUpperCase());
    }

    public static Value KLEINBUCHSTABEN(PlausiRuntimeContext context, Value wert) {
        String wertStr = "";
        if (wert != null) {
            wertStr = wert.asString();
        }
        return ValueFactory.instance().valueFor(wertStr.toLowerCase());
    }

    public static Value NUMERISCH(PlausiRuntimeContext context, Value wert) {
        String wertStr = "";
        if (wert != null) {
            wertStr = wert.asString();
        }
        boolean erg = true;
        char[] chars = wertStr.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Character.isDigit(chars[i])) {
                erg = false;
                break;
            }
            ++i;
        }
        return ValueFactory.instance().valueFor(erg);
    }

    public static Value HAT_FORMAT(PlausiRuntimeContext context, Value format, Value wert) {
        String formatStr = "";
        if (format != null) {
            formatStr = format.asString();
        }
        String wertStr = "";
        if (wert != null) {
            wertStr = wert.asString();
        }
        return ValueFactory.instance().valueFor(wertStr.matches(formatStr));
    }

    public static Value RUNDEN(PlausiRuntimeContext context, Value wert, Value nachkommastellen) throws ValueConversionException {
        if (wert != null && wert instanceof NumberValue) {
            double faktor = 1.0;
            if (nachkommastellen != null) {
                faktor = Math.pow(10.0, nachkommastellen.asLong());
            }
            double rounder = 0.5;
            if (wert.asDouble() < 0.0) {
                rounder = -0.5;
            }
            long ganzzahl = (long)(wert.asDouble() * faktor + rounder);
            return ValueFactory.instance().valueFor((double)ganzzahl / faktor);
        }
        throw new ValueConversionException("Nur Zahlen d\u00fcrfen gerundet werden.");
    }

    public static Value ALS_GANZZAHL(PlausiRuntimeContext context, Value wert) {
        Value wertNeu = wert;
        if (wertNeu != null && wertNeu.isValid() && wertNeu != NilValue.instance()) {
            wertNeu = ValueFactory.instance().valueFor((long)(wert.asDouble() + 0.5));
        }
        return wertNeu;
    }

    public static Value ALS_KOMMAZAHL(PlausiRuntimeContext context, Value wert) {
        Value wertNeu = wert;
        if (wertNeu != null && wertNeu.isValid() && wertNeu != NilValue.instance()) {
            wertNeu = ValueFactory.instance().valueFor(wert.asDouble());
        }
        return wertNeu;
    }

    public static Value ALS_ZEICHENKETTE(PlausiRuntimeContext context, Value wert) {
        Value wertNeu = wert;
        if (wertNeu != null && wertNeu.isValid() && wertNeu != NilValue.instance()) {
            wertNeu = ValueFactory.instance().valueFor(wert.asString());
        }
        return wertNeu;
    }
}

