/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test;

import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import junit.framework.TestCase;

public class ScopeTest
extends TestCase {
    private static final String NAMESPACE = "test";
    private static final String ID1 = "ID1";
    private static final String ID2 = "ID2";
    private Scope scope1 = null;
    private Scope scope2 = null;

    public ScopeTest(String arg0) {
        super(arg0);
    }

    public void test_01_nosuperscope() throws Exception {
        MetaIdentifier id1 = new MetaIdentifier(ID1);
        MetaIdentifier foo = new MetaIdentifier("foo");
        ScopeTest.assertTrue((boolean)this.scope1.isDefined(id1, NAMESPACE));
        ScopeTest.assertFalse((boolean)this.scope1.isDefined(foo, NAMESPACE));
        this.scope1.setProperty(id1, NAMESPACE, "foo", "bar");
        ScopeTest.assertEquals((Object)"bar", (Object)this.scope1.property(id1, NAMESPACE, "foo"));
        ScopeTest.assertNull((Object)this.scope1.property(id1, NAMESPACE, "bar"));
        try {
            this.scope1.define(id1, NAMESPACE);
            ScopeTest.fail((String)"redefinition succeeded");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.scope1.setProperty(foo, NAMESPACE, "foo", "bar");
            ScopeTest.fail((String)"set property for undefined id succeeded");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.scope1.property(foo, NAMESPACE, "foo");
            ScopeTest.fail((String)"get property for undefined id succeeded");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_02_superscope() throws Exception {
        MetaIdentifier id1 = new MetaIdentifier(ID1);
        MetaIdentifier id2 = new MetaIdentifier(ID2);
        MetaIdentifier foo = new MetaIdentifier("foo");
        ScopeTest.assertTrue((boolean)this.scope2.isDefined(id1, NAMESPACE));
        ScopeTest.assertTrue((boolean)this.scope2.isDefined(id2, NAMESPACE));
        ScopeTest.assertFalse((boolean)this.scope2.isDefined(foo, NAMESPACE));
        this.scope2.setProperty(id1, NAMESPACE, "foo", "bar");
        ScopeTest.assertEquals((Object)"bar", (Object)this.scope2.property(id1, NAMESPACE, "foo"));
        this.scope2.setProperty(id2, NAMESPACE, "foo", "bar");
        ScopeTest.assertEquals((Object)"bar", (Object)this.scope2.property(id2, NAMESPACE, "foo"));
        ScopeTest.assertNull((Object)this.scope2.property(id1, NAMESPACE, "bar"));
        ScopeTest.assertNull((Object)this.scope2.property(id2, NAMESPACE, "bar"));
        try {
            this.scope2.define(id1, NAMESPACE);
            ScopeTest.fail((String)"redefinition succeeded");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.scope2.define(id2, NAMESPACE);
            ScopeTest.fail((String)"redefinition succeeded");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.scope2.setProperty(foo, NAMESPACE, "foo", "bar");
            ScopeTest.fail((String)"set property for undefined id succeeded");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.scope2.property(foo, NAMESPACE, "foo");
            ScopeTest.fail((String)"get property for undefined id succeeded");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void setUp() {
        this.scope1 = new ScopeImpl();
        MetaIdentifier id1 = new MetaIdentifier(ID1);
        this.scope1.define(id1, NAMESPACE);
        this.scope2 = new ScopeImpl(this.scope1);
        MetaIdentifier id2 = new MetaIdentifier(ID2);
        this.scope2.define(id2, NAMESPACE);
    }
}

