/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test.inspector;

import de.statspez.pleditor.generator.codeassist.CustomSyntaxElement;
import de.statspez.pleditor.generator.codeassist.ui.CodeAssistantWindow;
import de.statspez.pleditor.generator.codeassist.ui.ScopeProvider;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.parser.speclanguage.Parser;
import de.statspez.pleditor.generator.parser.speclanguage.Scanner;
import de.statspez.pleditor.generator.parser.speclanguage.SpecLangParseException;
import de.statspez.pleditor.generator.parser.speclanguage.ui.PLSyntaxTextAreaUI;
import de.statspez.pleditor.generator.test.inspector.TreeBuilder;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class SyntaxTreeInspector
implements ScopeProvider {
    public static Dimension DEFAULT_SIZE = new Dimension(400, 500);
    public static Point DEFAULT_POSITION = new Point(100, 50);
    public static int DEFAULT_SOURCE_WIDTH = 500;
    public static Font SOURCE_FONT = new Font("Monospaced", 0, 12);
    private JFrame theTreeFrame = null;
    private JFrame theSourceFrame = null;
    private boolean withSource;
    private boolean treeIsShown;
    private JTree treeView = null;
    private JTextArea sourceEditor = null;
    private JLabel sourceStatusLine = null;
    private JButton showSourceButton = null;
    private JButton parseButton = null;
    private JTextArea errorMessages = null;
    private Dimension sourceWindowSize = null;
    private Point sourceWindowPosition = null;
    private String sourceWindowContent = "";
    private File sourceCurrentDirectory = new File(".");

    public SyntaxTreeInspector(MetaElement syntax) {
        this.withSource = false;
        this.createTreeWindow();
        this.setSyntax(syntax);
    }

    public SyntaxTreeInspector(String source) {
        this.withSource = true;
        this.createTreeWindow();
        this.sourceWindowContent = source;
    }

    public void show() {
        this.show(DEFAULT_POSITION, DEFAULT_SIZE);
    }

    public void show(Point position, Dimension size) {
        this.theTreeFrame.setSize(size);
        this.theTreeFrame.setLocation(position);
        this.theTreeFrame.show();
        if (this.withSource) {
            this.showSourceWindow();
        }
    }

    public synchronized void exit() {
        this.theTreeFrame.dispose();
        if (this.theSourceFrame != null) {
            this.theSourceFrame.dispose();
        }
        System.exit(0);
    }

    public synchronized void closeSourceWindow() {
        if (this.theSourceFrame != null) {
            this.sourceWindowSize = this.theSourceFrame.getSize();
            this.sourceWindowPosition = this.theSourceFrame.getLocation();
            this.sourceWindowContent = this.sourceEditor.getText();
            this.theSourceFrame.dispose();
            this.theSourceFrame = null;
            this.sourceEditor = null;
            this.showSourceButton.setEnabled(true);
            this.parseButton.setEnabled(false);
        }
    }

    public synchronized void showSourceWindow() {
        if (this.theSourceFrame != null) {
            return;
        }
        this.createSourceWindow(this.sourceWindowContent);
        if (this.sourceWindowSize == null) {
            this.sourceWindowSize = new Dimension(DEFAULT_SOURCE_WIDTH, (int)this.theTreeFrame.getSize().getHeight());
        }
        if (this.sourceWindowPosition == null) {
            this.sourceWindowPosition = new Point((int)(this.theTreeFrame.getLocation().getX() + this.theTreeFrame.getSize().getWidth()), (int)this.theTreeFrame.getLocation().getY());
        }
        this.theSourceFrame.setSize(this.sourceWindowSize);
        this.theSourceFrame.setLocation(this.sourceWindowPosition);
        this.theSourceFrame.show();
        this.showSourceButton.setEnabled(false);
        this.parseButton.setEnabled(true);
    }

    public synchronized void parseSource() {
        if (this.sourceEditor == null) {
            return;
        }
        StringReader reader = new StringReader(this.sourceEditor.getText());
        Scanner scanner = new Scanner(reader);
        try {
            try {
                MetaElement syntax = Parser.parse(scanner);
                this.treeView.setModel(TreeBuilder.createTree(syntax));
                this.showTree();
            }
            catch (SpecLangParseException exc) {
                exc.printStackTrace();
                StringBuffer msg = new StringBuffer();
                msg.append("There where parse errors:\n");
                msg.append(exc.getMessage());
                msg.append(exc.messagesAsText());
                this.showErrors(msg.toString());
            }
            catch (Exception exc) {
                exc.printStackTrace();
                StringBuffer msg = new StringBuffer();
                msg.append("There where errors:\n");
                msg.append(exc.getMessage());
                this.showErrors(msg.toString());
            }
        }
        finally {
            reader.close();
        }
    }

    public void setSyntax(MetaElement syntax) {
        this.treeView.setModel(TreeBuilder.createTree(syntax));
        this.showTree();
    }

    public synchronized void saveSource() {
        if (this.theSourceFrame == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser(this.sourceCurrentDirectory);
        int rc = chooser.showSaveDialog(this.theSourceFrame);
        if (rc == 0) {
            try {
                FileOutputStream fout = new FileOutputStream(chooser.getSelectedFile());
                fout.write(this.sourceEditor.getText().getBytes());
                fout.flush();
                fout.close();
                this.sourceCurrentDirectory = chooser.getSelectedFile().getParentFile();
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(this.theSourceFrame, exc.getMessage(), "Error during save operation!", 0);
            }
        }
    }

    public synchronized void openSource() {
        if (this.theSourceFrame == null) {
            return;
        }
        JFileChooser chooser = new JFileChooser(this.sourceCurrentDirectory);
        int rc = chooser.showOpenDialog(this.theSourceFrame);
        if (rc == 0) {
            try {
                StringBuffer source = new StringBuffer();
                FileReader freader = new FileReader(chooser.getSelectedFile());
                BufferedReader breader = new BufferedReader(freader);
                String aLine = breader.readLine();
                while (aLine != null) {
                    source.append(aLine);
                    source.append('\n');
                    aLine = breader.readLine();
                }
                freader.close();
                breader.close();
                this.sourceCurrentDirectory = chooser.getSelectedFile().getParentFile();
                this.sourceEditor.setText(source.toString());
                this.parseSource();
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(this.theSourceFrame, exc.getMessage(), "Error during open operation!", 0);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        StringBuffer source = new StringBuffer();
        if (args.length > 0) {
            File f = new File(args[0]);
            FileReader freader = new FileReader(f);
            BufferedReader breader = new BufferedReader(freader);
            String aLine = breader.readLine();
            while (aLine != null) {
                source.append(aLine);
                source.append('\n');
                aLine = breader.readLine();
            }
            freader.close();
            breader.close();
        }
        SyntaxTreeInspector inspector = new SyntaxTreeInspector(source.toString());
        inspector.show();
    }

    private void createTreeWindow() {
        this.theTreeFrame = new JFrame("Syntax Tree Inspector");
        this.theTreeFrame.addWindowListener(new InspectorWindowListener());
        InspectorActionListener al = new InspectorActionListener();
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.theTreeFrame.getContentPane().add(mainPanel);
        JPanel treePanel = new JPanel(new CardLayout());
        this.treeView = new JTree();
        JScrollPane treeScroll = new JScrollPane();
        treeScroll.getViewport().add(this.treeView);
        treePanel.add((Component)treeScroll, "TREE");
        this.errorMessages = new JTextArea();
        this.errorMessages.setEditable(false);
        JScrollPane errorScroll = new JScrollPane();
        errorScroll.getViewport().add(this.errorMessages);
        treePanel.add((Component)errorScroll, "ERRORS");
        JButton exitButton = new JButton("Exit");
        exitButton.setActionCommand("EXIT");
        exitButton.addActionListener(al);
        if (this.withSource) {
            this.showSourceButton = new JButton("show sourcecode");
            this.showSourceButton.setActionCommand("SHOW_SOURCE");
            this.showSourceButton.addActionListener(al);
            this.showSourceButton.setEnabled(true);
            this.parseButton = new JButton("parse sourcecode");
            this.parseButton.setActionCommand("PARSE_SOURCE");
            this.parseButton.addActionListener(al);
            this.parseButton.setEnabled(true);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.anchor = 18;
        c.ipady = 0;
        c.ipadx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 5, 5);
        mainPanel.add((Component)treePanel, c);
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 5));
        buttonPanel.add(exitButton);
        if (this.withSource) {
            buttonPanel.add(this.showSourceButton);
            buttonPanel.add(this.parseButton);
        }
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 0;
        c.anchor = 10;
        c.ipady = 0;
        c.ipadx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 5, 5);
        mainPanel.add((Component)buttonPanel, c);
        this.treeView.addTreeSelectionListener(new TreeSourceConnector());
        this.treeIsShown = true;
        this.showErrors("nothing parsed");
    }

    private void createSourceWindow(String source) {
        this.theSourceFrame = new JFrame("Source Code");
        this.theSourceFrame.addWindowListener(new InspectorWindowListener());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.theSourceFrame.getContentPane().add(mainPanel);
        InspectorActionListener al = new InspectorActionListener();
        this.sourceStatusLine = new JLabel("");
        JButton closeButton = new JButton("Close");
        closeButton.setActionCommand("CLOSE_SOURCE");
        closeButton.addActionListener(al);
        JButton saveButton = new JButton("Save");
        saveButton.setActionCommand("SAVE_SOURCE");
        saveButton.addActionListener(al);
        JButton openButton = new JButton("Open");
        openButton.setActionCommand("OPEN_SOURCE");
        openButton.addActionListener(al);
        this.sourceEditor = new JTextArea(source);
        new CodeAssistantWindow(this.sourceEditor, this);
        this.sourceEditor.setUI(new PLSyntaxTextAreaUI());
        this.sourceEditor.setCaretPosition(0);
        this.sourceEditor.setFont(SOURCE_FONT);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 3;
        c.anchor = 18;
        c.ipady = 0;
        c.ipadx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        mainPanel.add((Component)this.sourceStatusLine, c);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.anchor = 18;
        c.ipady = 0;
        c.ipadx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(5, 5, 5, 5);
        JScrollPane sourceScroll = new JScrollPane();
        sourceScroll.getViewport().add(this.sourceEditor);
        mainPanel.add((Component)sourceScroll, c);
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 5));
        buttonPanel.add(closeButton);
        buttonPanel.add(openButton);
        buttonPanel.add(saveButton);
        c.gridx = 0;
        c.gridy = 2;
        c.fill = 0;
        c.anchor = 10;
        c.ipady = 0;
        c.ipadx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        mainPanel.add((Component)buttonPanel, c);
    }

    private void showTree() {
        if (this.treeIsShown) {
            return;
        }
        JPanel mainPanel = (JPanel)this.theTreeFrame.getContentPane().getComponent(0);
        JPanel treePanel = (JPanel)mainPanel.getComponent(0);
        CardLayout layout = (CardLayout)treePanel.getLayout();
        layout.show(treePanel, "TREE");
        this.treeIsShown = true;
    }

    private void showErrors(String errors) {
        this.errorMessages.setText(errors);
        if (!this.treeIsShown) {
            return;
        }
        JPanel mainPanel = (JPanel)this.theTreeFrame.getContentPane().getComponent(0);
        JPanel treePanel = (JPanel)mainPanel.getComponent(0);
        CardLayout layout = (CardLayout)treePanel.getLayout();
        layout.show(treePanel, "ERRORS");
        this.treeIsShown = false;
    }

    private int getSourcePosition(int line, int column) {
        int currentPos = 0;
        int currentLine = 1;
        int currentCol = 1;
        String source = this.sourceEditor.getText();
        while ((currentLine != line || currentCol != column) && currentPos < source.length()) {
            if (currentPos >= source.length()) continue;
            if (source.charAt(currentPos) == '\n') {
                ++currentLine;
                currentCol = 1;
            } else {
                ++currentCol;
            }
            ++currentPos;
        }
        if (currentPos >= source.length()) {
            currentPos = -1;
        }
        return currentPos;
    }

    public ScopeImpl getScope() {
        return new ScopeImpl();
    }

    public int getScopeType() {
        return 1;
    }

    public CustomSyntaxElement[] getCustomChoices() {
        return null;
    }

    public boolean handleCustomChoice(CustomSyntaxElement choice) {
        return false;
    }

    private class InspectorWindowListener
    extends WindowAdapter {
        private InspectorWindowListener() {
        }

        public void windowClosing(WindowEvent event) {
            if (event.getSource() == SyntaxTreeInspector.this.theTreeFrame) {
                SyntaxTreeInspector.this.exit();
            } else if (event.getSource() == SyntaxTreeInspector.this.theSourceFrame) {
                SyntaxTreeInspector.this.closeSourceWindow();
            }
        }
    }

    private class InspectorActionListener
    implements ActionListener {
        public static final String EXIT_COMMAND = "EXIT";
        public static final String CLOSE_SOURCE_COMMAND = "CLOSE_SOURCE";
        public static final String SHOW_SOURCE_COMMAND = "SHOW_SOURCE";
        public static final String PARSE_SOURCE_COMMAND = "PARSE_SOURCE";
        public static final String SAVE_SOURCE_COMMAND = "SAVE_SOURCE";
        public static final String OPEN_SOURCE_COMMAND = "OPEN_SOURCE";

        private InspectorActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals(EXIT_COMMAND)) {
                SyntaxTreeInspector.this.exit();
            } else if (event.getActionCommand().equals(CLOSE_SOURCE_COMMAND)) {
                SyntaxTreeInspector.this.closeSourceWindow();
            } else if (event.getActionCommand().equals(SHOW_SOURCE_COMMAND)) {
                SyntaxTreeInspector.this.showSourceWindow();
            } else if (event.getActionCommand().equals(PARSE_SOURCE_COMMAND)) {
                SyntaxTreeInspector.this.parseSource();
            } else if (event.getActionCommand().equals(SAVE_SOURCE_COMMAND)) {
                SyntaxTreeInspector.this.saveSource();
            } else if (event.getActionCommand().equals(OPEN_SOURCE_COMMAND)) {
                SyntaxTreeInspector.this.openSource();
            }
        }
    }

    private class TreeSourceConnector
    implements TreeSelectionListener {
        private TreeSourceConnector() {
        }

        public void valueChanged(TreeSelectionEvent event) {
            TreePath selectionPath = event.getNewLeadSelectionPath();
            if (selectionPath == null) {
                return;
            }
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
            if (selectedNode.getUserObject() instanceof MetaElement) {
                MetaElement meta = (MetaElement)selectedNode.getUserObject();
                if (SyntaxTreeInspector.this.sourceEditor != null) {
                    SyntaxTreeInspector.this.sourceStatusLine.setText("");
                    this.indicateSourcePosition(meta);
                }
            }
        }

        private void indicateSourcePosition(MetaElement meta) {
            if (meta.startLine() != -1 && meta.startColumn() != -1) {
                int startPos = SyntaxTreeInspector.this.getSourcePosition(meta.startLine(), meta.startColumn());
                if (startPos == -1) {
                    SyntaxTreeInspector.this.sourceStatusLine.setText("Unable to locate source position line " + meta.startLine() + " column " + meta.startColumn());
                    return;
                }
                SyntaxTreeInspector.this.sourceEditor.setCaretPosition(startPos);
                SyntaxTreeInspector.this.sourceEditor.moveCaretPosition(startPos + 1);
            } else {
                SyntaxTreeInspector.this.sourceStatusLine.setText("No position specified for this element");
            }
        }
    }
}

