/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.validator;

import de.statspez.pleditor.generator.validator.ValidationException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class EdtValidator
extends DefaultHandler {
    private Vector openedReaders = new Vector();
    private static final String SCHEMA_DIR = "edt/";
    public static final String EDT_XMLNS = "http://www.werum.de/pl-editor";
    private static final String EDT_SCHEMA = "datml-edt.xsd";
    public static final String SSP_XMLNS = "http://www.destatis.de/schema/datml-ssp/1.0";
    private static final String SSP_SCHEMA = "datml-ssp-frame-1.xsd";

    public void validate(Reader xmlReader) throws ValidationException {
        if (xmlReader == null) {
            throw new ValidationException("Das XML-Dokument ist leer!", null);
        }
        SAXParser reader = new SAXParser();
        reader.setContentHandler(this);
        reader.setErrorHandler(this);
        reader.setEntityResolver(this);
        try {
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", "http://www.werum.de/pl-editor datml-edt.xsd");
            reader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", new XMLGrammarPoolImpl());
        }
        catch (Exception exc) {
            System.err.println("Unerwarteter Fehler:");
            exc.printStackTrace();
            throw new RuntimeException(exc);
        }
        try {
            reader.parse(new InputSource(xmlReader));
        }
        catch (IOException exc) {
            System.err.println("Bei der Validierung des XML-Dokuments ist ein unerwarteter Fehler aufgetreten:");
            exc.printStackTrace();
            throw new RuntimeException(exc);
        }
        catch (SAXParseException exc) {
            exc.printStackTrace();
            throw new ValidationException(exc);
        }
        catch (SAXException exc) {
            if (exc.getException() != null && exc.getException() instanceof ValidationException) {
                throw (ValidationException)exc.getException();
            }
            System.err.println("Unerwarteter Fehler beim Parsen des XML-Dokuments aufgetreten!");
            exc.printStackTrace();
            throw new ValidationException(exc.getMessage(), null);
        }
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        int idx = 0;
        while (idx < this.openedReaders.size()) {
            try {
                ((Reader)this.openedReaders.get(idx)).close();
            }
            catch (IOException exc) {
                System.err.println("Fehler beim Schliessen eines Streams:");
                exc.printStackTrace();
            }
            ++idx;
        }
        this.openedReaders.removeAllElements();
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource result = null;
        try {
            Reader reader = this.getSchema(systemId);
            if (reader != null) {
                this.openedReaders.add(reader);
                result = new InputSource(reader);
            }
        }
        catch (Exception exc) {
            throw new SAXException(exc);
        }
        return result;
    }

    public void error(SAXParseException exc) throws SAXException {
        throw exc;
    }

    public void warning(SAXParseException exc) throws SAXException {
        throw exc;
    }

    public Reader getSchema(String systemId) throws Exception {
        String schemaFileName = null;
        InputStreamReader reader = null;
        int idx = systemId.lastIndexOf(47);
        schemaFileName = idx >= 0 && idx < systemId.length() - 1 ? systemId.substring(idx + 1) : systemId;
        schemaFileName = SCHEMA_DIR + schemaFileName;
        try {
            reader = new InputStreamReader(this.getClass().getResourceAsStream(schemaFileName), "ISO-8859-1");
            System.out.println(String.valueOf(systemId) + " --> " + schemaFileName);
        }
        catch (Exception ex) {
            throw new ValidationException("Resource " + schemaFileName + " konnte nicht ermittelt werden.", null);
        }
        return reader;
    }
}

