/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.validator;

import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;

public class ValidationException
extends Exception {
    private String publicId = null;
    private String systemId = null;
    private int line = -1;
    private int column = -1;

    public ValidationException(String message, Locator locator) {
        super(message);
        this.setLocation(locator);
    }

    public ValidationException(SAXParseException exc) {
        super(exc.getMessage(), exc.getException());
        this.publicId = exc.getPublicId();
        this.systemId = exc.getSystemId();
        this.line = exc.getLineNumber();
        this.column = exc.getColumnNumber();
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    public String toString() {
        int index;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        buffer.append(": ");
        String publicId = this.publicId;
        String systemId = this.systemId;
        if (this.publicId != null) {
            index = this.publicId.lastIndexOf(47);
            if (index != -1) {
                publicId = this.publicId.substring(index + 1);
            }
            buffer.append(publicId);
            buffer.append(':');
        }
        if (this.systemId != null) {
            index = this.systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = this.systemId.substring(index + 1);
            }
            buffer.append(systemId);
            buffer.append(':');
        }
        buffer.append(this.line);
        buffer.append(':');
        buffer.append(this.column);
        buffer.append(": ");
        buffer.append(this.getMessage());
        return buffer.toString();
    }

    private void setLocation(Locator locator) {
        if (locator != null) {
            this.publicId = locator.getPublicId();
            this.systemId = locator.getSystemId();
            this.line = locator.getLineNumber();
            this.column = locator.getColumnNumber();
        }
    }
}

