/*
 * $RCSfile: Scanner.flex,v $
 * 
 * created by sks on 19.11.2002
 *
 * $Revision: 1.29 $
 *
 * $Date: 2007/06/08 12:44:16 $
 *
 * copyright:
 * Werum Software & Systems AG
 * Wulf-Werum-Strasse 3
 * 21337 Lueneburg
 *
 * $Log: Scanner.flex,v $
 * Revision 1.29  2007/06/08 12:44:16  rieger
 * Fehler bei Kommentaren wie "*..." behoben.
 *
 * Revision 1.28  2007/05/30 14:03:23  rieger
 * Hierarchische PL implementiert.
 *
 * Revision 1.27  2006/05/26 13:26:18  rieger
 * Backslashes (escaped) werden im String als Backslash interpretiert.
 *
 * Revision 1.26  2005/05/09 19:01:59  haehnel
 * Fehlermeldungsmechanismus um MessageContext erweitert, der es
 * ermoeglicht, Kontextinformationen (z.B. Materialnummer bzw. Id) in
 * die Meldung aufzunehmen und HTML-faehig ist.
 *
 * Revision 1.25  2005/04/22 14:27:01  haehnel
 * LAENGE VON in ANZAHL VON geaendert.
 *
 * Revision 1.24  2005/04/20 16:30:47  haehnel
 * Intervalle an SPLV-Schreibweise angepasst.
 *
 * Revision 1.23  2004/12/02 09:41:30  hollatz
 * Anpassung an Generierung von Code aus Fehlertexten.
 *
 * Revision 1.22  2004/05/19 09:46:04  haehnel
 * Typen usw. auf deutsch umgestellt.
 *
 * Revision 1.21  2004/05/14 16:16:38  rieger
 * Die Elemente INDEX VON und MAPPEN hinzugefuegt.
 *
 * Revision 1.20  2004/03/31 15:44:15  rieger
 * Typpruefung um die Maskenpruefung erweitert.
 * LAENGE VON Operator hinzugefuegt.
 *
 * Revision 1.19  2004/03/16 13:00:03  rieger
 * Maskenpruefung aktiviert.
 *
 * Revision 1.18  2004/02/24 15:15:43  sks
 * FUER-JEDES als Faktor implementiert. Dies ermoeglicht die Verwendung
 * einer FUER-JEDES-Anweisungen grundsaetzlich in beliebigen booleschen
 * Ausdruecken. Unterstuetzt wird dies aber z. Z. nur von WENN-DANN
 * Anweisungen.
 *
 * Revision 1.17  2004/01/09 11:19:12  sks
 * CATEGORY-Keyword wird jetzt auch vom Scanner erkannt.
 *
 * Revision 1.16  2004/01/08 15:18:22  sks
 * #16: Standard-Merkmalspruefung
 * #15: Neue (iterne) Funktion IstTypgerecht, Tests stehen noch aus
 *
 * Revision 1.15  2003/12/05 11:44:16  sks
 * Implementierung von Leer-Werten in der Spezifikationssprache (getestet).
 * Basierend auf der Erweiterung #26: LEER Wert in der Spezfikationssprache.
 *
 * Revision 1.14  2003/09/01 06:47:10  sks
 * Unterstuetzung fuer Datumswerte hinzugefuegt.
 *
 * Revision 1.13  2003/08/05 13:06:09  sks
 * Kontaktworte fuer Eingenschaften eingefuehrt
 * (IST/EIGENSCHAFT).
 *
 * Revision 1.12  2003/07/08 12:43:26  sks
 * Unterstuetzung fuer einschraenkbare Iterationen hinzugefuegt.
 *
 * Revision 1.11  2003/07/01 09:56:02  sks
 * Unterstuetzung fuer Feldpruefungen und Umbenennung einiger Symbole zur Erhoehung der Klarheit.
 *
 * Revision 1.10  2003/06/30 13:55:47  sks
 * Iterations-Schleifen und die Verwendung einer Iteration innerhalb einer Wenn-Dann Anweisung sind jetzt moeglich.
 *
 * Revision 1.9  2003/06/18 15:27:25  sks
 * Unterstuetzung fuer Auspraegungsgruppen implementiert.
 *
 * Revision 1.8  2003/06/16 09:09:53  sks
 * Einige neue Schluesselwoerter hinzugefuegt.
 *
 * Revision 1.7  2003/03/25 11:04:27  sks
 * Kontext-Informationen fuer Fehlermeldungen integriert.
 *
 * Revision 1.6  2003/03/07 15:35:45  sks
 * Neues Schluesselwort 'REIHE' zur alternativen Deklaration von Wertebereichen 
 * eingefuehrt.
 *
 * Revision 1.5  2003/03/05 11:15:19  sks
 * Uebersetzung von Umlauten temporaer ausgeschaltet.
 *
 * Revision 1.4  2003/03/05 11:09:30  sks
 * Der Scanner meldet seine Fehler jetzt auch als Exception mit Fehler-Nachrichten.
 *
 * Revision 1.3  2003/03/05 10:52:51  sks
 * Umlaute innerhalb von Bezeichnern werden nun in Sequenzen ueberfuehrt, die keine Umlaute mehr enthalten.
 *
 * Revision 1.2  2003/03/05 10:16:30  sks
 * Umlaute in Bezeichnern sind nun erlaubt.
 *
 * Revision 1.1  2002/12/17 11:21:25  sks
 * re-checkin after re-location to parser
 *
 * Revision 1.1  2002/12/16 11:47:42  sks
 * re-checkin after relocation
 *
 * Revision 1.4  2002/11/28 10:33:31  sks
 * initial revision
 *
 */


/*--------------------------------
 * Scanner specification
 *-------------------------------- */


/*
 * Java preamble
 */
package de.statspez.pleditor.generator.parser.speclanguage;

import java_cup.runtime.*;
import de.statspez.pleditor.generator.common.*;


%%

%class Scanner
%public
%cupsym Symbols
%cup
%unicode
%line
%column

%{
   /**
    * A variable to collect string data.
    **/
   StringBuffer string = new StringBuffer();

   /**
    * Enthaelt alle Umlaute, die in Bezeichnern (Identifiern)
    * vorkommen duerfen.
    **/
   private static final char UMLAUTS[] = {'', '', '', '', '', '', ''};

   /**
    * Beschreibung des Kontextes, in dem der Scanner verwendet wird.
    * Dies kann z. B. der Name des gescannten Programms oder ein Dateiname
    * sein.
    **/
   private MessageContextInterface context = null;

   /**
    * Enthaelt die Entsprechnungssequenzen, in die Umlaute in Bezeichnern
    * ueberfuehrt werden. Als Index fuer den Zugriff auf die Sequenzen wird
    * der Index des Umlautes in umlaute verwendet.
    **/
   private static final String UMLAUTS_REPLACEMENTS[] =
   {
      "__umlaut_ae__",
      "__umlaut_AE__",
      "__umlaut_oe__",
      "__umlaut_OE__",
      "__umlaut_ue__",
      "__umlaut_UE__",
      "__umlaut_ss__",
   };


   /**
    * Erzetze alle Umlaute, die in UMLAUTS definiert sind durch
    * ihre Entsprechungen.
    **/
   private String replaceUmlauts(String input)
   {
      StringBuffer output = new StringBuffer();

      int j = 0;
      for (int i = 0; i < input.length(); i++)
      {
         for (j = 0; j < UMLAUTS.length; j++)
         {
            if (UMLAUTS[j] == input.charAt(i))
            {
               output.append(UMLAUTS_REPLACEMENTS[j]);
               break;
            }
         }

         if (j >= UMLAUTS.length)
         {
            output.append(input.charAt(i));
         }
      }

      return output.toString();
   }


   /**
    * Setzte die Beschreibung des Kontextes, in dem der Scanner
    * benutzt wird (z. B. Programm- oder Dateiname). Der Kontext
    * wird in Fehlermeldungen integriert.
    **/
   public void setContext(MessageContextInterface context)
   {
      this.context = context;
   }

   
   /**
    * Return a symbol that represents the specified type.
    * The value of the symbol is set to the parameter value.
    **/
   private Symbol symbol(int type, Object value)
   {
      return new Symbol(type, yyline, yycolumn, value);
   }


   /**
    * Return a symbol that represents the specified type.
    * The value of the symbol is undefined.
    **/
   private Symbol symbol(int type)
   {
      return new Symbol(type, yyline, yycolumn);
   }


   private void trace(String message)
   {
      //System.out.println("Scanner-Trace: " + message);
   }
%}



/* 
 * JLex definitions: 
 */

%function next_token
%type java_cup.runtime.Symbol
%char

zeilenende      = \r | \n | \r\n
eingabe_zeichen = [`\r\n]
string_zeichen  = [^\r\n\'\\]
white_space     = {zeilenende} | [ \t\f]

comment = "\"" ~"\""

ziffer  = [0-9]
/* zeichen = [a-z] | [A-Z] */
zeichen = [:letter:]

bezeichner = ({zeichen} | [_]) ({zeichen} | {ziffer} | [_])*
ganzzahl   = {ziffer} {ziffer}*
zahl       = {ganzzahl} ("." {ganzzahl}+)?


%state ZEICHENKETTE


%%

/*
 * regular expressions and actions
 */

/* Terminal Symbols */

// keywords
<YYINITIAL>
{
   "ABBRUCH"
   {
      trace("found keyword 'ABBRUCH'");
      return symbol(Symbols.ABBRUCH);
   }

   "ABLAUF"
   {
      trace("found keyword 'ABLAUF'");
      return symbol(Symbols.ABLAUF);
   }

   "ALLE"
   {
      trace("found keyword 'ALLE'");
      return symbol(Symbols.ALLE);
   }

   "AUS"
   {
      trace("found keyword 'AUS'");
      return symbol(Symbols.AUS);
   }

   "BIS"
   {
      trace("found keyword 'BIS'");
      return symbol(Symbols.BIS);
   }

   "DANN"
   {
      trace("found keyword 'DANN'");
      return symbol(Symbols.DANN);
   }

   "DATUMSWERT"
   {
      trace("found keyword 'DATUM'");
      return symbol(Symbols.DATUM);
   }

   "EIGENSCHAFT"
   {
      trace("found keyword 'EIGENSCHAFT'");
      return symbol(Symbols.EIGENSCHAFT);
   }

   "ENDE"
   {
      trace("found keyword 'ENDE'");
      return symbol(Symbols.ENDE);
   }

   "FALSCH"
   {
      trace("found keyword 'FALSCH'");
      return symbol(Symbols.FALSCH);
   }

   "FELD"
   {
      trace("found keyword 'FELD'");
      return symbol(Symbols.FELD);
   }

   "WERT"
   {
      trace("found keyword 'WERT'");
      return symbol(Symbols.WERT);
   }

   "FEHLER"
   {
      trace("found keyword 'FEHLER'");
      return symbol(Symbols.FEHLER);
   }
   
   "GILT"
   {
      trace("found keyword 'GILT'");
      return symbol(Symbols.GILT);
   }

   "FUER"
   {
      trace("found keyword 'FUER'");
      return symbol(Symbols.FUER);
   }

   "FUNKTION"
   {
      trace("found keyword 'FUNKTION'");
      return symbol(Symbols.FUNKTION);
   }

   "GIB"
   {
      trace("found keyword 'GIB'");
      return symbol(Symbols.GIB);
   }

   "HAT"
   {
      trace("found keyword 'HAT'");
      return symbol(Symbols.HAT);
   }

   "IST"
   {
      trace("found keyword 'IST'");
      return symbol(Symbols.IST);
   }

   "JEDES"
   {
      trace("found keyword 'JEDES'");
      return symbol(Symbols.JEDES);
   }

   "MATERIAL"
   {
      trace("found keyword 'MATERIAL'");
      return symbol(Symbols.MATERIAL);
   }

   "MIT"
   {
      trace("found keyword 'MIT'");
      return symbol(Symbols.MIT);
   }

   "PRUEFE"
   {
      trace("found keyword 'PRUEFE'");
      return symbol(Symbols.PRUEFE);
   }

   "REIHE"
   {
      trace("found keyword 'REIHE'");
      return symbol(Symbols.REIHE);
   }

   "RUECKGABE"
   {
      trace("found keyword 'RUECKGABE'");
      return symbol(Symbols.RUECKGABE);
   }

   "THEMENBEREICH"
   {
      trace("found keyword 'THEMENBEREICH'");
      return symbol(Symbols.THEMENBEREICH);
   }

   "SCHRITTWEITE"
   {
      trace("found keyword 'SCHRITTWEITE'");
      return symbol(Symbols.SCHRITTWEITE);
   }

   "SOLANGE"
   {
      trace("found keyword 'SOLANGE'");
      return symbol(Symbols.SOLANGE);
   }

   "SONST"
   {
      trace("found keyword 'SONST'");
      return symbol(Symbols.SONST);
   }

   "TYP"
   {
      trace("found keyword 'TYP'");
      return symbol(Symbols.TYP);
   }

   "VAR"
   {
      trace("found keyword 'VAR'");
      return symbol(Symbols.VAR);
   }

   "VON"
   {
      trace("found keyword 'VON'");
      return symbol(Symbols.VON);
   }

   "WAHR"
   {
      trace("found keyword 'WAHR'");
      return symbol(Symbols.WAHR);
   }

   "WENN"
   {
      trace("found keyword 'WENN'");
      return symbol(Symbols.WENN);
   }

   "WIEDERHOLE"
   {
      trace("found keyword 'WIEDERHOLE'");
      return symbol(Symbols.WIEDERHOLE);
   }

   "LEER"
   {
      trace("found keyword 'LEER'");
      return symbol(Symbols.LEER);
   }

   "KOMMAZAHL"
   {
      trace("found keyword 'REAL'");
      return symbol(Symbols.REAL);
   }

   "ZEICHENKETTE"
   {
      trace("found keyword 'STRING'");
      return symbol(Symbols.STRING);
   }

   "KATEGORIE"
   {
      trace("found keyword 'CATEGORY'");
      return symbol(Symbols.CATEGORY);
   }

   "DATUM"
   {
      trace("found keyword 'DATE'");
      return symbol(Symbols.DATE);
   }

   "ZEIT"
   {
      trace("found keyword 'TIME'");
      return symbol(Symbols.TIME);
   }

   "GANZZAHL"
   {
      trace("found keyword 'INTEGER'");
      return symbol(Symbols.INTEGER);
   }

   "WAHRHEITSWERT"
   {
      trace("found keyword 'BOOL'");
      return symbol(Symbols.BOOL);
   }

   "ANZAHL"
   {
      trace("found keyword 'ANZAHL'");
      return symbol(Symbols.ANZAHL);
   }

   "INDEX"
   {
      trace("found keyword 'INDEX'");
      return symbol(Symbols.INDEX);
   }

   "MAPPEN"
   {
      trace("found keyword 'MAPPEN'");
      return symbol(Symbols.MAPPEN);
   }

   "NACH"
   {
      trace("found keyword 'NACH'");
      return symbol(Symbols.NACH);
   }

   "EXISTIERT"
   {
      trace("found keyword 'EXISTIERT'");
      return symbol(Symbols.EXISTIERT);
   }

   "MINDESTENS"
   {
      trace("found operator 'MINDESTENS'");
      return symbol(Symbols.MINDESTENS);
   }

   "GENAU"
   {
      trace("found operator 'GENAU'");
      return symbol(Symbols.GENAU);
   }

   "HOECHSTENS"
   {
      trace("found operator 'HOECHSTENS'");
      return symbol(Symbols.HOECHSTENS);
   }

   "IDENTISCH"
   {
      trace("found keyword 'IDENTISCH'");
      return symbol(Symbols.IDENTISCH);
   }

   "MIN"
   {
      trace("found keyword 'MIN'");
      return symbol(Symbols.MIN);
   }

   "MAX"
   {
      trace("found keyword 'MAX'");
      return symbol(Symbols.MAX);
   }

   "SUMME"
   {
      trace("found keyword 'SUMME'");
      return symbol(Symbols.SUMME);
   }

   "MITTEL"
   {
      trace("found keyword 'MITTEL'");
      return symbol(Symbols.MITTEL);
   }

   "MEDIAN"
   {
      trace("found keyword 'MEDIAN'");
      return symbol(Symbols.MEDIAN);
   }

   "VARIANZ"
   {
      trace("found keyword 'VARIANZ'");
      return symbol(Symbols.VARIANZ);
   }

   "STABW"
   {
      trace("found keyword 'STABW'");
      return symbol(Symbols.STABW);
   }

   "GLOBAL"
   {
      trace("found keyword 'GLOBAL'");
      return symbol(Symbols.GLOBAL);
   }
}

// operators
<YYINITIAL>
{
   "*"
   {
      trace("found operator '*'");
      return symbol(Symbols.MULT);
   }

   "/"
   {
      trace("found operator '/'");
      return symbol(Symbols.DIV);
   }

   "+"
   {
      trace("found operator '+'");
      return symbol(Symbols.PLUS);
   }

   "-"
   {
      trace("found operator '-'");
      return symbol(Symbols.MINUS);
   }

   "="
   {
      trace("found operator '='");
      return symbol(Symbols.EQUAL);
   }


   "<"
   {
      trace("found operator '<'");
      return symbol(Symbols.LT);
   }

   ">"
   {
      trace("found operator '>'");
      return symbol(Symbols.GT);
   }

   "<="
   {
      trace("found operator '<='");
      return symbol(Symbols.LE);
   }

   ">="
   {
      trace("found operator '>='");
      return symbol(Symbols.GE);
   }

   "/="
   {
      trace("found operator '/='");
      return symbol(Symbols.NOT_EQUAL);
   }

   "IN"
   {
      trace("found operator 'IN'");
      return symbol(Symbols.IN);
   }

   "UND"
   {
      trace("found operator 'UND'");
      return symbol(Symbols.UND);
   }

   "ODER"
   {
      trace("found operator 'ODER'");
      return symbol(Symbols.ODER);
   }

   "NICHT"
   {
      trace("found operator 'NICHT'");
      return symbol(Symbols.NICHT);
   }
}


// misc. terminal syms
<YYINITIAL>
{
   "#"
   {
      trace("found terminal '#'");
      return symbol(Symbols.HASH);
   }
   
   ","
   {
      trace("found terminal ','");
      return symbol(Symbols.COMMA);
   }

   ";"
   {
      trace("found terminal ';'");
      return symbol(Symbols.SEMICOLON);
   }

   ".."
   {
      trace("found terminal '..'");
      return symbol(Symbols.SEQUENCE);
   }

   "--"
   {
      trace("found terminal '--'");
      return symbol(Symbols.INTERVAL_MINUS_MINUS);
   }

   "-+"
   {
      trace("found terminal '-+'");
      return symbol(Symbols.INTERVAL_MINUS_PLUS);
   }

   "+-"
   {
      trace("found terminal '+-'");
      return symbol(Symbols.INTERVAL_PLUS_MINUS);
   }

   "++"
   {
      trace("found terminal '++'");
      return symbol(Symbols.INTERVAL_PLUS_PLUS);
   }

   ":="
   {
      trace("found terminal ':='");
      return symbol(Symbols.ASSIGN);
   }

   "("
   {
      trace("found terminal '('");
      return symbol(Symbols.LPAREN);
   }

   ")"
   {
      trace("found terminal ')'");
      return symbol(Symbols.RPAREN);
   }


   "["
   {
      trace("found terminal '['");
      return symbol(Symbols.LBRACE);
   }

   "]"
   {
      trace("found terminal ']'");
      return symbol(Symbols.RBRACE);
   }

   "{"
   {
      trace("found terminal '{'");
      return symbol(Symbols.LBRACK);
   }

   "}"
   {
      trace("found terminal '}'");
      return symbol(Symbols.RBRACK);
   }

   "&"
   {
      trace("found terminal '&'");
      return symbol(Symbols.AMPERSAND);
   }

   "."
   {
      trace("found terminal '.'");
      return symbol(Symbols.PUNKT);
   }
}


/* non-terminals */
<YYINITIAL>
{
   {bezeichner}
   { 
      trace("gefundener <Bezeichner> '" + yytext() + "'"); 
      /*return symbol(Symbols.BEZEICHNER, replaceUmlauts(yytext())); */
      return symbol(Symbols.BEZEICHNER, yytext()); 
   }

   {ganzzahl}
   {
      trace("gefundene <Ganzzahl> '" + yytext() + "'");
      return symbol(Symbols.GANZZAHL, yytext());
   }

   {zahl}
   {
      trace("gefundene <Zahl> '" + yytext() + "'");
      return symbol(Symbols.ZAHL, yytext());
   }
   
   {white_space}
   {
      //trace("ignore <white_space>");
   }

   {comment}
   {
      //ignore
   }

   \'
   {
      string.setLength(0);
      yybegin(ZEICHENKETTE);
   }
}


<ZEICHENKETTE> 
{
   \'                      
   { 
      trace("gefundene Zeichenkette '" + string.toString() + "'");
      yybegin(YYINITIAL); 
      return symbol(Symbols.ZEICHENKETTE, string.toString());
   }

   {string_zeichen}+       
   { 
      string.append(yytext()); 
   }

   \\'
   {
      string.append("'");
   }
  
   \\\\
   {
      string.append("\\");
   }
  
   /* error cases */
   \\.                     
   { 
      throw new RuntimeException("Illegale Escape-Sequenz \"" + yytext() + "\"");
   }

   {zeilenende}
   { 
      throw new RuntimeException("Unvollendete Zeichenkette am Ende einer Zeile");
   }
}


/* error fallback */
. | \n
{
   SpecLangParseException exc = 
      new SpecLangParseException("Fehler beim Lesen von Spezifikations-Code.");

   if (this.context != null)
   {
      exc.addMessage(new ErrorMessage(context, "ungltiges Zeichen '" + yytext() + "'", 
                                      yyline + 1, yycolumn + 1));
   }
   else
   {
      exc.addMessage(new ErrorMessage("ungltiges Zeichen '" + yytext() + "'", 
                                      yyline + 1, yycolumn + 1));
   }

   throw exc;
}
