<?xml version="1.0"?> 
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" encoding="iso-8859-1" indent="yes" method="html"/>
<!--     auml  "&#228;"
        Auml  "&#196;"
        ouml  "&#246;"
        Ouml  "&#214;"
        uuml  "&#252;"
        Uuml  "&#220;"
        szlig "&#223;"
        nbsp  "&#160;"

  -->
  
<xsl:template match="/">
  <HTML>
    <head>
      <link rel="stylesheet" href="format.css" type="text/css"/>
      <!-- <title>Ergebnis der Materialnummerpr&#252;fung von <xsl:value-of select="fehlerlog/datenquelle"/></title> -->
      <title>Ergebnis der Materialnummerpr&#252;fung</title>
    </head>
    <BODY>
      <table width="100%" align="left" border="0" cellpadding="7">
		<!-- Logo und Titel -->
		<tr>
		  <td align="left">
		    <h3>Ergebnis der Materialnummerpr&#252;fung</h3>
		  </td>
		  <td width="30%" align="right">
		    <!-- <img src="html/kba-logo.gif"/> -->
		  </td>
		</tr>
		<tr>
		  <td align="center" colspan="2">
           <xsl:apply-templates select="mitgliedsnummerpruefung"/>
		  </td>
		</tr>
      </table>
	</BODY>
 </HTML>
</xsl:template>


  <xsl:template match="mitgliedsnummerpruefung">
  	<table width="100%" align="center" cellspacing="0px" border="1" rules="cells" cellpadding="2">
  	<tr>
  	  <th align="left" valign="top">Betr.Nr UVT</th>
  	  <th align="left" valign="top">Mitgliedsnummer</th>
 	    <th align="left" valign="top">P&#252;fgenauigkeit (soll)</th>
 	    <th align="left" valign="top">P&#252;fgenauigkeit (ist)</th>
 	    <th align="left" valign="top">Status</th>
 	    <th align="left" valign="top">Status (soll)</th>
 	    <th align="left" valign="top">Fehlertext</th>
  	</tr>
  		<xsl:apply-templates select="pruefergebnis"/>
  	</table>
  	<xsl:apply-templates select="status_count"/>
  </xsl:template>

  <xsl:template match="pruefergebnis">
  	<tr>
  	  <xsl:if test="position() mod 2 = 0">
  	     <xsl:attribute name="bgcolor">lightgrey</xsl:attribute>
  	  </xsl:if>
  	  <td align="left" valign="top"><xsl:value-of select="betriebsnummer_uvt"/></td>
  	  <td align="left" valign="top"><xsl:value-of select="mitgliedsnummer"/></td>
   	  <td align="left" valign="top"><xsl:value-of select="preufgenauigkeit_soll"/></td>
  	  <td align="left" valign="top"><xsl:value-of select="preufgenauigkeit_ist"/></td>
  	  <td align="left" valign="top">
  	  <xsl:variable name="status" select="status"/>
  	  <xsl:choose>
  	     <xsl:when test='$status = 0'>
  	        <xsl:attribute name="bgcolor">green</xsl:attribute>
  	     </xsl:when>
  	     <xsl:when test='$status = 1'>
  	        <xsl:attribute name="bgcolor">orange</xsl:attribute>
  	     </xsl:when>
  	     <xsl:when test='$status = 2'>
  	        <xsl:attribute name="bgcolor">orange</xsl:attribute>
  	     </xsl:when>
  	     <xsl:when test='$status = 3'>
  	        <xsl:attribute name="bgcolor">yellow</xsl:attribute>
  	     </xsl:when>
  	     <xsl:when test='$status = 4'>
  	        <xsl:attribute name="bgcolor">yellow</xsl:attribute>
  	     </xsl:when>
  	     <xsl:when test='$status = 5'>
  	        <xsl:attribute name="bgcolor">red</xsl:attribute>
  	     </xsl:when>
  	  </xsl:choose>
  	  <xsl:value-of select="status"/></td>
  	  <td align="left" valign="top">
  	  <xsl:variable name="status2" select="status"/>
  	  <xsl:variable name="status_soll" select="status_soll"/>
  	  <xsl:choose>
  	     <xsl:when test="$status_soll!='' and $status_soll!=$status2">
  	        <xsl:attribute name="bgcolor">red</xsl:attribute>
  	     </xsl:when>
  	  </xsl:choose>
  	  <xsl:value-of select="status_soll"/></td>
  	  <td align="left" valign="top"><xsl:value-of select="fehlertext"/></td>
  	</tr>
  </xsl:template>

  <xsl:template match="status_count">
  	<table cellspacing="0px" border="1" rules="cells" cellpadding="2">
  	  <tr><th colspan="2">Gesamtergebnis:</th></tr>
  	  <tr><td align="right">Ok:</td><td align="right" bgcolor="green"><xsl:value-of select="ok"/></td></tr>
  	  <tr><td align="right">Falsche Zeichen:</td><td align="right" bgcolor="orange"><xsl:value-of select="zeichen"/></td></tr>
  	  <tr><td align="right">Falsche L&#228;nge:</td><td align="right" bgcolor="orange"><xsl:value-of select="laenge"/></td></tr>
  	  <tr><td align="right">Falsches Format:</td><td align="right" bgcolor="yellow"><xsl:value-of select="format"/></td></tr>
  	  <tr><td align="right">Falsche P&#252;fziffer:</td><td align="right" bgcolor="yellow"><xsl:value-of select="pruefziffer"/></td></tr>
  	  <tr><td align="right">UVT unbekannt:</td><td align="right" bgcolor="red"><xsl:value-of select="uvt"/></td></tr>
  	</table>
  </xsl:template>

 <xsl:template match="betriebsnummer_uvt">
	      <xsl:value-of select="text()"/>
 </xsl:template>

 <xsl:template match="mitgliedsnummer">
	      <xsl:value-of select="text()"/>
 </xsl:template>

 <xsl:template match="preufgenauigkeit_soll">
	      <xsl:value-of select="text()"/>
 </xsl:template>

 <xsl:template match="preufgenauigkeit_ist">
	      <xsl:value-of select="text()"/>
 </xsl:template>

 <xsl:template match="status">
	      <xsl:value-of select="text()"/>
 </xsl:template>

 <xsl:template match="status_soll">
	      <xsl:value-of select="text()"/>
 </xsl:template>

 <xsl:template match="fehlertext">
	      <xsl:value-of select="text()"/>
 </xsl:template>

</xsl:stylesheet>