/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.program;

import de.statspez.pleditor.generator.codegen.analysis.CrossReferenceBuilder;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.TbScopeBuilder;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBoolean;
import de.statspez.pleditor.generator.meta.MetaBooleanOperator;
import de.statspez.pleditor.generator.meta.MetaBreakStatement;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaContextOperator;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomAuspraegung;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaDate;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaElementVisitor;
import de.statspez.pleditor.generator.meta.MetaErrorStatement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachIndexOperator;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaHierarchicalOperator;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaIndexOfOperator;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMapStatement;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaMathOperator;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaNoValue;
import de.statspez.pleditor.generator.meta.MetaNumber;
import de.statspez.pleditor.generator.meta.MetaPrintStatement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaRightValue;
import de.statspez.pleditor.generator.meta.MetaSelfAccess;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSetStatement;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaSizeTestingOperator;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaString;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaTypeCheck;
import de.statspez.pleditor.generator.meta.MetaUnaryBoolOperator;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.meta.MetaWithOperator;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppeComps;
import de.statspez.pleditor.generator.meta.generated.MetaDsbComps;
import de.statspez.pleditor.generator.meta.generated.MetaDsbFeld;
import de.statspez.pleditor.generator.meta.generated.MetaDsbKommentar;
import de.statspez.pleditor.generator.meta.generated.MetaDsbMultiKommentar;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaDsbZeilenKommentar;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaMappingElement;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaPLEigenschaft;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLInitwert;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLParameter;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPLVariable;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaRawDataSet;
import de.statspez.pleditor.generator.meta.generated.MetaRawField;
import de.statspez.pleditor.generator.meta.generated.MetaRawFieldGroup;
import de.statspez.pleditor.generator.meta.generated.MetaRawSet;
import de.statspez.pleditor.generator.meta.generated.MetaRefAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaSatzart;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezKomponente;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ProgramComplexityResolver {
    public static final double DEFAULT_FREQUENCY_FOR_LOOP = 100.0;
    public static final double DEFAULT_FREQUENCY_FOR_TRUE = 0.5;
    public static final double DEFAULT_FREQUENCY_FOR_FALSE = 0.5;
    public static final int DEFAULT_FREQUENCY_FOR_MATERIAL = 100;
    private static final double COMPLEXITY_APG_ACCESS = 0.05;
    private static final double COMPLEXITY_FOR_RECURSION = 2.0;
    private static final double COMPLEXITY_VARIABLEFIELD_ACCESS = 0.01;
    private static final double COMPLEXITY_TOPICFIELD_ACCESS = 0.06;
    private static final double COMPLEXITY_TYPCONVERT_NUMBER = 0.07;
    private static final double COMPLEXITY_TYPCONVERT_STRING = 0.05;
    private static final double COMPLEXITY_INTERVAL = 0.06;
    private static final double COMPLEXITY_LITERAL_ACCESS = 0.0;
    private static final double COMPLEXITY_VAR_DECLARATION = 0.01;
    private static final double COMPLEXITY_SINGLE_ASSIGNMENT = 0.01;
    private static final double COMPLEXITY_INTERNAL_FUNCTION = 0.3;
    private static final double COMPLEXITY_TESTING_OPERATOR_EQ = 0.03;
    private static final double COMPLEXITY_TESTING_OPERATOR_GE = 0.03;
    private static final double COMPLEXITY_TESTING_OPERATOR_GT = 0.03;
    private static final double COMPLEXITY_TESTING_OPERATOR_LE = 0.03;
    private static final double COMPLEXITY_TESTING_OPERATOR_LT = 0.03;
    private static final double COMPLEXITY_TESTING_OPERATOR_NE = 0.03;
    private static final double COMPLEXITY_TESTING_OPERATOR_CONTAINS = 0.03;
    private static final double COMPLEXITY_RANGE_SERIES_ELEMENT = 0.01;
    private static final double COMPLEXITY_BOOLEAN_OPERATOR = 0.0;
    private static final double COMPLEXITY_UNARY_OPERATOR = 0.0;
    public static final double DEFAULT_COMPLEXITY_STRUCTURE_ACCESS = 0.1;
    private static final double COMPLEXITY_SIZEOF_OPERATOR = 0.1;
    private static final double DEFAULT_COMPLEXITY_MATERIAL_ACCESS = 0.17;
    private static final double COMPLEXITY_RETURN = 0.0;
    private static final double COMPLEXITY_SET_STATEMENT = 1.0;
    private static final double COMPLEXITY_TYPE_CHECK = 0.3;
    private static final double COMPLEXITY_TYPE_CHECK_CATEGORY = 0.6;
    private static final double COMPLEXITY_DATE = 0.1;
    private static final double COMPLEXITY_ERROR = 0.07;
    private static final double COMPLEXITY_STRING = 0.0;
    private static final double COMPLEXITY_NUMBER = 0.0;
    private static final double COMPLEXITY_BOOLEAN = 0.0;
    private static final double COMPLEXITY_PRG_CALL = 0.01;
    private static final double COMPLEXITY_CONDITIONAL = 0.0;
    private static double complexityMaterialAccess = 0.17;
    private static double complexityStruktureAccess = 0.1;
    private OutputStream log = null;
    private StringBuffer testOut = null;
    private Stack level;
    private List resolvedElements;

    public ProgramComplexityResolver() {
        this(new ArrayList());
    }

    public ProgramComplexityResolver(List calculatedElements) {
        this.resolvedElements = calculatedElements;
    }

    public void resolveComplexity(MetaCustomPlausibilisierung plausi, OutputStream log) {
        TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
        Hashtable tbScopes = new Hashtable();
        Scope scope = scopeBuilder.createScopes(plausi, tbScopes);
        CrossReferenceBuilder crossReferenceBuilder = new CrossReferenceBuilder();
        crossReferenceBuilder.buildCrossReference(plausi, scope, tbScopes);
        MetaCustomThemenbereich rootTB = (MetaCustomThemenbereich)plausi.rootThemenbereich();
        this.resolvedElements = new ArrayList();
        this.setLog(log);
        this.testOut = new StringBuffer("Plausibilisierung \n");
        this.level = new Stack();
        Resolver resolver = new Resolver();
        int i = 0;
        while (i < plausi.sizeOfAuspraegungsgruppen()) {
            plausi.getFromAuspraegungsgruppen(i).accept(resolver);
            ++i;
        }
        i = 0;
        while (i < plausi.sizeOfMerkmale()) {
            plausi.getFromMerkmale(i).accept(resolver);
            ++i;
        }
        i = 0;
        while (i < plausi.sizeOfFunktionen()) {
            plausi.getFromFunktionen(i).accept(resolver);
            ++i;
        }
        i = 0;
        while (i < rootTB.sizeOfAblaeufe()) {
            MetaCustomAblauf ablauf = (MetaCustomAblauf)rootTB.getFromAblaeufe(i);
            ablauf.accept(resolver);
            ++i;
        }
    }

    public static void setComplexityMaterialAccess(double newComplexityMaterialAccess) {
        complexityMaterialAccess = newComplexityMaterialAccess;
    }

    public static void setComplexityStructureAccess(double newComplexityStruktureAccess) {
        complexityStruktureAccess = newComplexityStruktureAccess;
    }

    public void setLog(OutputStream log) {
        this.log = log;
    }

    public void calculateProgramComplexity(MetaProgram metaProgram, String kommentar) {
        this.level = new Stack();
        try {
            if (this.log != null) {
                this.testOut = new StringBuffer(String.valueOf(kommentar) + "\n");
            }
            Resolver resolver = new Resolver();
            metaProgram.accept(resolver);
        }
        finally {
            try {
                if (this.log != null) {
                    this.testOut.append("\n");
                    this.log.write(this.testOut.toString().getBytes());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void startEndLevel(String visitMethodeName, double levelComplexity) {
        if (this.log != null) {
            this.level.push(visitMethodeName);
            int i = 0;
            while (i < this.level.size()) {
                this.testOut.append("\t");
                ++i;
            }
            this.level.pop();
            this.testOut.append("<--> ");
            this.testOut.append(visitMethodeName);
            this.testOut.append(" ");
            this.testOut.append(levelComplexity);
            this.testOut.append("\n");
        }
    }

    private void startLevel(String visitMethodeName) {
        if (this.log != null) {
            this.level.push(visitMethodeName);
            int i = 0;
            while (i < this.level.size()) {
                this.testOut.append("\t");
                ++i;
            }
            this.testOut.append("--> ");
            this.testOut.append(visitMethodeName);
            this.testOut.append("\n");
        }
    }

    private void endLevel(MetaElement metaElement) {
        if (this.log != null) {
            int i = 0;
            while (i < this.level.size()) {
                this.testOut.append("\t");
                ++i;
            }
            String visitMethodeName = (String)this.level.pop();
            this.testOut.append("<-- ");
            this.testOut.append(visitMethodeName);
            this.testOut.append(' ');
            this.testOut.append(metaElement.getFunctionalComplexity());
            this.testOut.append("\n");
        }
    }

    private boolean isNotResolved(Object obj) {
        return !this.resolvedElements.contains(obj);
    }

    private class Resolver
    implements MetaElementVisitor {
        private Resolver() {
        }

        public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
            MetaElement metaElement = aFieldAccess.referredElement();
            if (metaElement instanceof MetaTBFeld) {
                double d = 0.06;
                if (((MetaTBFeld)metaElement).getKlasse() instanceof MetaCustomMerkmal) {
                    MetaCustomMerkmal merkmal = (MetaCustomMerkmal)((MetaTBFeld)metaElement).getKlasse();
                    switch (merkmal.getTyp()) {
                        case 1: 
                        case 5: {
                            if (merkmal.getMaske() == null) break;
                            d += 0.07;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 7: {
                            break;
                        }
                        case 3: 
                        case 4: {
                            d += 0.05;
                            break;
                        }
                        case 6: {
                            break;
                        }
                    }
                }
                aFieldAccess.setFunctionalComplexity(new Double(d));
                ProgramComplexityResolver.this.startEndLevel("TopicFieldAccess", aFieldAccess.getFunctionalComplexity());
            } else {
                aFieldAccess.setFunctionalComplexity(new Double(0.01));
                ProgramComplexityResolver.this.startEndLevel("VariableFieldAccess", aFieldAccess.getFunctionalComplexity());
            }
        }

        public void visitLiteralAccess(MetaLiteralAccess anAccess) {
            anAccess.setFunctionalComplexity(new Double(0.0));
            ProgramComplexityResolver.this.startEndLevel("LiteralAccess", anAccess.getFunctionalComplexity());
        }

        public void visitClassificationReference(MetaClassificationReference aReference) {
            ProgramComplexityResolver.this.startLevel("ClassificationReference");
            MetaElement metaElement = aReference.referredElement();
            metaElement.accept(this);
            aReference.setFunctionalComplexity(metaElement.getFunctionalComplexity());
            ProgramComplexityResolver.this.endLevel(aReference);
        }

        public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe anObject) {
            ProgramComplexityResolver.this.startLevel("Auspraegungsgruppe " + anObject.getName());
            if (ProgramComplexityResolver.this.isNotResolved(anObject)) {
                double levelComplexity = 0.05;
                anObject.setFunctionalComplexity(null);
                ProgramComplexityResolver.this.resolvedElements.add(anObject);
                MetaAuspraegungsgruppeComps comps = anObject.getAuspraegungsComps();
                comps.accept(this);
                anObject.setFunctionalComplexity(new Double(levelComplexity += comps.getFunctionalComplexity().doubleValue()));
            }
            ProgramComplexityResolver.this.endLevel(anObject);
        }

        public void visitPLAuspraegung(MetaPLAuspraegung classification) {
            ProgramComplexityResolver.this.startLevel("Auspraegung " + classification.getName());
            classification.setFunctionalComplexity(null);
            ProgramComplexityResolver.this.resolvedElements.add(classification);
            MetaCustomAuspraegung myClassi = (MetaCustomAuspraegung)classification;
            double levelComplexity = 0.0;
            levelComplexity += 0.01;
            if (myClassi.sizeOfAuspraegungen() > 0) {
                int i = 0;
                while (i < classification.sizeOfAuspraegungen()) {
                    MetaAuspraegung metaAuspraegung = classification.getFromAuspraegungen(i);
                    metaAuspraegung.accept(this);
                    levelComplexity += metaAuspraegung.getFunctionalComplexity().doubleValue();
                    ++i;
                }
            } else {
                String kommentar = "Auspr\u00e4gung " + myClassi.getName() + " PlainClassificationKode: " + myClassi.getPlainClassificationKode();
                ProgramComplexityResolver resolver = this.createSubProgramComplexityResolver();
                MetaProgram metaProgram = myClassi.getKodeSpezifikation();
                resolver.calculateProgramComplexity(metaProgram, kommentar);
                levelComplexity += ((MetaSingleAssignment)metaProgram.statements().statementAt(0)).rightValue().getFunctionalComplexity().doubleValue();
            }
            classification.setFunctionalComplexity(new Double(levelComplexity));
            ProgramComplexityResolver.this.endLevel(classification);
        }

        public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
            double complexity = 0.0;
            ProgramComplexityResolver.this.startLevel("RangeSeries");
            Iterator it = aRangeSeries.ranges();
            while (it.hasNext()) {
                MetaElement tmp = (MetaElement)it.next();
                tmp.accept(this);
                complexity += tmp.getFunctionalComplexity().doubleValue();
                complexity += 0.01;
            }
            aRangeSeries.setFunctionalComplexity(new Double(complexity));
            ProgramComplexityResolver.this.endLevel(aRangeSeries);
        }

        public void visitSingleValueRange(MetaSingleValueRange aRange) {
            ProgramComplexityResolver.this.startLevel("SingleValueRange");
            MetaFactor value = aRange.value();
            this.visitMetaFaktor(value);
            aRange.setFunctionalComplexity(new Double(value.getFunctionalComplexity()));
            ProgramComplexityResolver.this.endLevel(aRange);
        }

        public void visitSequence(MetaSequence aSequence) {
            double result = 0.0;
            ProgramComplexityResolver.this.startLevel("Sequence");
            this.visitMetaFaktor(aSequence.first());
            result += aSequence.first().getFunctionalComplexity().doubleValue();
            this.visitMetaFaktor(aSequence.second());
            result += aSequence.second().getFunctionalComplexity().doubleValue();
            this.visitMetaFaktor(aSequence.last());
            aSequence.setFunctionalComplexity(new Double(result += aSequence.last().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(aSequence);
        }

        public void visitInterval(MetaInterval anInterval) {
            double result = 0.06;
            ProgramComplexityResolver.this.startLevel("Interval");
            this.visitMetaFaktor(anInterval.first());
            result += anInterval.first().getFunctionalComplexity().doubleValue();
            this.visitMetaFaktor(anInterval.last());
            anInterval.setFunctionalComplexity(new Double(result += anInterval.last().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(anInterval);
        }

        public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
            double levelComplexity = 0.0;
            ProgramComplexityResolver.this.startLevel("ArrayAccess");
            Iterator it = anArrayAccess.indices();
            while (it.hasNext()) {
                MetaElement tmp = (MetaElement)it.next();
                if (tmp instanceof MetaFactor) {
                    this.visitMetaFaktor((MetaFactor)tmp);
                } else {
                    tmp.accept(this);
                }
                levelComplexity += tmp.getFunctionalComplexity().doubleValue();
            }
            anArrayAccess.setFunctionalComplexity(new Double(levelComplexity));
            ProgramComplexityResolver.this.endLevel(anArrayAccess);
        }

        public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
            double levelComplexity = complexityStruktureAccess;
            ProgramComplexityResolver.this.startLevel("StructureAccess");
            aStructureAccess.structureAccess().accept(this);
            levelComplexity += aStructureAccess.structureAccess().getFunctionalComplexity().doubleValue();
            aStructureAccess.selectedElement().accept(this);
            aStructureAccess.setFunctionalComplexity(new Double(levelComplexity += aStructureAccess.selectedElement().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(aStructureAccess);
        }

        public void visitMaterialAccess(MetaMaterialAccess anAccess) {
            MetaElement tmp;
            ProgramComplexityResolver.this.startLevel("MaterialAccess");
            if (anAccess.getFunctionalFrequency() == null) {
                anAccess.setFunctionalFrequency(new Double(100.0));
            }
            double levelComplexity = complexityMaterialAccess;
            anAccess.material().accept(this);
            Iterator it = anAccess.selectedFields();
            while (it.hasNext()) {
                tmp = (MetaElement)it.next();
                tmp.accept(this);
                levelComplexity += tmp.getFunctionalComplexity().doubleValue();
            }
            it = anAccess.selectionConditions();
            while (it.hasNext()) {
                tmp = (MetaElement)it.next();
                tmp.accept(this);
                levelComplexity += tmp.getFunctionalComplexity().doubleValue();
            }
            anAccess.setFunctionalComplexity(new Double(levelComplexity));
            ProgramComplexityResolver.this.endLevel(anAccess);
        }

        public void visitStatementSequence(MetaStatementSequence aSequence) {
            ProgramComplexityResolver.this.startLevel("StatementSequence");
            double levelComplexity = 0.0;
            Iterator it = aSequence.statements();
            while (it.hasNext()) {
                MetaElement metaElement = (MetaElement)it.next();
                metaElement.accept(this);
                levelComplexity += metaElement.getFunctionalComplexity().doubleValue();
            }
            aSequence.setFunctionalComplexity(new Double(levelComplexity));
            ProgramComplexityResolver.this.endLevel(aSequence);
        }

        public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
            ProgramComplexityResolver.this.startLevel("SingleAssignment");
            double levelComplexity = 0.01;
            MetaValueAccess leftValue = anAssignment.leftValue();
            leftValue.accept(this);
            levelComplexity += leftValue.getFunctionalComplexity().doubleValue();
            MetaRightValue rightValue = anAssignment.rightValue();
            this.visitMetaRightValue(rightValue);
            anAssignment.setFunctionalComplexity(new Double(levelComplexity += rightValue.getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(anAssignment);
        }

        public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
            ProgramComplexityResolver.this.startLevel("MultiAssignment");
            double levelComplexity = 0.0;
            int assignmentCount = 0;
            Iterator it = anAssignment.leftValues();
            while (it.hasNext()) {
                MetaElement tmp = (MetaElement)it.next();
                tmp.accept(this);
                levelComplexity += tmp.getFunctionalComplexity().doubleValue();
                ++assignmentCount;
            }
            levelComplexity += 0.01 * (double)assignmentCount;
            this.visitMetaRightValue(anAssignment.rightValue());
            anAssignment.setFunctionalComplexity(new Double(levelComplexity += anAssignment.rightValue().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(anAssignment);
        }

        public void visitConditionalStatement(MetaConditionalStatement aStatement) {
            MetaStatementSequence falseStatementSequence;
            ProgramComplexityResolver.this.startLevel("ConditionalStatement");
            double statementComplexity = 0.0;
            this.visitMetaFaktor(aStatement.condition());
            statementComplexity += aStatement.condition().getFunctionalComplexity().doubleValue();
            MetaStatementSequence trueStatementSequence = aStatement.ifTrue();
            if (trueStatementSequence.numberOfStatements() > 0) {
                trueStatementSequence.accept(this);
                if (trueStatementSequence.getFunctionalFrequency() == null) {
                    trueStatementSequence.setFunctionalFrequency(new Double(0.5));
                }
                statementComplexity += trueStatementSequence.getFunctionalComplexity() * trueStatementSequence.getFunctionalFrequency();
            }
            if ((falseStatementSequence = aStatement.ifFalse()).numberOfStatements() > 0) {
                falseStatementSequence.accept(this);
                if (falseStatementSequence.getFunctionalFrequency() == null) {
                    falseStatementSequence.setFunctionalFrequency(new Double(0.5));
                }
                statementComplexity += falseStatementSequence.getFunctionalComplexity() * falseStatementSequence.getFunctionalFrequency();
            }
            aStatement.setFunctionalComplexity(new Double(statementComplexity));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitForNextLoop(MetaForNextLoop aStatement) {
            ProgramComplexityResolver.this.startLevel("ForNextLoop");
            double levelComplexity = 0.0;
            aStatement.startAssignment().accept(this);
            levelComplexity += aStatement.startAssignment().getFunctionalComplexity().doubleValue();
            double loopComplexity = 0.0;
            this.visitMetaFaktor(aStatement.endCondition());
            loopComplexity += aStatement.endCondition().getFunctionalComplexity().doubleValue();
            this.visitMetaFaktor(aStatement.stepExpression());
            loopComplexity += aStatement.stepExpression().getFunctionalComplexity().doubleValue();
            MetaStatementSequence loopBody = aStatement.loopBody();
            loopBody.accept(this);
            loopComplexity += loopBody.getFunctionalComplexity().doubleValue();
            if (loopBody.getFunctionalFrequency() == null) {
                loopBody.setFunctionalFrequency(new Double(100.0));
            }
            aStatement.setFunctionalComplexity(new Double(levelComplexity += loopComplexity * loopBody.getFunctionalFrequency()));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitForEachLoop(MetaForEachLoop aStatement) {
            ProgramComplexityResolver.this.startLevel("ForEachLoop");
            double levelComplexity = 0.0;
            Iterator it = aStatement.variables();
            while (it != null && it.hasNext()) {
                MetaElement metaElement = (MetaElement)it.next();
                metaElement.accept(this);
                levelComplexity += metaElement.getFunctionalComplexity().doubleValue();
            }
            MetaFactor metaFactor = aStatement.value();
            this.visitMetaFaktor(metaFactor);
            levelComplexity += metaFactor.getFunctionalComplexity().doubleValue();
            MetaStatementSequence loopBody = aStatement.loopBody();
            loopBody.accept(this);
            if (loopBody.getFunctionalFrequency() == null) {
                loopBody.setFunctionalFrequency(new Double(100.0));
            }
            aStatement.setFunctionalComplexity(new Double(levelComplexity += loopBody.getFunctionalComplexity() * loopBody.getFunctionalFrequency()));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitForEachCheck(MetaForEachCheck aStatement) {
            ProgramComplexityResolver.this.startLevel("ForEachCheck");
            double levelComplexity = 0.0;
            Iterator it = aStatement.variables();
            while (it != null && it.hasNext()) {
                MetaElement metaElement = (MetaElement)it.next();
                metaElement.accept(this);
                levelComplexity += metaElement.getFunctionalComplexity().doubleValue();
            }
            this.visitMetaFaktor(aStatement.value());
            levelComplexity += aStatement.value().getFunctionalComplexity().doubleValue();
            this.visitMetaFaktor(aStatement.condition());
            aStatement.setFunctionalComplexity(new Double(levelComplexity += aStatement.condition().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitWhileLoop(MetaWhileLoop aStatement) {
            ProgramComplexityResolver.this.startLevel("WhileLoop");
            double levelComplexity = 0.0;
            MetaStatementSequence loopBody = aStatement.loopBody();
            if (loopBody.getFunctionalFrequency() == null) {
                loopBody.setFunctionalFrequency(new Double(100.0));
            }
            this.visitMetaFaktor(aStatement.condition());
            levelComplexity += aStatement.condition().getFunctionalComplexity() * loopBody.getFunctionalFrequency();
            loopBody.accept(this);
            aStatement.setFunctionalComplexity(new Double(levelComplexity += loopBody.getFunctionalComplexity() * loopBody.getFunctionalFrequency()));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitPrintStatement(MetaPrintStatement aStatement) {
            ProgramComplexityResolver.this.startLevel("PrintStatement");
            double levelComplexity = 0.0;
            Iterator it = aStatement.toPrint();
            while (it.hasNext()) {
                MetaElement tmp = (MetaElement)it.next();
                if (tmp instanceof MetaFactor) {
                    this.visitMetaFaktor((MetaFactor)tmp);
                } else {
                    tmp.accept(this);
                }
                levelComplexity += tmp.getFunctionalComplexity().doubleValue();
            }
            aStatement.setFunctionalComplexity(new Double(levelComplexity));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitPruefeStatement(MetaPruefeStatement aStatement) {
            ProgramComplexityResolver.this.startLevel("PruefeStatement");
            double levelComplexity = 0.01;
            MetaCustomPruefung metaCustomPruefung = (MetaCustomPruefung)aStatement.referredElement();
            metaCustomPruefung.accept(this);
            aStatement.setFunctionalComplexity(new Double(levelComplexity += metaCustomPruefung.getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitAblaufStatement(MetaAblaufStatement aStatement) {
            ProgramComplexityResolver.this.startLevel("AblaufStatement");
            double levelComplexity = 0.01;
            MetaCustomAblauf metaCustomAblauf = (MetaCustomAblauf)aStatement.referredElement();
            metaCustomAblauf.accept(this);
            aStatement.setFunctionalComplexity(new Double(levelComplexity += metaCustomAblauf.getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitCheckFeldStatement(MetaCheckFeldStatement aStatement) {
            ProgramComplexityResolver.this.startLevel("CheckFeldStatement");
            double levelComplexity = 0.01;
            aStatement.field().accept(this);
            levelComplexity += aStatement.field().getFunctionalComplexity().doubleValue();
            MetaCustomTBFeld tbfeld = (MetaCustomTBFeld)aStatement.referredElement();
            MetaCustomMerkmal merkmal = (MetaCustomMerkmal)tbfeld.getKlasse();
            merkmal.accept(this);
            aStatement.setFunctionalComplexity(new Double(levelComplexity += merkmal.getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitReturnStatement(MetaReturnStatement aStatement) {
            ProgramComplexityResolver.this.startLevel("ReturnStatement");
            double levelComplexity = 0.0;
            this.visitMetaFaktor(aStatement.returnValue());
            aStatement.setFunctionalComplexity(new Double(levelComplexity += aStatement.returnValue().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitFunctionCall(MetaFunctionCall aStatement) {
            ProgramComplexityResolver.this.startLevel("FunctionCall");
            double levelComplexity = 0.01;
            Iterator it = aStatement.parameters();
            while (it != null && it.hasNext()) {
                MetaElement metaElement = (MetaElement)it.next();
                if (metaElement instanceof MetaFactor) {
                    this.visitMetaFaktor((MetaFactor)metaElement);
                } else {
                    metaElement.accept(this);
                }
                levelComplexity += metaElement.getFunctionalComplexity().doubleValue();
            }
            if (InternalFunctions.instance().identifiesInternalFunction(aStatement.function())) {
                levelComplexity += 0.3;
            } else {
                MetaCustomFunktion metaCustomFunktion = (MetaCustomFunktion)aStatement.referredElement();
                metaCustomFunktion.accept(this);
                levelComplexity = metaCustomFunktion.getFunctionalComplexity() == null ? (levelComplexity += 2.0) : (levelComplexity += metaCustomFunktion.getFunctionalComplexity().doubleValue());
            }
            aStatement.setFunctionalComplexity(new Double(levelComplexity));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitProgram(MetaProgram aProgram) {
            ProgramComplexityResolver.this.startLevel("Program");
            aProgram.statements().accept(this);
            aProgram.setFunctionalComplexity(new Double(aProgram.statements().getFunctionalComplexity()));
            ProgramComplexityResolver.this.endLevel(aProgram);
        }

        public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
            ProgramComplexityResolver.this.startLevel("VarDeclaration");
            double levelComplexity = 0.0;
            Iterator ids = aDeclaration.identifiers();
            while (ids.hasNext()) {
                levelComplexity += 0.01;
                MetaElement tmp = (MetaElement)ids.next();
                tmp.accept(this);
                levelComplexity += tmp.getFunctionalComplexity().doubleValue();
            }
            aDeclaration.setFunctionalComplexity(new Double(levelComplexity));
            ProgramComplexityResolver.this.endLevel(aDeclaration);
        }

        public void visitMathOperator(MetaMathOperator anOperator) {
            ProgramComplexityResolver.this.startLevel("MathOperator");
            double levelComplexity = 0.0;
            this.visitMetaFaktor(anOperator.firstOperand());
            levelComplexity += anOperator.firstOperand().getFunctionalComplexity().doubleValue();
            this.visitMetaFaktor(anOperator.secondOperand());
            anOperator.setFunctionalComplexity(new Double(levelComplexity += anOperator.secondOperand().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(anOperator);
        }

        public void visitSignOperator(MetaSignOperator anOperator) {
            ProgramComplexityResolver.this.startLevel("SignOperator");
            double levelComplexity = 0.0;
            this.visitMetaFaktor(anOperator.operand());
            anOperator.setFunctionalComplexity(new Double(levelComplexity += anOperator.operand().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(anOperator);
        }

        public void visitUnaryBoolOperator(MetaUnaryBoolOperator anOperator) {
            ProgramComplexityResolver.this.startLevel("UnaryBoolOperator");
            double levelComplexity = 0.0;
            this.visitMetaFaktor(anOperator.operand());
            anOperator.setFunctionalComplexity(new Double(levelComplexity += anOperator.operand().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(anOperator);
        }

        public void visitBooleanOperator(MetaBooleanOperator anOperator) {
            ProgramComplexityResolver.this.startLevel("BooleanOperator");
            double levelComplexity = 0.0;
            this.visitMetaFaktor(anOperator.firstOperand());
            levelComplexity += anOperator.firstOperand().getFunctionalComplexity().doubleValue();
            this.visitMetaFaktor(anOperator.secondOperand());
            anOperator.setFunctionalComplexity(new Double(levelComplexity += anOperator.secondOperand().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(anOperator);
        }

        public void visitTestingOperator(MetaTestingOperator anOperator) {
            ProgramComplexityResolver.this.startLevel("TestingOperator");
            double levelComplexity = 0.0;
            switch (anOperator.type()) {
                case 1: {
                    levelComplexity = 0.03;
                    break;
                }
                case 6: {
                    levelComplexity = 0.03;
                    break;
                }
                case 3: {
                    levelComplexity = 0.03;
                    break;
                }
                case 5: {
                    levelComplexity = 0.03;
                    break;
                }
                case 2: {
                    levelComplexity = 0.03;
                    break;
                }
                case 4: {
                    levelComplexity = 0.03;
                    break;
                }
                case 7: {
                    levelComplexity = 0.03;
                    break;
                }
                default: {
                    new RuntimeException("unbekannter Operator " + anOperator.toString());
                }
            }
            this.visitMetaFaktor(anOperator.firstOperand());
            levelComplexity += anOperator.firstOperand().getFunctionalComplexity().doubleValue();
            this.visitMetaFaktor(anOperator.secondOperand());
            anOperator.setFunctionalComplexity(new Double(levelComplexity += anOperator.secondOperand().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(anOperator);
        }

        public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
            ProgramComplexityResolver.this.startLevel("SizeOfOperator");
            double levelComplexity = 0.1;
            this.visitMetaFaktor(anOperator.operand());
            anOperator.setFunctionalComplexity(new Double(levelComplexity += anOperator.operand().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(anOperator);
        }

        public void visitIndexOfOperator(MetaIndexOfOperator anOperator) {
            ProgramComplexityResolver.this.startLevel("IndexOfOperator");
            double levelComplexity = 0.0;
            this.visitMetaFaktor(anOperator.operand());
            anOperator.setFunctionalComplexity(new Double(levelComplexity += anOperator.operand().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(anOperator);
        }

        public void visitTypeCheck(MetaTypeCheck typeCheck) {
            ProgramComplexityResolver.this.startLevel("TypeCheck");
            double levelComplexity = 0.3;
            switch (typeCheck.type()) {
                case 1: {
                    break;
                }
                case 5: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 6: {
                    levelComplexity = 0.6;
                    break;
                }
            }
            this.visitMetaFaktor(typeCheck.value());
            levelComplexity += typeCheck.value().getFunctionalComplexity().doubleValue();
            if (typeCheck.maske() != null) {
                typeCheck.maske().accept(this);
                levelComplexity += typeCheck.maske().getFunctionalComplexity().doubleValue();
            }
            typeCheck.setFunctionalComplexity(new Double(levelComplexity));
            ProgramComplexityResolver.this.endLevel(typeCheck);
        }

        public void visitSetStatement(MetaSetStatement aSetStatemnt) {
            ProgramComplexityResolver.this.startLevel("SetStatement");
            double levelComplexity = 1.0;
            aSetStatemnt.setFunctionalComplexity(new Double(levelComplexity));
            ProgramComplexityResolver.this.endLevel(aSetStatemnt);
        }

        public void visitPLPruefung(MetaPLPruefung anObject) {
            if (ProgramComplexityResolver.this.isNotResolved(anObject)) {
                MetaCustomPruefung metaCustomPruefung = (MetaCustomPruefung)anObject;
                metaCustomPruefung.setFunctionalComplexity(null);
                ProgramComplexityResolver.this.resolvedElements.add(metaCustomPruefung);
                ProgramComplexityResolver resolver = this.createSubProgramComplexityResolver();
                String kommenar = "Pr\u00fcfung " + metaCustomPruefung.getName() + " Anweisung: " + metaCustomPruefung.getPLSpezifikation();
                MetaProgram metaProgram = metaCustomPruefung.getMetaSpezifikation();
                resolver.calculateProgramComplexity(metaProgram, kommenar);
                metaCustomPruefung.setFunctionalComplexity(metaProgram.getFunctionalComplexity());
            }
        }

        public void visitDsbObjekt(MetaDsbObjekt anObject) {
        }

        public void visitEinzelfeld(MetaEinzelfeld anObject) {
        }

        public void visitRawField(MetaRawField anObject) {
        }

        public void visitAuspraegungsgruppeComps(MetaAuspraegungsgruppeComps anObject) {
            double levelComplexity = 0.0;
            Iterator it = anObject.getAuspraegungen();
            while (it.hasNext()) {
                MetaAuspraegung metaAuspraegung = (MetaAuspraegung)it.next();
                metaAuspraegung.accept(this);
                levelComplexity += metaAuspraegung.getFunctionalComplexity().doubleValue();
            }
            anObject.setFunctionalComplexity(new Double(levelComplexity));
        }

        public void visitPLAblauf(MetaPLAblauf anObject) {
            if (ProgramComplexityResolver.this.isNotResolved(anObject)) {
                MetaCustomAblauf metaCustomAblauf = (MetaCustomAblauf)anObject;
                metaCustomAblauf.setFunctionalComplexity(null);
                ProgramComplexityResolver.this.resolvedElements.add(metaCustomAblauf);
                ProgramComplexityResolver resolver = this.createSubProgramComplexityResolver();
                String kommenar = "Ablauf " + metaCustomAblauf.getName() + " Spezifikation: " + metaCustomAblauf.getSpezifikation();
                MetaProgram metaProgram = metaCustomAblauf.getMetaSpezifikation();
                resolver.calculateProgramComplexity(metaProgram, kommenar);
                metaCustomAblauf.setFunctionalComplexity(metaProgram.getFunctionalComplexity());
            }
        }

        public void visitAuspraegung(MetaAuspraegung anObject) {
        }

        public void visitDsbFeld(MetaDsbFeld anObject) {
        }

        public void visitStatspezKomponente(MetaStatspezKomponente anObject) {
        }

        public void visitDsbMultiKommentar(MetaDsbMultiKommentar anObject) {
        }

        public void visitPlausibilisierung(MetaPlausibilisierung anObject) {
            MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)anObject;
            TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
            Hashtable tbScopes = new Hashtable();
            Scope scope = scopeBuilder.createScopes(plausi, tbScopes);
            CrossReferenceBuilder crossReferenceBuilder = new CrossReferenceBuilder();
            crossReferenceBuilder.buildCrossReference(plausi, scope, tbScopes);
            ProgramComplexityResolver.this.resolvedElements = new ArrayList();
            ProgramComplexityResolver.this.setLog(ProgramComplexityResolver.this.log);
            int i = 0;
            while (i < plausi.sizeOfAuspraegungsgruppen()) {
                plausi.getFromAuspraegungsgruppen(i).accept(this);
                ++i;
            }
            i = 0;
            while (i < plausi.sizeOfMerkmale()) {
                plausi.getFromMerkmale(i).accept(this);
                ++i;
            }
            i = 0;
            while (i < plausi.sizeOfFunktionen()) {
                plausi.getFromFunktionen(i).accept(this);
                ++i;
            }
            MetaCustomThemenbereich rootTB = (MetaCustomThemenbereich)plausi.rootThemenbereich();
            int i2 = 0;
            while (i2 < rootTB.sizeOfAblaeufe()) {
                MetaCustomAblauf ablauf = (MetaCustomAblauf)rootTB.getFromAblaeufe(i2);
                String kommentar = "Ablauf " + ablauf.getName() + " Anweisung:\n" + ablauf.getSpezifikation();
                MetaProgram metaProgram = ablauf.getMetaSpezifikation();
                ProgramComplexityResolver.this.calculateProgramComplexity(metaProgram, kommentar);
                ablauf.setFunctionalComplexity(metaProgram.getFunctionalComplexity());
                ++i2;
            }
        }

        public void visitPLInitwert(MetaPLInitwert anObject) {
        }

        public void visitStatspezObjekt(MetaStatspezObjekt anObject) {
        }

        public void visitPLEigenschaft(MetaPLEigenschaft anObject) {
        }

        public void visitDsbKommentar(MetaDsbKommentar anObject) {
        }

        public void visitTBFeld(MetaTBFeld anObject) {
        }

        public void visitRawSet(MetaRawSet anObject) {
        }

        public void visitRawDataSet(MetaRawDataSet anObject) {
        }

        public void visitPLVariable(MetaPLVariable anObject) {
        }

        public void visitDsbZeilenKommentar(MetaDsbZeilenKommentar anObject) {
        }

        public void visitRawFieldGroup(MetaRawFieldGroup anObject) {
        }

        public void visitPLFunktion(MetaPLFunktion anObject) {
            if (ProgramComplexityResolver.this.isNotResolved(anObject)) {
                MetaCustomFunktion metaCustomFunktion = (MetaCustomFunktion)anObject;
                metaCustomFunktion.setFunctionalComplexity(null);
                ProgramComplexityResolver.this.resolvedElements.add(metaCustomFunktion);
                String kommentar = "Funktion " + metaCustomFunktion.getName() + " Anweisung: " + metaCustomFunktion.getAnweisungen();
                ProgramComplexityResolver resolver = this.createSubProgramComplexityResolver();
                MetaProgram metaProgram = metaCustomFunktion.getMetaSpezifikation();
                resolver.calculateProgramComplexity(metaProgram, kommentar);
                metaCustomFunktion.setFunctionalComplexity(metaProgram.getFunctionalComplexity());
            }
        }

        public void visitPLMaterial(MetaPLMaterial anObject) {
        }

        public void visitMerkmal(MetaMerkmal anObject) {
            if (ProgramComplexityResolver.this.isNotResolved(anObject)) {
                MetaCustomMerkmal merkmal = (MetaCustomMerkmal)anObject;
                merkmal.setFunctionalComplexity(null);
                ProgramComplexityResolver.this.resolvedElements.add(merkmal);
                String kommentar = "Merkmalspr\u00fcfung " + merkmal.getName() + " PLSpezifikation: " + merkmal.getPLSpezifikation();
                ProgramComplexityResolver resolver = this.createSubProgramComplexityResolver();
                MetaProgram metaProgram = merkmal.getMetaSpezifikation();
                resolver.calculateProgramComplexity(metaProgram, kommentar);
                merkmal.setFunctionalComplexity(metaProgram.getFunctionalComplexity());
            }
        }

        public void visitSatzart(MetaSatzart anObject) {
        }

        public void visitPLParameter(MetaPLParameter anObject) {
        }

        public void visitMapping(MetaMapping anObject) {
        }

        public void visitMappingElement(MetaMappingElement anObject) {
        }

        public void visitDsbComps(MetaDsbComps anObject) {
        }

        public void visitRefAuspraegung(MetaRefAuspraegung anObject) {
        }

        public void visitTBMaterialReferenz(MetaTBMaterialReferenz anObject) {
        }

        public void visitThemenbereich(MetaThemenbereich anObject) {
        }

        public void visitNumber(MetaNumber aNumber) {
            ProgramComplexityResolver.this.startLevel("Number");
            double result = 0.0;
            aNumber.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(aNumber);
        }

        public void visitBoolean(MetaBoolean aBoolean) {
            ProgramComplexityResolver.this.startLevel("Boolean");
            double result = 0.0;
            aBoolean.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(aBoolean);
        }

        public void visitString(MetaString aString) {
            ProgramComplexityResolver.this.startLevel("String");
            double result = 0.0;
            aString.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(aString);
        }

        public void visitDate(MetaDate aDate) {
            ProgramComplexityResolver.this.startLevel("Date");
            double result = 0.1;
            aDate.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(aDate);
        }

        public void visitNoValue(MetaNoValue value) {
            ProgramComplexityResolver.this.startLevel("NoValue");
            double result = 0.0;
            value.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(value);
        }

        public void visitIdentifier(MetaIdentifier anIdentifier) {
            ProgramComplexityResolver.this.startLevel("Identifier");
            double result = 0.0;
            anIdentifier.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(anIdentifier);
        }

        public void visitSelfAccess(MetaSelfAccess aSelfAccess) {
            ProgramComplexityResolver.this.startLevel("SelfAccess");
            double result = 0.0;
            aSelfAccess.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(aSelfAccess);
        }

        public void visitForEachIndexOperand(MetaForEachIndexOperator aForEachIndexOperand) {
            ProgramComplexityResolver.this.startLevel("ForEachIndexOperand");
            double result = 0.0;
            aForEachIndexOperand.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(aForEachIndexOperand);
        }

        public void visitBreakStatement(MetaBreakStatement aStatement) {
            ProgramComplexityResolver.this.startLevel("Break");
            double result = 0.0;
            aStatement.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitErrorStatement(MetaErrorStatement aStatement) {
            ProgramComplexityResolver.this.startLevel("Error");
            double result = 0.07;
            aStatement.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitProgramParameter(MetaProgramParameter aParameter) {
            ProgramComplexityResolver.this.startLevel("ProgramParameter");
            double result = 0.0;
            aParameter.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(aParameter);
        }

        public void visitMapStatement(MetaMapStatement aStatement) {
            ProgramComplexityResolver.this.startLevel("Map");
            double result = 0.0;
            aStatement.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        public void visitWithOperator(MetaWithOperator anOperator) {
            ProgramComplexityResolver.this.startLevel("WithOperator");
            double result = 0.0;
            this.visitMetaFaktor(anOperator.operand());
            anOperator.setFunctionalComplexity(new Double(result += anOperator.operand().getFunctionalComplexity().doubleValue()));
            ProgramComplexityResolver.this.endLevel(anOperator);
        }

        public void visitSizeTestingOperator(MetaSizeTestingOperator anOperator) {
            ProgramComplexityResolver.this.startLevel("SizeTestingOperator");
            double result = 0.0;
            anOperator.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(anOperator);
        }

        public void visitHierarchicalOperator(MetaHierarchicalOperator anOperator) {
            ProgramComplexityResolver.this.startLevel("HierarchicalOperator");
            double result = 0.0;
            anOperator.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(anOperator);
        }

        public void visitContextOperator(MetaContextOperator anOperator) {
            ProgramComplexityResolver.this.startLevel("ContextOperator");
            double result = 0.0;
            anOperator.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(anOperator);
        }

        public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop aStatement) {
            ProgramComplexityResolver.this.startLevel("HierarchicalForEachLoop");
            double result = 0.0;
            aStatement.setFunctionalComplexity(new Double(result));
            ProgramComplexityResolver.this.endLevel(aStatement);
        }

        private void visitMetaFaktor(MetaFactor metaFactor) {
            metaFactor.accept(this);
            MetaElement metaElement = (MetaElement)((Object)metaFactor.adaptedObject());
            metaFactor.setFunctionalComplexity(new Double(metaElement.getFunctionalComplexity()));
        }

        private void visitMetaRightValue(MetaRightValue metaRightValue) {
            MetaElement metaElement = (MetaElement)((Object)metaRightValue.value());
            if (metaElement instanceof MetaFactor) {
                this.visitMetaFaktor((MetaFactor)metaElement);
            } else {
                metaElement.accept(this);
            }
            metaRightValue.setFunctionalComplexity(new Double(metaElement.getFunctionalComplexity()));
        }

        private ProgramComplexityResolver createSubProgramComplexityResolver() {
            ProgramComplexityResolver resolver = new ProgramComplexityResolver(ProgramComplexityResolver.this.resolvedElements);
            resolver.setLog(ProgramComplexityResolver.this.log);
            return resolver;
        }
    }
}

