/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.meta.MetaCustomEinzelfeld;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Dsb_FieldTypeParser
extends SubParser {
    private MetaEinzelfeld currentEf = null;
    private short stufe = 1;
    private boolean canEnabled = true;

    public Dsb_FieldTypeParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && "fieldType".equalsIgnoreCase(tag)) {
            return this.canEnabled;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("fieldType".equalsIgnoreCase(localName)) {
            this.enable();
            this.currentEf = new MetaCustomEinzelfeld();
            this.currentEf.setStufenNr(this.stufe);
        }
        this.handleAttributes(namespaceURI, localName, qName, atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("fieldType".equalsIgnoreCase(localName)) {
            this.disableAndNotify();
        } else if (!this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    public MetaElement object() {
        return this.currentEf;
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("fieldType".equalsIgnoreCase(localName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new ILParseException("Fuer die Einzelfeld ist kein Name definiert!");
            }
            this.currentEf.setName(name.trim());
            String id = atts.getValue("id");
            if (id != null && id.trim().length() > 0 && this.resolver().isUseIDasRef()) {
                this.currentEf.setId(id.trim());
            } else if (!this.resolver().isUseIDasRef()) {
                this.currentEf.setId(name);
            }
        } else if ("location".equalsIgnoreCase(localName)) {
            String str = atts.getValue("absolute-offset");
            if (str == null) {
                throw new ILParseException("Fuer das Einzelfeld ist keine Von-Position definiert!");
            }
            int von = Integer.parseInt(str.trim());
            this.currentEf.setSatzVon(von);
            str = atts.getValue("length");
            if (str == null) {
                throw new ILParseException("Fuer das Einzelfeld ist keine Laenge definiert!");
            }
            int anz = Integer.parseInt(str.trim());
            this.currentEf.setSatzAnz(anz);
            this.currentEf.setSatzBis(von + anz - 1);
        } else if ("genericDataType".equalsIgnoreCase(localName)) {
            String str = atts.getValue("name");
            if (str != null) {
                this.currentEf.setTyp(str.trim());
            }
            str = atts.getValue("class");
            str = atts.getValue("base-type");
            str = atts.getValue("fraction-digits");
            str = atts.getValue("total-digits");
            str = atts.getValue("white-space");
            str = atts.getValue("zero-equivalent");
            str = atts.getValue("zero-equivalent-character");
        } else if ("applicationDataType".equalsIgnoreCase(localName)) {
            String str = atts.getValue("name");
            if (str != null) {
                this.currentEf.setTypIntern(str.trim());
            }
            str = atts.getValue("class");
            str = atts.getValue("type");
            str = atts.getValue("fraction-digits");
            str = atts.getValue("total-digits");
        } else if ("encoding".equalsIgnoreCase(localName)) {
            String str = atts.getValue("name");
            str = atts.getValue("class");
        }
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) throws SAXException {
        boolean handled = true;
        if ("annotation".equalsIgnoreCase(localName)) {
            String chars = this.superParser().charData().toString();
            this.currentEf.setInhalt(chars);
        } else if (!("location".equalsIgnoreCase(localName) || "genericDataType".equalsIgnoreCase(localName) || "applicationDataType".equalsIgnoreCase(localName) || "encoding".equalsIgnoreCase(localName))) {
            handled = false;
        }
        return handled;
    }

    public void setStufe(short s) {
        this.stufe = s;
    }

    public boolean isCanEnabled() {
        return this.canEnabled;
    }

    public void setCanEnabled(boolean b) {
        this.canEnabled = b;
    }
}

