/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.cpp.CppProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.HelperVisitor;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaDate;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaNoValue;

class CppSetValueStrategy
extends HelperVisitor {
    public CppSetValueStrategy(CppProgramCodeGenerator generator) {
        super(generator);
    }

    public void visitFieldAccess(MetaFieldAccess anAccess) {
        if (!this.scope().isDefined(anAccess.accessedField(), this.namespace())) {
            this.error(anAccess, String.valueOf(anAccess.accessedField().toString()) + " ist nicht in diesem Gueltigkeitsbereich definiert " + "(Scope: " + this.namespace() + ")");
            return;
        }
        SymbolDescriptor sd = this.scope().symbolDescriptor(anAccess.accessedField(), this.namespace());
        if (sd.isArray()) {
            this.error(anAccess, "die Liste " + anAccess.accessedField().toString() + " kann nicht als Feld verwendet werden");
        }
        if (sd.isLokaleVariable()) {
            this.out().print("(&");
        }
        this.out().print(StringHelper.getEscapedName(anAccess.accessedField().value()));
        if (sd.isLokaleVariable()) {
            this.out().print(")");
        }
        this.out().print("->set(context, ");
    }

    public void visitArrayAccess(MetaArrayAccess anAccess) {
        if (!this.scope().isDefined(anAccess.accessedArray(), this.namespace())) {
            this.error(anAccess, String.valueOf(anAccess.accessedArray().toString()) + " ist in diesem Gueltigkeitsbereich nicht definiert " + "(Scope: " + this.namespace() + ")");
            return;
        }
        if (!this.scope().symbolDescriptor(anAccess.accessedArray(), this.namespace()).isArray()) {
            this.error(anAccess, String.valueOf(anAccess.accessedArray().toString()) + " ist keine Liste");
        }
        this.out().print("->set(context, ");
    }

    public void visitClassificationReference(MetaClassificationReference anAccess) {
        this.error(anAccess, "eine Auspraegung kann nicht veraendert werden");
    }

    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        this.error(anAccess, "ein Literal kann nicht veraendert werden");
    }

    public void visitDate(MetaDate aDate) {
        this.error(aDate, "ein Datum kann nicht veraendert werden");
    }

    public void visitNoValue(MetaNoValue noValue) {
        this.error(noValue, "ein Leer-Wert kann nicht veraendert werden");
    }
}

