/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.Settings;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.DefaultTextResource;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.TbScopeBuilder;
import de.statspez.pleditor.generator.codegen.support.TextResource;
import de.statspez.pleditor.generator.common.DefaultMessageContext;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import java.util.HashMap;
import java.util.Hashtable;

public abstract class AbstractCodegenContext
implements CodegenContext {
    private MetaPlausibilisierung plausi;
    private TextResource textResource;
    private String plausiPackage;
    private String plausiClassName;
    private String plausiSegmentClassNameSuffix;
    private MessageContextInterface messageContext;
    private Scope plausiScope;
    private Hashtable topicScopes;
    private HashMap contextInfos;
    private int[] maxElementsInSegment;
    private int numOfSegments;
    private boolean generateRAWMapping = false;
    private boolean generateDSBMapping = false;
    private boolean ignoreWarnings = false;
    private boolean testmode = false;
    private static final String[] TYPES_MAX_ELEMENTS_IN_SEGMENT = new String[]{"max_literal", "max_apg", "max_mapping", "max_fehlererzeugung", "max_fehlerids", "max_felder", "max_anweisungen", "max_reihe"};

    public AbstractCodegenContext(MetaPlausibilisierung plausi) {
        if (plausi == null) {
            throw new IllegalArgumentException("Keine Plausibilisierung angegeben.");
        }
        if (plausi.getPLName() == null || plausi.getPLName().length() == 0) {
            throw new IllegalArgumentException("Kein Name der Plausibilisierung angegeben.");
        }
        this.plausi = plausi;
        this.textResource = new DefaultTextResource();
        this.plausiPackage = "de.statspez.plausi.generated";
        this.plausiClassName = "Plausi_" + StringHelper.getEscapedName(plausi.getPLName());
        this.plausiSegmentClassNameSuffix = "_Segment";
        this.messageContext = new DefaultMessageContext("Plausibilsierung " + plausi.getName());
        this.topicScopes = new Hashtable();
        TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
        this.plausiScope = scopeBuilder.createScopes(plausi, this.topicScopes);
        this.contextInfos = new HashMap();
        this.maxElementsInSegment = new int[Settings.DEFAULT_MAX_ELEMENTS_IN_SEGMENT.length];
        int i = 0;
        while (i < this.maxElementsInSegment.length) {
            this.maxElementsInSegment[i] = this.getDefinedMaxElementInSegment(i);
            ++i;
        }
    }

    public void setTextResource(TextResource textResource) {
        this.textResource = textResource;
    }

    public void setPlausiPackage(String plausiPackage) {
        this.plausiPackage = plausiPackage;
    }

    public void setPlausiClassName(String plausiClassName) {
        this.plausiClassName = StringHelper.getEscapedName(plausiClassName);
    }

    public void setPlausiSegmentClassNameSuffix(String plausiSegmentClassNameSuffix) {
        this.plausiSegmentClassNameSuffix = plausiSegmentClassNameSuffix;
    }

    public void setMessageContext(MessageContextInterface messageContext) {
        this.messageContext = messageContext;
    }

    public void setMaxElementsInSegment(int type, int maxElementsInSegment) {
        if (type < 0 || type >= this.maxElementsInSegment.length) {
            throw new IllegalArgumentException("Typ nicht definiert: " + type);
        }
        if (maxElementsInSegment < 1) {
            throw new IllegalArgumentException("Maximale Anzahl ist ung\u00fcltig: " + maxElementsInSegment);
        }
        this.maxElementsInSegment[type] = maxElementsInSegment;
    }

    public boolean isGenerateRAWMapping() {
        return this.generateRAWMapping;
    }

    public void setGenerateRAWMapping(boolean generateRAWMapping) {
        this.generateRAWMapping = generateRAWMapping;
    }

    public boolean isGenerateDSBMapping() {
        return this.generateDSBMapping;
    }

    public void setGenerateDSBMapping(boolean generateDSBMapping) {
        this.generateDSBMapping = generateDSBMapping;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public boolean isTestmode() {
        return this.testmode;
    }

    public void setTestmode(boolean testmode) {
        this.testmode = testmode;
    }

    public MetaPlausibilisierung getPlausi() {
        return this.plausi;
    }

    public TextResource getTextResource() {
        return this.textResource;
    }

    public String getPlausiPackage() {
        return this.plausiPackage;
    }

    public String getPlausiClassName() {
        return this.plausiClassName;
    }

    public String getNextPlausiSegmentClassName() {
        ++this.numOfSegments;
        return String.valueOf(this.getPlausiClassName()) + this.plausiSegmentClassNameSuffix + this.numOfSegments;
    }

    public MessageContextInterface getMessageContext() {
        return this.messageContext;
    }

    public Scope getPlausiScope() {
        return this.plausiScope;
    }

    public Hashtable getTopicScopes() {
        return this.topicScopes;
    }

    public void putContextInfo(Object key, Object info) {
        this.contextInfos.put(key, info);
    }

    public Object getContextInfo(Object key) {
        return this.contextInfos.get(key);
    }

    public int getMaxElementsInSegment(int type) {
        return this.maxElementsInSegment[type];
    }

    protected int getDefinedMaxElementInSegment(int type) {
        int result = Settings.DEFAULT_MAX_ELEMENTS_IN_SEGMENT[type];
        if (this.plausi.getKommentar() != null && this.plausi.getKommentar().length() > 0) {
            String keyword = String.valueOf(TYPES_MAX_ELEMENTS_IN_SEGMENT[type]) + ":";
            int index = this.plausi.getKommentar().indexOf(keyword);
            if (index >= 0) {
                StringBuffer number = new StringBuffer();
                int i = index + keyword.length();
                while (i < this.plausi.getKommentar().length() && this.plausi.getKommentar().charAt(i) == ' ') {
                    ++i;
                }
                if (i < this.plausi.getKommentar().length()) {
                    while (i < this.plausi.getKommentar().length() && Character.isDigit(this.plausi.getKommentar().charAt(i))) {
                        number.append(this.plausi.getKommentar().charAt(i));
                        ++i;
                    }
                    if (number.length() > 0) {
                        result = Integer.parseInt(number.toString());
                    }
                }
            }
        }
        return result;
    }
}

