/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaBooleanOperator;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaForEachCheck;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaIndexOfOperator;
import de.statspez.pleditor.generator.meta.MetaInterval;
import de.statspez.pleditor.generator.meta.MetaLiteralAccess;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaMathOperator;
import de.statspez.pleditor.generator.meta.MetaMultiAssignment;
import de.statspez.pleditor.generator.meta.MetaPrintStatement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaReturnStatement;
import de.statspez.pleditor.generator.meta.MetaSequence;
import de.statspez.pleditor.generator.meta.MetaSignOperator;
import de.statspez.pleditor.generator.meta.MetaSingleAssignment;
import de.statspez.pleditor.generator.meta.MetaSingleValueRange;
import de.statspez.pleditor.generator.meta.MetaSizeOfOperator;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaTypeCheck;
import de.statspez.pleditor.generator.meta.MetaUnaryBoolOperator;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import java.util.Iterator;

public class AbstractCodeTraverser
extends AbstractElementVisitor {
    public void visitFieldAccess(MetaFieldAccess aFieldAccess) {
        aFieldAccess.accessedField().accept(this);
    }

    public void visitLiteralAccess(MetaLiteralAccess anAccess) {
        anAccess.accessedLiteral().accept(this);
    }

    public void visitClassificationReference(MetaClassificationReference aReference) {
        Iterator it = aReference.levels();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
    }

    public void visitRangeSeries(MetaRangeSeries aRangeSeries) {
        Iterator it = aRangeSeries.ranges();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
    }

    public void visitSingleValueRange(MetaSingleValueRange aRange) {
        aRange.value().accept(this);
    }

    public void visitSequence(MetaSequence aSequence) {
        aSequence.first().accept(this);
        aSequence.second().accept(this);
        aSequence.last().accept(this);
    }

    public void visitInterval(MetaInterval anInterval) {
        anInterval.first().accept(this);
        anInterval.last().accept(this);
    }

    public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
        Iterator it = anArrayAccess.indices();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
    }

    public void visitStructureAccess(MetaStructureAccess aStructureAccess) {
        aStructureAccess.structureAccess().accept(this);
        aStructureAccess.selectedElement().accept(this);
    }

    public void visitMaterialAccess(MetaMaterialAccess anAccess) {
        anAccess.material().accept(this);
        Iterator it = anAccess.selectedFields();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
        it = anAccess.selectionConditions();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
    }

    public void visitStatementSequence(MetaStatementSequence aSequence) {
        Iterator it = aSequence.statements();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
    }

    public void visitSingleAssignment(MetaSingleAssignment anAssignment) {
        anAssignment.leftValue().accept(this);
        anAssignment.rightValue().accept(this);
    }

    public void visitMultiAssignment(MetaMultiAssignment anAssignment) {
        Iterator it = anAssignment.leftValues();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
        anAssignment.rightValue().accept(this);
    }

    public void visitConditionalStatement(MetaConditionalStatement aStatement) {
        aStatement.condition().accept(this);
        aStatement.ifTrue().accept(this);
        aStatement.ifFalse().accept(this);
    }

    public void visitForNextLoop(MetaForNextLoop aStatement) {
        aStatement.startAssignment().accept(this);
        aStatement.endCondition().accept(this);
        aStatement.stepExpression().accept(this);
        aStatement.loopBody().accept(this);
    }

    public void visitForEachLoop(MetaForEachLoop aStatement) {
        aStatement.loopBody().accept(this);
    }

    public void visitForEachCheck(MetaForEachCheck aStatement) {
        aStatement.condition().accept(this);
    }

    public void visitWhileLoop(MetaWhileLoop aStatement) {
        aStatement.condition().accept(this);
        aStatement.loopBody().accept(this);
    }

    public void visitPrintStatement(MetaPrintStatement aStatement) {
        Iterator it = aStatement.toPrint();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
    }

    public void visitPruefeStatement(MetaPruefeStatement aStatement) {
        aStatement.function().accept(this);
    }

    public void visitAblaufStatement(MetaAblaufStatement aStatement) {
        aStatement.function().accept(this);
    }

    public void visitCheckFeldStatement(MetaCheckFeldStatement aStatement) {
        aStatement.field().accept(this);
    }

    public void visitReturnStatement(MetaReturnStatement aStatement) {
        aStatement.returnValue().accept(this);
    }

    public void visitFunctionCall(MetaFunctionCall aStatement) {
        aStatement.function().accept(this);
        Iterator it = aStatement.parameters();
        while (it.hasNext()) {
            ((MetaElement)it.next()).accept(this);
        }
    }

    public void visitProgram(MetaProgram aProgram) {
        aProgram.statements().accept(this);
    }

    public void visitVarDeclaration(MetaVarDeclaration aDeclaration) {
        Iterator ids = aDeclaration.identifiers();
        while (ids.hasNext()) {
            ((MetaElement)ids.next()).accept(this);
        }
    }

    public void visitMathOperator(MetaMathOperator anOperator) {
        anOperator.firstOperand().accept(this);
        anOperator.secondOperand().accept(this);
    }

    public void visitSignOperator(MetaSignOperator anOperator) {
        anOperator.operand().accept(this);
    }

    public void visitUnaryBoolOperator(MetaUnaryBoolOperator anOperator) {
        anOperator.operand().accept(this);
    }

    public void visitBooleanOperator(MetaBooleanOperator anOperator) {
        anOperator.firstOperand().accept(this);
        anOperator.secondOperand().accept(this);
    }

    public void visitTestingOperator(MetaTestingOperator anOperator) {
        anOperator.firstOperand().accept(this);
        anOperator.secondOperand().accept(this);
    }

    public void visitSizeOfOperator(MetaSizeOfOperator anOperator) {
        anOperator.operand().accept(this);
    }

    public void visitIndexOfOperator(MetaIndexOfOperator anOperator) {
        anOperator.operand().accept(this);
    }

    public void visitTypeCheck(MetaTypeCheck typeCheck) {
        typeCheck.value().accept(this);
        if (typeCheck.maske() != null) {
            typeCheck.maske().accept(this);
        }
    }
}

