/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.format;

import de.statspez.pleditor.generator.format.CodeSegment;
import de.statspez.pleditor.generator.format.FormatSegment;
import de.statspez.pleditor.generator.format.Segment;
import de.statspez.pleditor.generator.format.SegmentSequence;
import de.statspez.pleditor.generator.format.TextSegment;
import java.text.ParseException;

public class FormatParser {
    public static Segment parse(String text) throws ParseException {
        SegmentSequence segmentSequence;
        Segment segment = text == null ? null : (text.length() == 0 ? new TextSegment("") : ((segmentSequence = FormatParser.parse(text.toCharArray(), 0, text.length())).getSize() == 1 ? segmentSequence.getSegment(0) : segmentSequence));
        return segment;
    }

    private static SegmentSequence parse(char[] text, int start, int end) throws ParseException {
        SegmentSequence segmentSequence = new SegmentSequence();
        int i = start;
        while (i < end) {
            if (FormatParser.isCode(text, i)) {
                if (i > start) {
                    segmentSequence.addSegment(new TextSegment(new String(text, start, i - start)));
                }
                int j = ++i;
                while (j < end && !FormatParser.isCode(text, j)) {
                    ++j;
                }
                if (j == end) {
                    throw new ParseException("Code-Segment wurde nicht geschlossen.", i - 1);
                }
                segmentSequence.addSegment(new CodeSegment(new String(text, i, j - i)));
                start = j + 1;
                i = j;
            } else {
                int f = 0;
                while (f < FormatSegment.FORMATS.length) {
                    char format = FormatSegment.FORMATS[f];
                    if (FormatParser.isFormat(format, text, i)) {
                        if (i > start) {
                            segmentSequence.addSegment(new TextSegment(new String(text, start, i - start)));
                        }
                        int j = i += 3;
                        while (j < end && !FormatParser.isFormat(format, text, j)) {
                            ++j;
                        }
                        if (j == end) {
                            throw new ParseException("Format-Segment {" + format + "} wurde nicht geschlossen.", i - 3);
                        }
                        SegmentSequence formatedSegmentList = FormatParser.parse(text, i, j);
                        segmentSequence.addSegment(new FormatSegment(format, formatedSegmentList.getSize() == 1 ? formatedSegmentList.getSegment(0) : formatedSegmentList));
                        start = j + 3;
                        i = j + 2;
                        break;
                    }
                    ++f;
                }
            }
            ++i;
        }
        if (start < end) {
            segmentSequence.addSegment(new TextSegment(new String(text, start, end - start)));
        }
        return segmentSequence;
    }

    private static boolean isCode(char[] text, int offset) {
        return offset < text.length && text[offset] == '$';
    }

    private static boolean isFormat(char format, char[] text, int offset) {
        return offset < text.length - 2 && text[offset] == '{' && text[offset + 1] == format && text[offset + 2] == '}';
    }
}

