/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime.test;

import de.statspez.pleditor.generator.codegen.js.CodegenFacade;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import de.statspez.pleditor.generator.parser.speclanguage.SpecLangParseException;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFactory;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.test.JavaScriptPlausiTestPerformer;
import de.statspez.pleditor.generator.runtime.test.PlausiTest;
import de.statspez.pleditor.generator.runtime.test.PlausiTestExecutor;
import de.statspez.pleditor.generator.runtime.test.PlausiTestHandler;
import de.statspez.pleditor.generator.runtime.test.PlausiTestInterpreter;
import de.statspez.pleditor.generator.runtime.test.PlausiTestResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class PlausiTestFacade {
    private static final String PARAM_TEST_DIR = "-testdir";
    private static final String PARAM_TEMP_DIR = "-tempdir";

    public static void main(String[] args) throws IOException {
        File tempDir;
        File testDir;
        String testDirName = null;
        String tempDirName = null;
        if (args != null && args.length > 1) {
            int i = 0;
            while (i < args.length - 1) {
                if (args[i].equalsIgnoreCase(PARAM_TEST_DIR)) {
                    testDirName = args[i + 1];
                } else if (args[i].equalsIgnoreCase(PARAM_TEMP_DIR)) {
                    tempDirName = args[i + 1];
                }
                ++i;
            }
        }
        if (!(testDir = testDirName != null && testDirName.length() > 0 ? new File(testDirName) : new File(".")).exists()) {
            System.err.println("Das Test-Verzeichnis " + testDir.getAbsolutePath() + " existiert nicht.");
            System.exit(-1);
        }
        if (!testDir.isDirectory()) {
            System.err.println(String.valueOf(testDir.getAbsolutePath()) + " ist kein g\u00fcltiges Test-Verzeichnis.");
            System.exit(-1);
        }
        if (!(tempDir = tempDirName != null && tempDirName.length() > 0 ? new File(tempDirName) : new File(System.getProperty("java.io.tmpdir"))).exists()) {
            System.err.println("Das Temp-Verzeichnis " + tempDir.getAbsolutePath() + " existiert nicht.");
            System.exit(-1);
        }
        if (!tempDir.isDirectory()) {
            System.err.println(String.valueOf(tempDir.getAbsolutePath()) + " ist kein g\u00fcltiges Temp-Verzeichnis.");
            System.exit(-1);
        }
        PlausiTestFacade plausiTestSuite = new PlausiTestFacade();
        plausiTestSuite.performTestsInDir(testDir, tempDir, new PlausiTestHandler(){

            public void testStarted(File testFile) {
                System.out.println("F\u00fchre Test " + testFile.getAbsolutePath() + " aus...");
            }

            public void testFinished(PlausiTestResult executorResult, PlausiTestResult interpreterResult, PlausiTestResult javaScriptResult) {
                if (executorResult.isFailed()) {
                    System.err.println("Java-PL-Test fehlgeschlagen:");
                    System.err.println(executorResult);
                } else {
                    System.out.print("Java-PL-Test erfolgreich. ");
                    System.out.println(executorResult.getDurationMessage());
                }
                if (interpreterResult.isFailed()) {
                    System.err.println("Interpreter-PL-Test fehlgeschlagen:");
                    System.err.println(interpreterResult);
                } else {
                    System.out.print("Interpreter-PL-Test erfolgreich. ");
                    System.out.println(interpreterResult.getDurationMessage());
                }
                if (javaScriptResult.isFailed()) {
                    System.err.println("JavaScript-PL-Test fehlgeschlagen:");
                    System.err.println(javaScriptResult);
                } else {
                    System.out.print("JavaScript-PL-Test erfolgreich. ");
                    System.out.println(javaScriptResult.getDurationMessage());
                }
                System.out.println();
            }

            public void errorOccured(Throwable error) {
                if (error instanceof ILParseException) {
                    System.err.println("Beim Parsen der EDT-Datei ist ein Fehler aufgetreten:");
                    System.err.println(error.getMessage());
                    error.printStackTrace();
                } else if (error instanceof SpecLangParseException) {
                    System.err.println("Beim Parsen der EDT-Datei ist ein Fehler aufgetreten:");
                    System.err.println(error.getMessage());
                    System.err.println(((SpecLangParseException)error).messagesAsText());
                } else if (error instanceof CodegenException) {
                    System.err.println("Bei der Code-Erzeugung sind Fehler/Warnungen aufgetreten:");
                    System.err.println(error.getMessage());
                    System.err.println(((CodegenException)error).errorsAsText());
                    System.err.println(((CodegenException)error).warningsAsText());
                } else {
                    error.printStackTrace();
                }
            }
        });
    }

    public void performTestsInDir(File dir, File tempDir, PlausiTestHandler handler) {
        File testTempDir = new File(tempDir, "pltest" + System.currentTimeMillis());
        if (testTempDir.exists()) {
            throw new RuntimeException("Das Verzeichnis " + testTempDir.getAbsolutePath() + " existiert bereits.");
        }
        testTempDir.mkdir();
        try {
            this.doPerformTestsInDir(dir, testTempDir, handler);
        }
        finally {
            this.delete(testTempDir);
        }
    }

    private void doPerformTestsInDir(File dir, File tempDir, PlausiTestHandler handler) {
        PlausiFactory plausiFactory = new PlausiFactory();
        File[] tests = dir.listFiles();
        int i = 0;
        while (i < tests.length) {
            block10: {
                if (tests[i].isDirectory()) {
                    this.doPerformTestsInDir(tests[i], tempDir, handler);
                } else {
                    File testFile = tests[i];
                    if (testFile.getName().startsWith("test_") && testFile.getName().endsWith(".xml")) {
                        try {
                            try {
                                handler.testStarted(testFile);
                                PlausiTest test = new PlausiTest(testFile);
                                File edtFile = new File(test.getPlausiFileName());
                                if (!edtFile.isAbsolute()) {
                                    edtFile = new File(testFile.getParentFile(), test.getPlausiFileName());
                                }
                                MetaCustomPlausibilisierung metaPlausi = this.createMetaPlausi(edtFile);
                                this.generateJava(metaPlausi, edtFile, tempDir, test.containsDsbMappingTestCase(), test.containsRawMappingTestCase());
                                this.compileJava(tempDir);
                                File javaScriptPlausiFile = this.generateJavaScript(metaPlausi, tempDir);
                                PlausiInterface plausi = plausiFactory.createPlausi(metaPlausi.getName(), new URLClassLoader(new URL[]{tempDir.toURI().toURL()}));
                                PlausiTestResult executorResult = new PlausiTestExecutor().execute(plausi, test);
                                PlausiTestResult interpreterResult = new PlausiTestInterpreter().execute(metaPlausi, test);
                                PlausiTestResult javaScriptResult = new JavaScriptPlausiTestPerformer().execute(metaPlausi, javaScriptPlausiFile, test);
                                handler.testFinished(executorResult, interpreterResult, javaScriptResult);
                            }
                            catch (Throwable e) {
                                handler.errorOccured(e);
                                this.clear(tempDir);
                                break block10;
                            }
                        }
                        catch (Throwable throwable) {
                            this.clear(tempDir);
                            throw throwable;
                        }
                        this.clear(tempDir);
                    }
                }
            }
            ++i;
        }
    }

    private MetaCustomPlausibilisierung createMetaPlausi(File file) throws Exception {
        MetaCustomPlausibilisierung plausi = null;
        FileReader in = new FileReader(file);
        try {
            IntermediateLanguageParser parser = new IntermediateLanguageParser();
            plausi = (MetaCustomPlausibilisierung)parser.parse(in);
        }
        finally {
            in.close();
        }
        return plausi;
    }

    private void generateJava(MetaCustomPlausibilisierung metaCustomPlausi, File file, File classesDir, boolean generateDsbMapping, boolean generateRawMapping) throws Exception {
        de.statspez.pleditor.generator.codegen.java.CodegenFacade generator = new de.statspez.pleditor.generator.codegen.java.CodegenFacade();
        generator.generate(metaCustomPlausi, classesDir.getAbsolutePath(), generateDsbMapping, generateRawMapping);
    }

    private void compileJava(File classesDir) throws Exception {
        String packageDirName = "de.statspez.plausi.generated".replaceAll("\\.", "/");
        File packageDir = new File(classesDir, packageDirName);
        File[] javaFiles = packageDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".java");
            }
        });
        String[] args = new String[4 + javaFiles.length];
        args[0] = "-d";
        args[1] = classesDir.getAbsolutePath();
        args[2] = "-classpath";
        args[3] = System.getProperty("java.class.path");
        int i = 0;
        while (i < javaFiles.length) {
            args[4 + i] = javaFiles[i].getAbsolutePath();
            ++i;
        }
        Class<?> compilerClass = Class.forName("com.sun.tools.javac.Main");
        Method compileMethod = compilerClass.getDeclaredMethod("compile", args.getClass());
        compileMethod.invoke(null, new Object[]{args});
    }

    private File generateJavaScript(MetaCustomPlausibilisierung metaCustomPlausi, File dir) throws Exception {
        File javaScriptPlausiFile = new File(dir, "plausi.js");
        FileOutputStream out = new FileOutputStream(javaScriptPlausiFile);
        try {
            CodegenFacade generator = new CodegenFacade();
            generator.generate(metaCustomPlausi, out);
        }
        finally {
            out.close();
        }
        return javaScriptPlausiFile;
    }

    private void delete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.delete(files[i]);
                ++i;
            }
        }
        file.delete();
    }

    private void clear(File dir) {
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.clear(files[i]);
            } else {
                files[i].delete();
            }
            ++i;
        }
    }
}

