/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.ui;

import de.statspez.pleditor.generator.codegen.analysis.complexity.frequency.FrequencyDefaultLoader;
import de.statspez.pleditor.generator.codegen.analysis.complexity.frequency.FrequencyImportExport;
import de.statspez.pleditor.generator.codegen.analysis.complexity.frequency.FrequencyProperties;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityChangeListener;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityEditorConstants;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityEditorInitiator;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityNode;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.DefaultComplexityEditorInitiator;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.DetailsWindow;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.DoubleCellRenderer;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.PopupMenu;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.datastructure.DatastructureComplexityPanel;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.program.ProgramComplexityPanel;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

public class ComplexityEditor
extends JPanel {
    private static final long serialVersionUID = 2405409406531500869L;
    private ComplexityEditorInitiator complexityEditorInitiator;
    private ProgramComplexityPanel programPanel;
    private DatastructureComplexityPanel datastructurePanel;
    private JTextArea complexityInfo;
    private Properties frequencyProperties = null;
    private File frequenceDirektory = null;
    private PopupMenu popupMenu;
    private JTabbedPane tabbedPane;
    private DetailsWindow window;

    public ComplexityEditor() {
        this(new DefaultComplexityEditorInitiator());
    }

    public ComplexityEditor(ComplexityEditorInitiator initiator) {
        super(new BorderLayout());
        this.complexityEditorInitiator = initiator;
        this.popupMenu = this.createPopupMenu();
        this.programPanel = new ProgramComplexityPanel();
        this.programPanel.addPopupMenu(this.popupMenu);
        this.datastructurePanel = new DatastructureComplexityPanel();
        this.datastructurePanel.addPopupMenu(this.popupMenu);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Funktionale Komplexit\u00e4t", this.programPanel);
        this.tabbedPane.addTab("Datenstrukturbezogene Komplexit\u00e4t", this.datastructurePanel);
        this.add((Component)this.tabbedPane, "Center");
        this.complexityInfo = new JTextArea();
        this.complexityInfo.setEditable(false);
        this.complexityInfo.setLineWrap(true);
        this.complexityInfo.setWrapStyleWord(true);
        this.complexityInfo.setBorder(BorderFactory.createEmptyBorder());
        this.complexityInfo.setOpaque(false);
        this.complexityInfo.setFont(this.tabbedPane.getFont());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 5));
        topPanel.add((Component)this.complexityInfo, "Center");
        this.add((Component)topPanel, "North");
        ComplexityChangeListener listener = new ComplexityChangeListener(){

            public void complexityChanged() {
                ComplexityEditor.this.complexityInfo.setText(ComplexityEditor.this.getInfoText());
            }
        };
        this.datastructurePanel.addComplexityChangeListener(listener);
        this.programPanel.addComplexityChangeListener(listener);
    }

    public void setFrequency(Properties frequencyProperties) {
        this.frequencyProperties = frequencyProperties;
    }

    public void setPlausibilisierung(MetaCustomPlausibilisierung plausi) {
        if (plausi == null) {
            throw new IllegalArgumentException("Plausibilisierung muss angegeben werden.");
        }
        boolean frequencyEditable = this.complexityEditorInitiator.isFrequencyEditable();
        this.programPanel.setPlausibilisierung(plausi, frequencyEditable);
        this.datastructurePanel.setPlausibilisierung(plausi, frequencyEditable);
        this.popupMenu.setEnabledForLoadFrequency(true);
        this.popupMenu.setEnabledForResetFrequency(true);
        this.popupMenu.setEnabledForSaveFrequency(true);
        this.doCalculateComplexity();
    }

    private Action createActionDetails() {
        AbstractAction result = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                ComplexityEditor.this.doDetails();
            }
        };
        result.putValue("ShortDescription", "PL-Spezifikation anzeigen");
        result.putValue("Name", ComplexityEditorConstants.ACTION_NAME_DETAILS);
        result.setEnabled(false);
        return result;
    }

    private Action createActionResetFrequency() {
        AbstractAction result = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                ComplexityEditor.this.doSetDefaultFrequency();
            }
        };
        result.putValue("ShortDescription", "H\u00e4ufigkeiten auf Standardwerte zur\u00fccksetzen");
        result.putValue("Name", ComplexityEditorConstants.ACTION_NAME_RESET_FREQUENCY);
        result.putValue("SmallIcon", ComplexityEditorConstants.ACTION_ICON_RESET_FREQUENCY);
        result.setEnabled(false);
        return result;
    }

    private Action createActionSaveFrequency() {
        AbstractAction result = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                ComplexityEditor.this.doSaveFrequency();
            }
        };
        result.putValue("ShortDescription", "H\u00e4ufigkeiten in eine Properties-Datei speichern");
        result.putValue("Name", ComplexityEditorConstants.ACTION_NAME_SAVE_FREQUENCY);
        result.putValue("SmallIcon", ComplexityEditorConstants.ACTION_ICON_SAVE_FREQUENCY);
        result.setEnabled(false);
        return result;
    }

    private Action createActionLoadFrequency() {
        AbstractAction result = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                ComplexityEditor.this.doLoadFrequency();
            }
        };
        result.putValue("ShortDescription", "H\u00e4ufigkeiten aus einer Properties-Datei laden");
        result.putValue("Name", ComplexityEditorConstants.ACTION_NAME_LOAD_FREQUENCY);
        result.putValue("SmallIcon", ComplexityEditorConstants.ACTION_ICON_LOAD_FREQUENCY);
        result.setEnabled(false);
        return result;
    }

    private Action createActionOpenElement() {
        AbstractAction result = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                ComplexityEditor.this.doOpenElement();
            }
        };
        result.putValue("ShortDescription", "Das Element im Editor \u00f6ffnen");
        result.putValue("Name", ComplexityEditorConstants.ACTION_NAME_OPEN_ELEMENT);
        result.setEnabled(false);
        return result;
    }

    private Action createActionExpand() {
        AbstractAction result = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent arg0) {
                ComplexityEditor.this.doExpand();
            }
        };
        result.putValue("Name", ComplexityEditorConstants.ACTION_NAME_EXPAND);
        result.setEnabled(false);
        return result;
    }

    private void doSaveFrequency() {
        block16: {
            MetaCustomPlausibilisierung plausi = this.getPlausi();
            if (plausi != null) {
                if (this.frequencyProperties != null) {
                    FrequencyImportExport frLoader = new FrequencyImportExport();
                    frLoader.importFrequencyFromProperties(plausi, this.frequencyProperties);
                } else {
                    File selectedFile = this.chooseFrequencyFile(true);
                    if (selectedFile != null) {
                        FileOutputStream out = null;
                        try {
                            try {
                                FrequencyProperties properties = new FrequencyProperties();
                                FrequencyImportExport frLoader = new FrequencyImportExport();
                                frLoader.exportFrequencyInProperties(plausi, properties);
                                out = new FileOutputStream(selectedFile);
                                properties.store(out, "");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                if (out == null) break block16;
                                try {
                                    out.close();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                            }
                        }
                        finally {
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void doLoadFrequency() {
        MetaCustomPlausibilisierung plausi;
        Properties properties;
        block16: {
            properties = null;
            File frequencyFile = this.chooseFrequencyFile(false);
            if (frequencyFile != null) {
                FileInputStream in = null;
                try {
                    try {
                        in = new FileInputStream(frequencyFile);
                        properties = new Properties();
                        properties.load(in);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        properties = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e2) {
                                e2.printStackTrace();
                            }
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw throwable;
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if ((plausi = this.getPlausi()) != null && properties != null) {
            FrequencyImportExport frLoader = new FrequencyImportExport();
            frLoader.importFrequencyFromProperties(plausi, properties);
            this.doCalculateComplexity();
        }
    }

    private void doSetDefaultFrequency() {
        MetaCustomPlausibilisierung plausi = this.getPlausi();
        if (plausi != null) {
            FrequencyDefaultLoader frLoader = new FrequencyDefaultLoader();
            frLoader.loadDefaultFrequencyToPlausi(plausi);
            this.doCalculateComplexity();
        }
    }

    private void doDetails() {
        if (this.window == null) {
            this.window = new DetailsWindow(this);
        } else if (this.window.isVisible()) {
            this.window.setVisible(false);
        }
        ComplexityNode selectedNode = null;
        Component comp = this.tabbedPane.getSelectedComponent();
        if (comp == this.programPanel) {
            ComplexityNode programComplexityNode;
            selectedNode = this.programPanel.getSelectedComplexityNode();
            if (selectedNode != null && (programComplexityNode = ComplexityEditor.findProgramComplexityNodeFor(selectedNode)) != null) {
                selectedNode = programComplexityNode;
            }
            if (selectedNode != null) {
                Point location = this.programPanel.getDetailsLocation();
                this.window.show(location, selectedNode.getIcon(), selectedNode.getName(), selectedNode.getPLSpezification());
            }
        }
    }

    private void doCalculateComplexity() {
        this.programPanel.doCalculateComplexity();
        this.datastructurePanel.doCalculateComplexity();
    }

    private void doOpenElement() {
        MetaElement selectedMetaElement = null;
        Component comp = this.tabbedPane.getSelectedComponent();
        if (comp == this.programPanel) {
            ComplexityNode programNode;
            ComplexityNode selectedNode = this.programPanel.getSelectedComplexityNode();
            if (selectedNode != null && (programNode = ComplexityEditor.findProgramComplexityNodeFor(selectedNode)) != null) {
                selectedNode = programNode;
            }
            if (selectedNode != null) {
                selectedMetaElement = selectedNode.getElement();
            }
        } else {
            selectedMetaElement = this.datastructurePanel.getSelectedMetaElement();
        }
        if (selectedMetaElement != null) {
            this.complexityEditorInitiator.openElement(selectedMetaElement);
        }
    }

    private void doExpand() {
        Component comp = this.tabbedPane.getSelectedComponent();
        if (comp == this.programPanel) {
            this.programPanel.expand();
        } else {
            this.datastructurePanel.expand();
        }
    }

    private void doExpandAll() {
        Component comp = this.tabbedPane.getSelectedComponent();
        if (comp == this.programPanel) {
            this.programPanel.expandAll(true);
        } else {
            this.datastructurePanel.expandAll(true);
        }
    }

    private MetaCustomPlausibilisierung getPlausi() {
        MetaCustomPlausibilisierung plausi = null;
        if (this.programPanel != null) {
            plausi = this.programPanel.getPlausi();
        }
        return plausi;
    }

    private File chooseFrequencyFile(boolean save) {
        File result = null;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setCurrentDirectory(this.frequenceDirektory);
        fileChooser.setFileFilter(new FileFilter(){

            public String getDescription() {
                return "Properties Datei";
            }

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".properties") || f.isDirectory();
            }
        });
        fileChooser.setDialogTitle(save ? "Frequenzen in eine Properties-Datei speichern" : "Frequenzen aus einer Properties-Datei laden");
        int userOption = save ? fileChooser.showSaveDialog(this) : fileChooser.showOpenDialog(this);
        if (userOption == 0) {
            result = fileChooser.getSelectedFile();
            this.frequenceDirektory = result.getParentFile();
        }
        return result;
    }

    private String getInfoText() {
        StringBuffer text = new StringBuffer();
        MetaCustomPlausibilisierung plausi = this.getPlausi();
        if (plausi != null) {
            MetaCustomThemenbereich rootTB = (MetaCustomThemenbereich)plausi.rootThemenbereich();
            text.append("Funktionale Komplexit\u00e4t (Summe): ");
            double summe = 0.0;
            int i = 0;
            while (i < rootTB.sizeOfAblaeufe()) {
                MetaPLAblauf ablauf = rootTB.getFromAblaeufe(i);
                if (ablauf.getFunctionalComplexity() != null) {
                    summe += ablauf.getFunctionalComplexity().doubleValue();
                }
                ++i;
            }
            text.append(DoubleCellRenderer.format.format(new Double(summe)));
            text.append(". Datenstrukturbezogene Komplexit\u00e4t: ");
            Double dsComplexity = ((MetaCustomThemenbereich)plausi.rootThemenbereich()).getDatastructureComplexity();
            if (dsComplexity != null) {
                text.append(DoubleCellRenderer.format.format(dsComplexity));
            }
        }
        return text.toString();
    }

    private PopupMenu createPopupMenu() {
        PopupMenu popupMenu = new PopupMenu(this.complexityEditorInitiator);
        if (this.complexityEditorInitiator.isFrequencyLoadable()) {
            popupMenu.setActionLoadFrequency(this.createActionLoadFrequency());
            popupMenu.setActionSaveFrequency(this.createActionSaveFrequency());
        }
        if (this.complexityEditorInitiator.isFrequencyEditable() || this.complexityEditorInitiator.isFrequencyLoadable()) {
            popupMenu.setActionResetFrequency(this.createActionResetFrequency());
        }
        popupMenu.setActionExpand(this.createActionExpand());
        if (this.complexityEditorInitiator.isOpenElementSupported()) {
            popupMenu.setActionOpenElement(this.createActionOpenElement());
        }
        popupMenu.setActionDetails(this.createActionDetails());
        return popupMenu;
    }

    public static ComplexityNode findProgramComplexityNodeFor(ComplexityNode node) {
        Object programComplexityNode = node == null ? null : (node.getPLSpezification() != null ? node : (node.getElement() == null ? null : ComplexityEditor.findProgramComplexityNodeFor(node.getParent())));
        return programComplexityNode;
    }
}

