/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.AblaufListBuilder;
import de.statspez.pleditor.generator.codegen.doku.BaseStat;
import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class AblaufStat
extends BaseStat {
    private String generatedAblauf = "";
    private HashSet besuchteAblaeufe = null;
    private ArrayList merkmale = new ArrayList();
    private ArrayList feldAblauf = new ArrayList();
    private ArrayList pruefAblauf = new ArrayList();
    private ArrayList testAblauf = new ArrayList();
    private ArrayList funcAblauf = new ArrayList();
    private ArrayList feldPruefAblauf = new ArrayList();
    private Hashtable aufgerufeneAblaeufe = null;
    private HashSet referencedChecks = new HashSet();
    private HashSet referencedFields = new HashSet();

    public void add(MetaCustomAblauf ablauf) {
        String ablaufName = String.valueOf(ablauf.getThemenbereich().getName()) + "." + ablauf.getName();
        String id = ablauf.getId();
        if (!this.idElementTable.containsKey(id)) {
            DokuElement de = new DokuElement(id, ablaufName);
            de.setTbId(ablauf.getThemenbereich().getId());
            de.setElement(ablauf);
            this.idElementTable.put(id, de);
            this.addReferences(ablauf);
            if (!ablauf.istKompilierbar()) {
                this.fehlerHafteElemente.add(de);
                de.setZusatz("fehlerhaft");
            }
        }
    }

    private void addReferences(MetaCustomAblauf ablauf) {
        DokuElement de;
        AblaufListBuilder alBuilder = new AblaufListBuilder();
        alBuilder.generateAblaufLists(ablauf);
        Iterator it = alBuilder.getPruefElementList().iterator();
        while (it.hasNext()) {
            de = (DokuElement)it.next();
            this.referencedChecks.add(de.getId());
        }
        it = alBuilder.getFeldElementList().iterator();
        while (it.hasNext()) {
            de = (DokuElement)it.next();
            this.referencedFields.add(de.getId());
        }
    }

    public void generateAblaufLists(String ablaufId) {
        this.generateAblaufLists(ablaufId, false);
    }

    public void generateAblaufLists(String ablaufId, boolean initial) {
        AblaufListBuilder alb = new AblaufListBuilder();
        DokuElement de = (DokuElement)this.idElementTable.get(ablaufId);
        alb.generateAblaufLists((MetaCustomAblauf)de.getElement());
        this.pruefAblauf = alb.getPruefElementList();
        this.feldAblauf = alb.getFeldElementList();
        this.testAblauf = alb.getTestElementList();
        this.funcAblauf = alb.getFuncElementList();
        this.feldPruefAblauf = alb.getFeldPruefElementList();
        this.merkmale.addAll(alb.getMerkamlElementHash().values());
        if (initial) {
            this.besuchteAblaeufe = alb.getAblaufElements();
            this.aufgerufeneAblaeufe = alb.getAufgerufeneAblaeufe();
        }
    }

    public ArrayList getFeldAblauf(String ablaufId) {
        if (ablaufId == null || ablaufId.trim().length() == 0) {
            return null;
        }
        if (!ablaufId.equals(this.generatedAblauf)) {
            this.generateAblaufLists(ablaufId);
            this.generatedAblauf = ablaufId;
        }
        return (ArrayList)this.feldAblauf.clone();
    }

    public ArrayList getMerkmaleAusAblauf(String ablaufId) {
        if (ablaufId == null || ablaufId.trim().length() == 0) {
            return null;
        }
        if (!ablaufId.equals(this.generatedAblauf)) {
            this.merkmale = new ArrayList();
            this.generateAblaufLists(ablaufId);
            this.generatedAblauf = ablaufId;
        }
        ArrayList list = new ArrayList(this.merkmale);
        Collections.sort(list);
        return list;
    }

    public ArrayList getPruefAblauf(String ablaufId) {
        if (ablaufId == null || ablaufId.trim().length() == 0) {
            return null;
        }
        if (!ablaufId.equals(this.generatedAblauf)) {
            this.generateAblaufLists(ablaufId);
            this.generatedAblauf = ablaufId;
        }
        return (ArrayList)this.pruefAblauf.clone();
    }

    public ArrayList getFeldPruefAblauf(String ablaufId) {
        if (ablaufId == null || ablaufId.trim().length() == 0) {
            return null;
        }
        if (!ablaufId.equals(this.generatedAblauf)) {
            this.generateAblaufLists(ablaufId);
            this.generatedAblauf = ablaufId;
        }
        return (ArrayList)this.feldPruefAblauf.clone();
    }

    public ArrayList getTestAblauf(String ablaufId) {
        if (ablaufId == null || ablaufId.trim().length() == 0) {
            return null;
        }
        if (!ablaufId.equals(this.generatedAblauf)) {
            this.generateAblaufLists(ablaufId);
            this.generatedAblauf = ablaufId;
        }
        return (ArrayList)this.testAblauf.clone();
    }

    public ArrayList getFuncAblauf(String ablaufId) {
        if (ablaufId == null || ablaufId.trim().length() == 0) {
            return null;
        }
        if (!ablaufId.equals(this.generatedAblauf)) {
            this.generateAblaufLists(ablaufId);
            this.generatedAblauf = ablaufId;
        }
        return (ArrayList)this.funcAblauf.clone();
    }

    public ArrayList getAufgerufeneAblaeufe(String ablaufId) {
        return (ArrayList)this.aufgerufeneAblaeufe.get(ablaufId);
    }

    public HashSet getBesuchteAblaeufe() {
        return (HashSet)this.besuchteAblaeufe.clone();
    }

    public HashSet getReferencedChecks() {
        return this.referencedChecks;
    }

    public HashSet getReferencedFields() {
        return this.referencedFields;
    }
}

