/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.Array;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeIterator;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.Variable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator
implements PlausiRuntimeIterator {
    private Object nextElement;
    private Object currentElement;
    private PlausiRuntimeContext context;
    private boolean hasNext = true;
    private Array myArray = null;
    private int[] nextIndices;
    private IndexDeterminationStrategy[] strategies;
    private PlausiRuntimeIterator[] dimensionIterators = new PlausiRuntimeIterator[0];
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.generator.runtime.ArrayIterator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ArrayIterator(Array anArray, PlausiRuntimeContext context) {
        this.myArray = anArray;
        this.context = context;
        this.nextElement = null;
        this.currentElement = null;
        this.nextIndices = null;
        this.strategies = null;
    }

    public Object next() throws NoSuchElementException {
        return this.nextVariable().get(this.context);
    }

    public Variable nextVariable() throws NoSuchElementException {
        if (this.nextIndices == null) {
            this.initIteration();
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentElement = this.nextElement;
        this.getNext();
        if (!(this.currentElement instanceof Variable)) {
            throw new RuntimeException("Das n\u00e4chste Element ist keine Variable.");
        }
        return (Variable)this.currentElement;
    }

    public Variable lastVariable() throws NoSuchElementException {
        if (this.currentElement == null) {
            throw new IllegalStateException("Der Iterator wurde noch nicht benutzt.");
        }
        if (!$assertionsDisabled && !(this.currentElement instanceof Variable)) {
            throw new AssertionError();
        }
        return (Variable)this.currentElement;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void setRestrictions(Object iterators) {
        this.dimensionIterators = (PlausiRuntimeIterator[])iterators;
    }

    public PlausiRuntimeIterator duplicate() {
        ArrayIterator theClone = new ArrayIterator(this.myArray, this.context);
        if (this.dimensionIterators.length > 0) {
            theClone.setRestrictions(this.dimensionIterators);
        }
        return theClone;
    }

    private void getNext() {
        int lastIndex = this.nextIndices.length - 1;
        if (this.nextIndices[lastIndex] < this.myArray.getLengthOfDimension(this.context, this.subArray(this.nextIndices, lastIndex))) {
            this.nextElement = this.myArray.getElement(this.context, this.nextIndices);
            this.nextIndices[lastIndex] = this.strategies[lastIndex].nextIndex(this.nextIndices[lastIndex]);
        } else {
            int i = lastIndex;
            while (i >= 0) {
                if (this.nextIndices[i] < this.myArray.getLengthOfDimension(this.context, this.subArray(this.nextIndices, i)) - 1) {
                    this.nextIndices[i] = this.strategies[i].nextIndex(this.nextIndices[i]);
                    int j = i + 1;
                    while (j < this.nextIndices.length) {
                        this.strategies[j] = this.indexStrageyForDimension(j);
                        this.nextIndices[j] = this.strategies[j].nextIndex(-1);
                        ++j;
                    }
                    this.getNext();
                    return;
                }
                --i;
            }
            this.nextElement = null;
            this.hasNext = false;
        }
    }

    private IndexDeterminationStrategy indexStrageyForDimension(int dimension) {
        IndexDeterminationStrategy strategy = null;
        strategy = this.dimensionIterators.length > dimension ? (this.dimensionIterators[dimension] != null ? new IndexFromIteratorStrategy(this.dimensionIterators[dimension]) : new IncrementIndexStrategy()) : new IncrementIndexStrategy();
        return strategy;
    }

    private void initIteration() {
        int dimensions = 1;
        if (this.myArray.getDimension() != null) {
            dimensions = this.myArray.getDimension().length;
        }
        this.nextIndices = new int[dimensions];
        this.strategies = new IndexDeterminationStrategy[dimensions];
        int i = 0;
        while (i < dimensions) {
            this.strategies[i] = this.indexStrageyForDimension(i);
            this.nextIndices[i] = this.strategies[i].nextIndex(-1);
            ++i;
        }
        this.getNext();
    }

    private int[] subArray(int[] array, int length) {
        if (length > array.length) {
            throw new IllegalArgumentException("Die angegebene L\u00e4nge " + length + " \u00fcbersteigt die L\u00e4nge des Arrays " + array.length);
        }
        int[] arrayNew = new int[length];
        int i = 0;
        while (i < length) {
            arrayNew[i] = array[i];
            ++i;
        }
        return arrayNew;
    }

    private class IncrementIndexStrategy
    implements IndexDeterminationStrategy {
        private IncrementIndexStrategy() {
        }

        public int nextIndex(int currentIndex) {
            return currentIndex + 1;
        }
    }

    private static interface IndexDeterminationStrategy {
        public int nextIndex(int var1);
    }

    private class IndexFromIteratorStrategy
    implements IndexDeterminationStrategy {
        private Iterator it;

        public IndexFromIteratorStrategy(PlausiRuntimeIterator it) {
            this.it = it.duplicate();
        }

        public int nextIndex(int currentIndex) {
            if (this.it.hasNext()) {
                double nextValue = ((Value)this.it.next()).asDouble();
                int nextIndex = (int)nextValue;
                if ((double)nextIndex - nextValue != 0.0) {
                    throw new IllegalArgumentException("Kein ganzzahliger Index.");
                }
                return nextIndex - 1;
            }
            return Integer.MAX_VALUE;
        }
    }
}

