/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.support;

import de.statspez.pleditor.generator.codegen.pl.HierarchicalCodeConverter;
import de.statspez.pleditor.generator.codegen.support.TextResource;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaForEachIndexOperator;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaProgramParameter;
import de.statspez.pleditor.generator.meta.MetaRangeSeries;
import de.statspez.pleditor.generator.meta.MetaWithOperator;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.Helper;
import java.util.Iterator;
import java.util.Vector;

public class CodegenUtil {
    public static String getValueSpaceAsString(MetaCustomMerkmal merkmal) {
        StringBuffer buffer = new StringBuffer();
        if (merkmal.getKlasseWertebereich() != null) {
            int num = merkmal.getKlasseWertebereich().getAuspraegungsComps().sizeOfAuspraegungen();
            if (num > 0) {
                Iterator iter = merkmal.getKlasseWertebereich().getAuspraegungsComps().getAuspraegungen();
                while (iter.hasNext()) {
                    MetaAuspraegung auspraegung = (MetaAuspraegung)iter.next();
                    buffer.append(auspraegung.getFachschluessel());
                    if (num <= 3) {
                        buffer.append(" - ");
                        buffer.append(auspraegung.getKurztext());
                    } else if (buffer.length() > 40) {
                        buffer.append(" ...");
                        break;
                    }
                    if (!iter.hasNext()) continue;
                    buffer.append(", ");
                }
            }
        } else if (merkmal.getWertebereich() != null && merkmal.getWertebereich().length() > 0) {
            String wertebereich = "";
            int i = 0;
            while (i < merkmal.getWertebereich().length()) {
                if (merkmal.getWertebereich().startsWith("--", i)) {
                    if (!wertebereich.endsWith(" ")) {
                        wertebereich = String.valueOf(wertebereich) + " ";
                    }
                    wertebereich = String.valueOf(wertebereich) + "< x < ";
                    ++i;
                } else if (merkmal.getWertebereich().startsWith("++", i)) {
                    if (!wertebereich.endsWith(" ")) {
                        wertebereich = String.valueOf(wertebereich) + " ";
                    }
                    wertebereich = String.valueOf(wertebereich) + "<= x <= ";
                    ++i;
                } else if (merkmal.getWertebereich().startsWith("+-", i)) {
                    if (!wertebereich.endsWith(" ")) {
                        wertebereich = String.valueOf(wertebereich) + " ";
                    }
                    wertebereich = String.valueOf(wertebereich) + "<= x < ";
                    ++i;
                } else if (merkmal.getWertebereich().startsWith("-+", i)) {
                    if (!wertebereich.endsWith(" ")) {
                        wertebereich = String.valueOf(wertebereich) + " ";
                    }
                    wertebereich = String.valueOf(wertebereich) + "< x <= ";
                    ++i;
                } else {
                    char charAtI = merkmal.getWertebereich().charAt(i);
                    if (charAtI == ' ') {
                        if (!wertebereich.endsWith(" ")) {
                            wertebereich = String.valueOf(wertebereich) + " ";
                        }
                    } else {
                        wertebereich = String.valueOf(wertebereich) + charAtI;
                    }
                }
                ++i;
            }
            if (wertebereich.length() > 40) {
                String[] bereiche = wertebereich.split(",");
                int i2 = 0;
                while (i2 < bereiche.length) {
                    if (i2 > 0) {
                        buffer.append(", ");
                    }
                    if (buffer.length() >= 40) {
                        buffer.append("...");
                        break;
                    }
                    buffer.append(bereiche[i2].trim());
                    ++i2;
                }
            } else {
                buffer.append(wertebereich);
            }
        }
        String valueSpace = buffer.length() > 0 ? buffer.toString() : null;
        return valueSpace;
    }

    public static String getDisplayName(TextResource textResource, MetaCustomMerkmal merkmal) {
        String displayName = textResource.getBezeichnung(merkmal);
        if (displayName == null || displayName.length() == 0) {
            displayName = merkmal.getName();
        }
        return displayName;
    }

    public static String getDisplayName(TextResource textResource, MetaCustomTBFeld feld) {
        String displayName = textResource.getBezeichnung(feld);
        if (displayName == null || displayName.length() == 0) {
            if (feld.getKlasse() instanceof MetaCustomMerkmal) {
                displayName = textResource.getBezeichnung((MetaCustomMerkmal)feld.getKlasse());
                if (displayName == null || displayName.length() == 0) {
                    displayName = feld.getName();
                }
            } else {
                displayName = feld.getName();
            }
        }
        return displayName;
    }

    public static MetaPLMaterial[] getUsedMaterials(MetaPlausibilisierung plausi) {
        final Vector usedMaterials = new Vector();
        Traverser traverser = new Traverser(){

            public void visitThemenbereich(MetaThemenbereich aTb) {
                this.visitElements(aTb.getMaterialreferenzen());
                super.visitThemenbereich(aTb);
            }

            public void visitTBMaterialReferenz(MetaTBMaterialReferenz anObject) {
                if (!usedMaterials.contains(anObject.getMaterialbeschreibung())) {
                    usedMaterials.add(anObject.getMaterialbeschreibung());
                }
            }
        };
        plausi.accept(traverser);
        return usedMaterials.toArray(new MetaPLMaterial[0]);
    }

    public static boolean referencedByUsedMaterial(MetaPlausibilisierung plausi, final MetaThemenbereich tb) {
        MetaPLMaterial[] usedMaterials;
        boolean referencedByMaterial = false;
        if ((((MetaCustomThemenbereich)tb).describesMaterial() || ((MetaCustomThemenbereich)tb).referencedByMaterial()) && (usedMaterials = CodegenUtil.getUsedMaterials(plausi)) != null && usedMaterials.length > 0) {
            int i = 0;
            while (i < usedMaterials.length) {
                if (usedMaterials[i].getThemenbereich() == tb) {
                    referencedByMaterial = true;
                    break;
                }
                Traverser traverser = new Traverser(){

                    public void visitThemenbereich(MetaThemenbereich aTb) {
                        if (aTb == tb) {
                            throw new RuntimeException();
                        }
                        super.visitThemenbereich(aTb);
                    }
                };
                try {
                    plausi.accept(traverser);
                }
                catch (RuntimeException e) {
                    referencedByMaterial = true;
                    break;
                }
                ++i;
            }
        }
        return referencedByMaterial;
    }

    public static String getEscapedStringLiteral(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer escapedValue = new StringBuffer();
        char[] chars = value.toCharArray();
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '\'': {
                    escapedValue.append("\\");
                }
            }
            escapedValue.append(chars[i]);
            ++i;
        }
        return escapedValue.toString();
    }

    public static boolean containsHierarchicalCode(MetaFactor operand) {
        Traverser traverser = new Traverser(){

            public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
                Iterator iter = anArrayAccess.indices();
                while (iter != null && iter.hasNext()) {
                    MetaFactor index = (MetaFactor)iter.next();
                    if (!(index.adaptedObject() instanceof MetaForEachIndexOperator) && !(index.adaptedObject() instanceof MetaWithOperator) && !(index.adaptedObject() instanceof MetaRangeSeries)) continue;
                    throw new RuntimeException();
                }
            }
        };
        boolean hierarchicalCodeFound = false;
        try {
            operand.accept(traverser);
        }
        catch (RuntimeException e) {
            hierarchicalCodeFound = true;
        }
        return hierarchicalCodeFound;
    }

    public static MetaProgram convertProgramWithHierarchicalCode(MetaProgram program) {
        MetaProgram programWithoutHierarchicalCode;
        if (program.containsHierarchicalFunction()) {
            HierarchicalCodeConverter converter = new HierarchicalCodeConverter();
            programWithoutHierarchicalCode = Helper.metaStructureFor(converter.generate(program));
            programWithoutHierarchicalCode.setName(program.name());
            programWithoutHierarchicalCode.setContextInfos(program.contextInfos());
            programWithoutHierarchicalCode.setCanHaveSelfAccess(program.isCanHaveSelfAccess());
            programWithoutHierarchicalCode.setHasToReturnValue(program.isHasToReturnValue());
            programWithoutHierarchicalCode.setPlausiStatementsAllowed(program.isPlausiStatementsAllowed());
            Iterator params = program.parameters();
            while (params.hasNext()) {
                programWithoutHierarchicalCode.addParameter((MetaProgramParameter)params.next());
            }
        } else {
            programWithoutHierarchicalCode = program;
        }
        return programWithoutHierarchicalCode;
    }
}

