/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.interpreter;

import de.statspez.pleditor.generator.interpreter.ClassificationFactory;
import de.statspez.pleditor.generator.runtime.Classification;
import de.statspez.pleditor.generator.runtime.ClassificationGroup;
import de.statspez.pleditor.generator.runtime.Value;
import java.util.HashMap;
import java.util.Iterator;

public class DefaultClassificationFactory
implements ClassificationFactory {
    private HashMap classificationsByCode = new HashMap();
    private HashMap classificationsByValue = new HashMap();

    public void registerClassificationGroup(String name, ClassificationGroup classificationGroup) {
        String reference = "#" + name;
        this.classificationsByCode.put(reference, classificationGroup);
        this.classificationsByValue.put(reference, classificationGroup);
        this.registerClassificationsRecursive(reference, reference, classificationGroup);
    }

    public boolean isClassificationRegistered(String reference) {
        return this.classificationsByCode.containsKey(reference) || this.classificationsByValue.containsKey(reference);
    }

    public Value getClassificationByCode(String referenceByCode) {
        if (!this.isClassificationRegistered(referenceByCode)) {
            throw new RuntimeException("Die Auspr\u00e4gungsgruppe " + referenceByCode.substring(1) + " ist nicht definiert.");
        }
        return (Value)this.classificationsByCode.get(referenceByCode);
    }

    public Classification getClassificationByValue(String referenceByValue) {
        if (!this.isClassificationRegistered(referenceByValue)) {
            throw new RuntimeException("Die Auspr\u00e4gungsgruppe " + referenceByValue.substring(1) + " ist nicht definiert.");
        }
        return (Classification)this.classificationsByValue.get(referenceByValue);
    }

    private void registerClassificationsRecursive(String referenceByCode, String referenceByValue, ClassificationGroup classificationGroup) {
        Iterator iter = classificationGroup.getClassifications();
        while (iter.hasNext()) {
            Classification classification = (Classification)iter.next();
            if (classification instanceof ClassificationGroup) {
                this.registerClassificationsRecursive(String.valueOf(referenceByCode) + "." + classification.code(), String.valueOf(referenceByCode) + ".'" + classification.value() + "'", (ClassificationGroup)classification);
            }
            this.classificationsByCode.put(String.valueOf(referenceByCode) + "." + classification.code(), classification);
            this.classificationsByValue.put(String.valueOf(referenceByCode) + ".'" + classification.value() + "'", classification);
        }
    }
}

