/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.parser;

import de.statspez.pleditor.generator.common.AbstractMessage;
import de.statspez.pleditor.generator.meta.MetaCustomPLMaterial;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.parser.ILParseException;
import de.statspez.pleditor.generator.parser.LegalBasisParser;
import de.statspez.pleditor.generator.parser.ParserChain;
import de.statspez.pleditor.generator.parser.PeriodicityParser;
import de.statspez.pleditor.generator.parser.ReferencePeriodParser;
import de.statspez.pleditor.generator.parser.Resolver;
import de.statspez.pleditor.generator.parser.SubParser;
import de.statspez.pleditor.generator.parser.SuperParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SurveyParser
extends SubParser
implements SuperParser {
    private MetaElement currentElement = null;
    private ParserChain parserChain = new ParserChain();
    private ReferencePeriodParser referencePeriodParser = null;
    private PeriodicityParser periodicityParser = null;
    private LegalBasisParser legalBasisParser = null;
    private boolean canEnabled = true;

    public SurveyParser(SuperParser sParser, Resolver resolver) {
        super(sParser, resolver);
        this.referencePeriodParser = new ReferencePeriodParser(this, resolver);
        this.parserChain.addParser(this.referencePeriodParser);
        this.periodicityParser = new PeriodicityParser(this, resolver);
        this.parserChain.addParser(this.periodicityParser);
        this.legalBasisParser = new LegalBasisParser(this, resolver);
        this.parserChain.addParser(this.legalBasisParser);
    }

    public boolean canHandleOpenTag(String namespaceURI, String tag) {
        if ("http://www.destatis.de/schema/datml-ssp/1.0".equalsIgnoreCase(namespaceURI) && tag.equalsIgnoreCase("survey")) {
            return this.canEnabled;
        }
        return this.isEnabled();
    }

    public boolean canHandleClosedTag(String namespaceURI, String tag) {
        return this.isEnabled();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("survey".equalsIgnoreCase(localName)) {
            this.enable();
        } else if (!this.parserChain.startElement(namespaceURI, localName, qName, atts) && !this.canHandleTag(namespaceURI, localName)) {
            throw ILParseException.unknownTagException(localName);
        }
        if (this.canHandleTag(namespaceURI, localName)) {
            this.handleAttributes(namespaceURI, localName, qName, atts);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if ("survey".equalsIgnoreCase(localName)) {
            this.canEnabled = false;
            this.disableAndNotify();
        } else if (!this.parserChain.endElement(namespaceURI, localName, qName) && !this.handleTag(namespaceURI, localName, qName)) {
            throw ILParseException.unkownClosingTagException(localName);
        }
    }

    public StringBuffer charData() {
        return this.superParser().charData();
    }

    public MetaElement object() {
        return this.currentElement;
    }

    public void notifyObjectAvailable(SubParser aParser) {
        if (this.referencePeriodParser == aParser) {
            if (this.currentElement instanceof MetaCustomPlausibilisierung) {
                ((MetaCustomPlausibilisierung)this.currentElement).setBerichtszeitraum(this.referencePeriodParser.gibReferencePeriod());
            } else if (this.currentElement instanceof MetaCustomPLMaterial) {
                ((MetaCustomPLMaterial)this.currentElement).setBZR(this.referencePeriodParser.gibReferencePeriod());
            }
        } else if (this.periodicityParser == aParser) {
            if (this.currentElement instanceof MetaCustomPlausibilisierung) {
                ((MetaCustomPlausibilisierung)this.currentElement).setPeriodizitaet(this.periodicityParser.gibPeriodicity());
            } else if (this.currentElement instanceof MetaCustomPLMaterial) {
                ((MetaCustomPLMaterial)this.currentElement).setPeriodizitaet(this.periodicityParser.gibPeriodicity());
            }
        }
    }

    public String parentElement() {
        return this.superParser().parentElement();
    }

    private void handleAttributes(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("survey".equalsIgnoreCase(localName)) {
            String str = atts.getValue("id");
            if (str != null) {
                if (this.currentElement instanceof MetaCustomPlausibilisierung) {
                    ((MetaCustomPlausibilisierung)this.currentElement).setIdentifikation(str);
                } else if (this.currentElement instanceof MetaCustomPLMaterial) {
                    ((MetaCustomPLMaterial)this.currentElement).setIdentifikation(str);
                }
            }
        } else if ("surveyID".equalsIgnoreCase(localName)) {
            String str = atts.getValue("id");
        } else if ("surveyName".equalsIgnoreCase(localName)) {
            String str = atts.getValue("id");
        } else if ("surveyVersion".equalsIgnoreCase(localName)) {
            String str = atts.getValue("id");
        } else if ("surveyDescription".equalsIgnoreCase(localName)) {
            String str = atts.getValue("id");
        } else if ("referenceArea".equalsIgnoreCase(localName)) {
            String str = atts.getValue("id");
        } else if ("referenceSubject".equalsIgnoreCase(localName)) {
            String string = atts.getValue("id");
        }
    }

    private boolean canHandleTag(String namespaceURI, String localName) {
        return "survey".equalsIgnoreCase(localName) || "surveyID".equalsIgnoreCase(localName) || "surveyName".equalsIgnoreCase(localName) || "surveyVersion".equalsIgnoreCase(localName) || "surveyDescription".equalsIgnoreCase(localName) || "referenceArea".equalsIgnoreCase(localName) || "referenceSubject".equalsIgnoreCase(localName);
    }

    public void setCurrentElement(MetaElement objekt) {
        this.currentElement = objekt;
        this.legalBasisParser.setCurrentElement(this.currentElement);
        this.periodicityParser.setCurrentElement(this.currentElement);
        this.referencePeriodParser.setCurrentElement(this.currentElement);
        this.canEnabled = true;
    }

    private boolean handleTag(String namespaceURI, String localName, String qName) {
        boolean handled = true;
        String chars = this.superParser().charData().toString().trim();
        MetaPLMaterial material = null;
        MetaCustomPlausibilisierung plausi = null;
        if (this.currentElement != null && this.currentElement instanceof MetaPLMaterial) {
            material = (MetaPLMaterial)this.currentElement;
        } else if (this.currentElement != null && this.currentElement instanceof MetaCustomPlausibilisierung) {
            plausi = (MetaCustomPlausibilisierung)this.currentElement;
        }
        if ("surveyID".equalsIgnoreCase(localName)) {
            if (material != null) {
                material.setEVASNr(chars);
            }
            if (plausi != null) {
                plausi.setEVASNr(chars);
            }
        } else if ("surveyName".equalsIgnoreCase(localName)) {
            if (material != null) {
                material.setExternerName(chars);
            }
        } else if (!("surveyVersion".equalsIgnoreCase(localName) || "surveyDescription".equalsIgnoreCase(localName) || "referenceArea".equalsIgnoreCase(localName) || "referenceSubject".equalsIgnoreCase(localName))) {
            handled = false;
        }
        return handled;
    }

    public void error(AbstractMessage errorMessage) {
        this.superParser().error(errorMessage);
    }
}

