/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.editor;

import de.statspez.pleditor.generator.codeassist.SyntaxElement;
import de.statspez.pleditor.generator.codeassist.ui.CodeAssistantWindow;
import de.statspez.pleditor.generator.codeassist.ui.ScopeProvider;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.NamespaceHelper;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import de.statspez.pleditor.generator.meta.MetaArrayAccess;
import de.statspez.pleditor.generator.meta.MetaClassificationReference;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaFactor;
import de.statspez.pleditor.generator.meta.MetaFieldAccess;
import de.statspez.pleditor.generator.meta.MetaHierarchicalForEachLoop;
import de.statspez.pleditor.generator.meta.MetaIdentifier;
import de.statspez.pleditor.generator.meta.MetaMaterialAccess;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaStructureAccess;
import de.statspez.pleditor.generator.meta.MetaTestingOperator;
import de.statspez.pleditor.generator.meta.MetaValueAccess;
import de.statspez.pleditor.generator.meta.MetaVarDeclaration;
import de.statspez.pleditor.generator.meta.MetaWithOperator;
import de.statspez.pleditor.generator.parser.Helper;
import de.statspez.pleditor.ui.editor.PLSyntaxTextArea;
import de.statspez.pleditor.ui.settings.SettingsProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;

public class CodeToolTipWindow
extends JWindow {
    private static final long serialVersionUID = 4680402010738696842L;
    private static int DELAY = 1000;
    private static int MIN_WIDTH = 200;
    private static int MIN_HEIGHT = 50;
    private static int PREF_WIDTH = 320;
    private static int MAX_WIDTH = 640;
    private static int MAX_HEIGHT = 400;
    private static Icon ICON_FUNCTION;
    private static Icon ICON_INTERNAL_FUNCTION;
    private static Icon ICON_PROPERTY;
    private static Icon ICON_FLOW;
    private static Icon ICON_CHECK;
    private static Icon ICON_TOPIC_FIELD;
    private static Icon ICON_FIELD;
    private static Icon ICON_LOCAL_VAR;
    private static Icon ICON_PARAM;
    private static Icon ICON_TOPIC_VAR;
    private static Icon ICON_INIT_PARAM;
    private static Icon ICON_MATERIAL;
    private static Icon ICON_CLASS_GROUP;
    private static Icon ICON_DSB_STRUCT_FIELD;
    private static Icon ICON_DSB_SATZART;
    private static Icon ICON_DSB_FIELD;
    private static Icon ICON_SDF_STRUCT_FIELD;
    private static Icon ICON_SDF_FIELD;
    private JTextArea codeTextArea;
    private int editorType;
    private ScopeProvider scopeProvider;
    private Timer timer;
    private MetaProgram program;
    private Point mousePosition;
    private JLabel title;
    private JTextArea description;
    private PLSyntaxTextArea code;
    private JPanel titlePanel;
    private JScrollPane scrollPane;
    private JButton editButton;
    private EditAction editAction;
    private CodeAssistantWindow codeAssistantWindow;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_FUNCTION = new ImageIcon(clazz.getResource("/de/statspez/pleditor/generator/images/funktion.gif"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_INTERNAL_FUNCTION = new ImageIcon(clazz2.getResource("/de/statspez/pleditor/generator/images/funktion_intern.gif"));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_PROPERTY = new ImageIcon(clazz3.getResource("/de/statspez/pleditor/generator/images/eigenschaft.gif"));
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_FLOW = new ImageIcon(clazz4.getResource("/de/statspez/pleditor/generator/images/ablauf.gif"));
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_CHECK = new ImageIcon(clazz5.getResource("/de/statspez/pleditor/generator/images/pruefung.gif"));
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_TOPIC_FIELD = new ImageIcon(clazz6.getResource("/de/statspez/pleditor/generator/images/subthemenbereich.gif"));
        Class<?> clazz7 = class$0;
        if (clazz7 == null) {
            try {
                clazz7 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_FIELD = new ImageIcon(clazz7.getResource("/de/statspez/pleditor/generator/images/tbfeld.gif"));
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_LOCAL_VAR = new ImageIcon(clazz8.getResource("/de/statspez/pleditor/generator/images/lokalvar.gif"));
        Class<?> clazz9 = class$0;
        if (clazz9 == null) {
            try {
                clazz9 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_PARAM = new ImageIcon(clazz9.getResource("/de/statspez/pleditor/generator/images/param.gif"));
        Class<?> clazz10 = class$0;
        if (clazz10 == null) {
            try {
                clazz10 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_TOPIC_VAR = new ImageIcon(clazz10.getResource("/de/statspez/pleditor/generator/images/plvar.gif"));
        Class<?> clazz11 = class$0;
        if (clazz11 == null) {
            try {
                clazz11 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_INIT_PARAM = new ImageIcon(clazz11.getResource("/de/statspez/pleditor/generator/images/initwert.gif"));
        Class<?> clazz12 = class$0;
        if (clazz12 == null) {
            try {
                clazz12 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_MATERIAL = new ImageIcon(clazz12.getResource("/de/statspez/pleditor/generator/images/materialref.gif"));
        Class<?> clazz13 = class$0;
        if (clazz13 == null) {
            try {
                clazz13 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_CLASS_GROUP = new ImageIcon(clazz13.getResource("/de/statspez/pleditor/generator/images/auspraegungsgruppe.gif"));
        Class<?> clazz14 = class$0;
        if (clazz14 == null) {
            try {
                clazz14 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_DSB_STRUCT_FIELD = new ImageIcon(clazz14.getResource("/de/statspez/pleditor/generator/codeassist/images/feldgruppe.gif"));
        Class<?> clazz15 = class$0;
        if (clazz15 == null) {
            try {
                clazz15 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_DSB_SATZART = new ImageIcon(clazz15.getResource("/de/statspez/pleditor/generator/codeassist/images/satzart.gif"));
        Class<?> clazz16 = class$0;
        if (clazz16 == null) {
            try {
                clazz16 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_DSB_FIELD = new ImageIcon(clazz16.getResource("/de/statspez/pleditor/generator/codeassist/images/einzelfeld.gif"));
        Class<?> clazz17 = class$0;
        if (clazz17 == null) {
            try {
                clazz17 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_SDF_STRUCT_FIELD = new ImageIcon(clazz17.getResource("/de/statspez/pleditor/generator/codeassist/images/sdfmerkmalsgruppe.gif"));
        Class<?> clazz18 = class$0;
        if (clazz18 == null) {
            try {
                clazz18 = class$0 = Class.forName("de.statspez.pleditor.ui.editor.CodeToolTipWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICON_SDF_FIELD = new ImageIcon(clazz18.getResource("/de/statspez/pleditor/generator/codeassist/images/sdfmerkmal.gif"));
    }

    public CodeToolTipWindow(JTextArea codeTextArea, int editorType, ScopeProvider scopeProvider) {
        super(SwingUtilities.getWindowAncestor(codeTextArea));
        JViewport viewport;
        WindowStateHandler windowStateHandler = new WindowStateHandler();
        this.codeTextArea = codeTextArea;
        this.editorType = editorType;
        this.scopeProvider = scopeProvider;
        this.timer = new Timer(DELAY, windowStateHandler);
        this.mousePosition = null;
        this.codeTextArea.addMouseListener(windowStateHandler);
        this.codeTextArea.addMouseMotionListener(windowStateHandler);
        this.codeTextArea.addKeyListener(windowStateHandler);
        this.codeTextArea.addFocusListener(windowStateHandler);
        this.codeTextArea.getDocument().addDocumentListener(new CodeChangeListener());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("javax.swing.JViewport");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((viewport = (JViewport)SwingUtilities.getAncestorOfClass(clazz, this.codeTextArea)) != null) {
            viewport.addChangeListener(windowStateHandler);
        }
        this.program = null;
        this.initUI();
    }

    public void disconnectFromCodeEditor() {
        this.codeTextArea = null;
    }

    private void initUI() {
        this.setFocusableWindowState(false);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        mainPanel.setBackground(SystemColor.info);
        this.titlePanel = new JPanel(new BorderLayout());
        this.titlePanel.setOpaque(false);
        this.titlePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, SystemColor.controlShadow));
        this.title = new JLabel();
        this.title.setHorizontalAlignment(2);
        this.title.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        WindowMover mover = new WindowMover();
        this.title.addMouseListener(mover);
        this.title.addMouseMotionListener(mover);
        this.titlePanel.add((Component)this.title, "Center");
        JToolBar titleToolBar = new JToolBar();
        titleToolBar.setFloatable(false);
        titleToolBar.setOpaque(false);
        titleToolBar.setRollover(true);
        this.editAction = new EditAction();
        this.editButton = new JButton(this.editAction);
        this.editButton.setOpaque(false);
        this.editButton.setMargin(new Insets(0, 0, 0, 0));
        titleToolBar.add(this.editButton);
        JButton closeButton = new JButton(new ImageIcon(this.getClass().getResource("close.gif")));
        closeButton.setToolTipText("Schlie\u00dfen");
        closeButton.setOpaque(false);
        closeButton.setMargin(new Insets(0, 0, 0, 0));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CodeToolTipWindow.this.setVisible(false);
            }
        });
        titleToolBar.add(closeButton);
        this.titlePanel.add((Component)titleToolBar, "East");
        mainPanel.add((Component)this.titlePanel, "North");
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setOpaque(false);
        this.description = new JTextArea(){

            public void scrollRectToVisible(Rectangle rect) {
            }
        };
        this.description.setOpaque(false);
        this.description.setEditable(false);
        this.description.setFont(this.title.getFont().deriveFont(2));
        this.description.setForeground(SystemColor.controlShadow);
        this.description.setWrapStyleWord(true);
        this.description.setLineWrap(true);
        this.description.setMargin(null);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.setOpaque(false);
        descriptionPanel.add((Component)this.description, "West");
        contentPanel.add((Component)descriptionPanel, "North");
        this.code = new PLSyntaxTextArea(){

            public void scrollRectToVisible(Rectangle rect) {
            }
        };
        this.code.setOpaque(false);
        this.code.setEditable(false);
        this.code.setFont(new Font("Monospaced", 0, 11));
        this.code.setMargin(null);
        contentPanel.add((Component)this.code, "Center");
        this.scrollPane = new JScrollPane(contentPanel);
        this.scrollPane.setBorder(null);
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        this.scrollPane.getHorizontalScrollBar().setBlockIncrement(200);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.scrollPane.getVerticalScrollBar().setBlockIncrement(200);
        JPanel windowBottomPanel = new JPanel(new BorderLayout());
        windowBottomPanel.setOpaque(false);
        windowBottomPanel.add((Component)new WindowResizer(false, true), "Center");
        windowBottomPanel.add((Component)new WindowResizer(true, true), "East");
        JPanel windowPanel = new JPanel(new BorderLayout());
        windowPanel.setOpaque(false);
        windowPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 0, 0));
        windowPanel.add((Component)this.scrollPane, "Center");
        windowPanel.add((Component)new WindowResizer(true, false), "East");
        windowPanel.add((Component)windowBottomPanel, "South");
        mainPanel.add((Component)windowPanel, "Center");
        this.getContentPane().add(mainPanel);
    }

    public void connectWithAssistant(final CodeAssistantWindow codeAssistantWindow) {
        this.codeAssistantWindow = codeAssistantWindow;
        this.codeAssistantWindow.addSelectionChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (SettingsProvider.getInstance().isSymbolTooltipEnable()) {
                    SyntaxElement syntaxElement = codeAssistantWindow.getSelectedSyntaxElement();
                    if (syntaxElement != null && syntaxElement.getSymbolDescriptor() != null && (CodeToolTipWindow.this.stringIsNotEmpty(syntaxElement.getSymbolDescriptor().getDescription()) || CodeToolTipWindow.this.stringIsNotEmpty(syntaxElement.getSymbolDescriptor().getSpecification()))) {
                        Rectangle bounds = codeAssistantWindow.getBounds();
                        CodeToolTipWindow.this.show(bounds.x + bounds.width, bounds.y, PREF_WIDTH, bounds.height, syntaxElement.getSymbolDescriptor());
                    } else {
                        CodeToolTipWindow.this.close();
                    }
                }
            }
        });
        this.codeAssistantWindow.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent e) {
                CodeToolTipWindow.this.close();
            }
        });
    }

    private void show(int x, int y, Identifier identifier) {
        SymbolDescriptor symbolDescriptor = identifier.symbolDescriptor;
        Icon icon = null;
        String title = symbolDescriptor.getDisplayName();
        if (!this.stringIsNotEmpty(title)) {
            title = identifier.name;
        }
        String context = symbolDescriptor.getContext();
        String description = symbolDescriptor.getDescription();
        String code = symbolDescriptor.getSpecification();
        if (symbolDescriptor.isEigenschaft()) {
            icon = ICON_PROPERTY;
        } else if (symbolDescriptor.isFunction()) {
            StringBuffer buffer = new StringBuffer(256);
            icon = title != null && InternalFunctions.instance().isInternalFunction(title) ? ICON_INTERNAL_FUNCTION : ICON_FUNCTION;
            buffer.append(title);
            buffer.append("(");
            if (symbolDescriptor.numberOfFunctionParameters() > 0) {
                int i = 0;
                while (i < symbolDescriptor.numberOfFunctionParameters()) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(symbolDescriptor.functionParameterAt(i).getDisplayName());
                    ++i;
                }
            }
            buffer.append(")");
            title = buffer.toString();
        } else if (symbolDescriptor.isPruefung()) {
            icon = ICON_CHECK;
        } else if (symbolDescriptor.isAblauf()) {
            icon = ICON_FLOW;
        } else if (symbolDescriptor.isTbField()) {
            icon = symbolDescriptor.isDsbKontext() ? (symbolDescriptor.isDsbSatzart() ? ICON_DSB_SATZART : (symbolDescriptor.fieldReferencesTb() ? ICON_DSB_STRUCT_FIELD : ICON_DSB_FIELD)) : (symbolDescriptor.isSdfKontext() ? (symbolDescriptor.fieldReferencesTb() ? ICON_SDF_STRUCT_FIELD : ICON_SDF_FIELD) : (symbolDescriptor.fieldReferencesTb() ? ICON_TOPIC_FIELD : ICON_FIELD));
        } else if (symbolDescriptor.isParameter()) {
            icon = ICON_PARAM;
        } else if (symbolDescriptor.isHilfsvariable()) {
            icon = ICON_TOPIC_VAR;
        } else if (symbolDescriptor.isInitwert()) {
            icon = ICON_INIT_PARAM;
        } else if (symbolDescriptor.isMaterial()) {
            icon = ICON_MATERIAL;
        } else if (symbolDescriptor.isClassificationGroup()) {
            icon = ICON_CLASS_GROUP;
        } else if (symbolDescriptor.isLokaleVariable()) {
            icon = ICON_LOCAL_VAR;
        }
        this.titlePanel.setVisible(true);
        this.title.setIcon(icon);
        this.title.setText(String.valueOf(this.stringIsNotEmpty(context) ? String.valueOf(context) + "." : "") + title);
        if (this.stringIsNotEmpty(description)) {
            this.description.setText(description);
            this.description.setVisible(true);
        } else {
            this.description.setText(null);
            this.description.setVisible(false);
        }
        if (this.stringIsNotEmpty(code)) {
            this.code.setText(code);
            this.code.setVisible(true);
        } else {
            this.code.setText(null);
            this.code.setVisible(false);
        }
        this.editAction.setSymbolDescriptor(symbolDescriptor);
        this.editButton.setVisible(this.editAction.isEnabled());
        int width = Math.max(Math.min(this.titlePanel.getPreferredSize().width + 2, MAX_WIDTH), MIN_WIDTH);
        this.description.setSize(width - 8, MAX_HEIGHT);
        int height = this.titlePanel.getPreferredSize().height + (this.description.isVisible() ? this.description.getPreferredSize().height : 0) + (this.code.isVisible() ? this.code.getPreferredSize().height : 0) + this.scrollPane.getHorizontalScrollBar().getPreferredSize().height + 8;
        this.setBounds(x, y, width, Math.min(height, MAX_HEIGHT));
        this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
        this.setVisible(true);
    }

    private void show(int x, int y, int width, int height, SymbolDescriptor symbolDescriptor) {
        String description = symbolDescriptor.getDescription();
        String code = symbolDescriptor.getSpecification();
        this.titlePanel.setVisible(false);
        if (this.stringIsNotEmpty(description)) {
            this.description.setText(description);
            this.description.setVisible(true);
        } else {
            this.description.setText(null);
            this.description.setVisible(false);
        }
        if (this.stringIsNotEmpty(code)) {
            this.code.setText(code);
            this.code.setVisible(true);
        } else {
            this.code.setText(null);
            this.code.setVisible(false);
        }
        this.description.setSize(width - 8, height - 2);
        this.setBounds(x, y, width, height);
        this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
        this.setVisible(true);
    }

    public void close() {
        this.timer.stop();
        if (this.isShowing()) {
            this.setVisible(false);
        }
    }

    private boolean stringIsNotEmpty(String s) {
        return s != null && s.trim().length() > 0;
    }

    private class CodeChangeListener
    implements DocumentListener {
        private CodeChangeListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            CodeToolTipWindow.this.program = null;
        }

        public void insertUpdate(DocumentEvent e) {
            CodeToolTipWindow.this.program = null;
        }

        public void removeUpdate(DocumentEvent e) {
            CodeToolTipWindow.this.program = null;
        }
    }

    private class EditAction
    extends AbstractAction {
        private SymbolDescriptor symbolDescriptor = null;

        public EditAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("edit.gif")));
            this.putValue("ShortDescription", "Gehe zu");
            this.setEnabled(false);
        }

        public void setSymbolDescriptor(SymbolDescriptor symbolDescriptor) {
            this.symbolDescriptor = symbolDescriptor;
            this.setEnabled(symbolDescriptor != null && CodeToolTipWindow.this.scopeProvider.canOpenElement(symbolDescriptor));
        }

        public void actionPerformed(ActionEvent e) {
            CodeToolTipWindow.this.scopeProvider.openElement(this.symbolDescriptor);
        }
    }

    private class Identifier {
        public String name;
        public SymbolDescriptor symbolDescriptor;
        public int startLine;
        public int startColumn;

        private Identifier() {
        }
    }

    private class IdentifierResolver
    extends Traverser {
        private Identifier identifier;
        private int line;
        private int column;
        private NamespaceHelper namespaceHelper;
        private Map localVariables;

        private IdentifierResolver() {
        }

        public Identifier resolve() {
            this.identifier = null;
            this.namespaceHelper = new NamespaceHelper();
            this.localVariables = new HashMap();
            try {
                int position = CodeToolTipWindow.this.codeTextArea.viewToModel(CodeToolTipWindow.this.mousePosition);
                Rectangle bounds = CodeToolTipWindow.this.codeTextArea.modelToView(position);
                if (bounds.intersects(new Rectangle(((CodeToolTipWindow)CodeToolTipWindow.this).mousePosition.x - 4, ((CodeToolTipWindow)CodeToolTipWindow.this).mousePosition.y - 8, 8, 16))) {
                    Element root = CodeToolTipWindow.this.codeTextArea.getDocument().getDefaultRootElement();
                    int lineIndex = root.getElementIndex(position);
                    Element lineElement = root.getElement(lineIndex);
                    int lineStartOffset = lineElement.getStartOffset();
                    this.column = position - lineStartOffset;
                    this.line = lineIndex + 1;
                    ++this.column;
                    if (CodeToolTipWindow.this.program == null) {
                        String programText;
                        switch (CodeToolTipWindow.this.editorType) {
                            case 10: {
                                programText = "RUECKGABE\n" + CodeToolTipWindow.this.codeTextArea.getText();
                                break;
                            }
                            case 30: {
                                programText = "GIB\n" + CodeToolTipWindow.this.codeTextArea.getText() + "\nAUS";
                                break;
                            }
                            case 20: {
                                programText = "RUECKGABE 1 IN {\n" + CodeToolTipWindow.this.codeTextArea.getText() + "}";
                                break;
                            }
                            default: {
                                programText = "\n" + CodeToolTipWindow.this.codeTextArea.getText();
                            }
                        }
                        CodeToolTipWindow.this.program = Helper.metaStructureFor(programText);
                    }
                    CodeToolTipWindow.this.program.accept(this);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.identifier;
        }

        public void visitStructureAccess(MetaStructureAccess structureAccess) {
            Stack<MetaValueAccess> structureStack = new Stack<MetaValueAccess>();
            MetaStructureAccess currentStructureAccess = structureAccess;
            while (currentStructureAccess.structureAccess() instanceof MetaStructureAccess) {
                currentStructureAccess = (MetaStructureAccess)currentStructureAccess.structureAccess();
                structureStack.push(currentStructureAccess.selectedElement());
            }
            structureStack.push(currentStructureAccess.structureAccess());
            while (!structureStack.isEmpty()) {
                MetaValueAccess mfa;
                MetaValueAccess valueAccess = (MetaValueAccess)structureStack.pop();
                valueAccess.accept(this);
                if (valueAccess instanceof MetaFieldAccess) {
                    mfa = (MetaFieldAccess)valueAccess;
                    this.namespaceHelper.enterSubNamespace(((MetaFieldAccess)mfa).accessedField().value());
                    continue;
                }
                if (!(valueAccess instanceof MetaArrayAccess)) continue;
                mfa = (MetaArrayAccess)valueAccess;
                this.namespaceHelper.enterSubNamespace(((MetaArrayAccess)mfa).accessedArray().value());
            }
            structureAccess.selectedElement().accept(this);
            currentStructureAccess = structureAccess;
            while (currentStructureAccess.structureAccess() instanceof MetaStructureAccess) {
                currentStructureAccess = (MetaStructureAccess)currentStructureAccess.structureAccess();
                this.namespaceHelper.leaveSubNamespace();
            }
            this.namespaceHelper.leaveSubNamespace();
        }

        public void visitHierarchicalForEachLoop(MetaHierarchicalForEachLoop statement) {
            Stack<MetaElement> structureHelpStack = new Stack<MetaElement>();
            MetaElement anAccess = (MetaElement)((Object)statement.value().adaptedObject());
            anAccess.accept(this);
            while (anAccess instanceof MetaStructureAccess) {
                MetaStructureAccess structureAccess = (MetaStructureAccess)anAccess;
                structureHelpStack.push(structureAccess.selectedElement());
                anAccess = structureAccess.structureAccess();
            }
            structureHelpStack.push(anAccess);
            int namespaceCount = 0;
            while (!structureHelpStack.empty()) {
                MetaElement structureElement = (MetaElement)structureHelpStack.pop();
                if (structureElement instanceof MetaFieldAccess) {
                    MetaFieldAccess fa = (MetaFieldAccess)structureElement;
                    this.namespaceHelper.enterSubNamespace(fa.accessedField().value());
                    ++namespaceCount;
                    continue;
                }
                if (!(structureElement instanceof MetaArrayAccess)) continue;
                MetaArrayAccess aa = (MetaArrayAccess)structureElement;
                this.namespaceHelper.enterSubNamespace(aa.accessedArray().value());
                ++namespaceCount;
            }
            statement.loopBody().accept(this);
            int i = 0;
            while (i < namespaceCount) {
                this.namespaceHelper.leaveSubNamespace();
                ++i;
            }
        }

        public void visitArrayAccess(MetaArrayAccess anArrayAccess) {
            anArrayAccess.accessedArray().accept(this);
            int i = 0;
            while (i < anArrayAccess.numberOfIndices()) {
                MetaFactor index = anArrayAccess.indexAt(i);
                if (index.adaptedObject() instanceof MetaWithOperator) {
                    this.namespaceHelper.enterSubNamespace(anArrayAccess.accessedArray().value());
                    index.accept(this);
                    this.namespaceHelper.leaveSubNamespace();
                } else {
                    this.namespaceHelper.startNewNamespace();
                    index.accept(this);
                    this.namespaceHelper.leaveThisNamespace();
                }
                ++i;
            }
        }

        public void visitMaterialAccess(MetaMaterialAccess anAccess) {
            MetaTestingOperator condition;
            anAccess.material().accept(this);
            Iterator it = anAccess.selectionConditions();
            while (it.hasNext()) {
                condition = (MetaTestingOperator)it.next();
                condition.secondOperand().accept(this);
            }
            this.namespaceHelper.enterSubNamespace(anAccess.material().value());
            it = anAccess.selectedFields();
            while (it.hasNext()) {
                MetaValueAccess selectedField = (MetaValueAccess)it.next();
                selectedField.accept(this);
            }
            it = anAccess.selectionConditions();
            while (it.hasNext()) {
                condition = (MetaTestingOperator)it.next();
                condition.firstOperand().accept(this);
            }
            this.namespaceHelper.leaveSubNamespace();
        }

        public void visitVarDeclaration(MetaVarDeclaration declaration) {
            Iterator iter = declaration.identifiers();
            while (iter.hasNext()) {
                MetaIdentifier identifier = (MetaIdentifier)iter.next();
                GenericSymbolDescriptor symbolDescriptor = new GenericSymbolDescriptor();
                symbolDescriptor.setIsLokaleVariable(true);
                symbolDescriptor.setDisplayName(identifier.value());
                symbolDescriptor.setDescription("Lokale Variable");
                this.localVariables.put(identifier.value(), symbolDescriptor);
            }
            super.visitVarDeclaration(declaration);
        }

        public void visitClassificationReference(MetaClassificationReference reference) {
            MetaIdentifier classIdentifier = (MetaIdentifier)reference.levelAt(0);
            MetaIdentifier classRefIdentifier = new MetaIdentifier("#" + classIdentifier.value());
            classRefIdentifier.setSourceLocation(classIdentifier.startLine(), classIdentifier.startColumn() - 1, classIdentifier.endLine(), classIdentifier.endColumn());
            classRefIdentifier.accept(this);
        }

        public void visitIdentifier(MetaIdentifier anIdentifier) {
            if (anIdentifier.startLine() == this.line + 1 && anIdentifier.startColumn() <= this.column && anIdentifier.startColumn() + anIdentifier.value().length() >= this.column) {
                SymbolDescriptor symbolDescriptor = this.localVariables.containsKey(anIdentifier.value()) ? (SymbolDescriptor)this.localVariables.get(anIdentifier.value()) : CodeToolTipWindow.this.scopeProvider.getScope().symbolDescriptor(anIdentifier, this.namespaceHelper.namespace());
                this.identifier = new Identifier();
                this.identifier.name = anIdentifier.value();
                this.identifier.symbolDescriptor = symbolDescriptor;
                this.identifier.startLine = anIdentifier.startLine() - 1;
                this.identifier.startColumn = anIdentifier.value().startsWith("#") ? anIdentifier.startColumn() + 1 : anIdentifier.startColumn();
            }
        }
    }

    private class WindowMover
    implements MouseListener,
    MouseMotionListener {
        private Point start = null;

        private WindowMover() {
        }

        public void mousePressed(MouseEvent e) {
            this.start = e.getPoint();
        }

        public void mouseReleased(MouseEvent e) {
            this.start = null;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.start != null) {
                Point end = e.getPoint();
                Point location = CodeToolTipWindow.this.getLocation();
                CodeToolTipWindow.this.setLocation(location.x + (end.x - this.start.x), location.y + (end.y - this.start.y));
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class WindowResizer
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private boolean horizontal;
        private boolean vertical;
        private Point start = null;
        private int minWidth;

        public WindowResizer(boolean horizontal, boolean vertical) {
            this.horizontal = horizontal;
            this.vertical = vertical;
            if (horizontal && vertical) {
                this.setCursor(Cursor.getPredefinedCursor(6));
            } else if (horizontal) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (vertical) {
                this.setCursor(Cursor.getPredefinedCursor(9));
            }
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(horizontal ? 3 : 0, vertical ? 3 : 0));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void mousePressed(MouseEvent e) {
            this.start = e.getPoint();
            this.minWidth = CodeToolTipWindow.this.titlePanel.isVisible() ? ((CodeToolTipWindow)CodeToolTipWindow.this).titlePanel.getPreferredSize().width + 2 : MIN_WIDTH;
        }

        public void mouseReleased(MouseEvent e) {
            this.start = null;
        }

        public void mouseDragged(MouseEvent e) {
            if (this.start != null) {
                Point end = e.getPoint();
                Dimension size = CodeToolTipWindow.this.getSize();
                int width = Math.max(size.width + (this.horizontal ? end.x - this.start.x : 0), this.minWidth);
                int height = Math.max(size.height + (this.vertical ? end.y - this.start.y : 0), MIN_HEIGHT);
                CodeToolTipWindow.this.setSize(width, height);
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class WindowStateHandler
    implements ActionListener,
    MouseListener,
    MouseMotionListener,
    KeyListener,
    FocusListener,
    HierarchyListener,
    ChangeListener {
        private WindowStateHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            CodeToolTipWindow.this.codeTextArea.requestFocus();
            IdentifierResolver resolver = new IdentifierResolver();
            Identifier identifier = resolver.resolve();
            if (identifier != null) {
                try {
                    int position = CodeToolTipWindow.this.codeTextArea.getLineStartOffset(identifier.startLine - 1) + identifier.startColumn - 1;
                    Rectangle bounds = CodeToolTipWindow.this.codeTextArea.modelToView(position);
                    Point location = CodeToolTipWindow.this.codeTextArea.getLocationOnScreen();
                    CodeToolTipWindow.this.show(location.x + bounds.x, location.y + bounds.y + bounds.height, identifier);
                }
                catch (BadLocationException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                CodeToolTipWindow.this.setVisible(false);
            }
            CodeToolTipWindow.this.timer.stop();
        }

        public void mouseMoved(MouseEvent e) {
            if (SettingsProvider.getInstance().isSymbolTooltipEnable() && CodeToolTipWindow.this.codeTextArea.isEnabled() && !CodeToolTipWindow.this.codeAssistantWindow.isShowing()) {
                CodeToolTipWindow.this.mousePosition = e.getPoint();
                CodeToolTipWindow.this.timer.restart();
            }
        }

        public void mouseExited(MouseEvent e) {
            CodeToolTipWindow.this.timer.stop();
        }

        public void mouseClicked(MouseEvent e) {
            CodeToolTipWindow.this.close();
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            if (!CodeToolTipWindow.this.codeAssistantWindow.isShowing()) {
                CodeToolTipWindow.this.close();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            CodeToolTipWindow.this.close();
        }

        public void hierarchyChanged(HierarchyEvent e) {
            if (CodeToolTipWindow.this.isShowing() && !CodeToolTipWindow.this.codeTextArea.isShowing()) {
                CodeToolTipWindow.this.close();
            }
        }

        public void stateChanged(ChangeEvent e) {
            CodeToolTipWindow.this.close();
        }
    }
}

