/*
 * Decompiled with CFR 0.152.
 */
package de.werum.uvkp.plausi.logger;

import de.werum.uvkp.plausi.logger.LoggerIfc;
import de.werum.uvkp.plausi.logger.SystemLogger;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class LoggerManager {
    public static final byte LOGGER_SYSTEM = 1;
    public static final String LOGGER_SYSTEM_STR = "LOGGER_SYSTEM";
    public static final byte LOGGER_APACHE_COMMON = 10;
    public static final String LOGGER_APACHE_COMMON_STR = "LOGGER_APACHE_COMMON";
    public static final byte LOGGER_LOG4J = 30;
    public static final String LOGGER_LOG4J_STR = "LOGGER_LOG4J";
    public static final byte LOGGER_OVISE = 40;
    public static final String LOGGER_OVISE_STR = "LOGGER_OVISE";
    private byte defaultLoggerType = 1;
    private int defaultLogLevel = 20;
    private HashMap specialLoggerTypes = null;
    private HashMap specialLoggerLevels = null;
    private String[] packagesForType = null;
    private String[] packagesForLevel = null;
    private static LoggerManager instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoggerManager getInstance() {
        if (instance != null) return instance;
        Class<LoggerManager> clazz = LoggerManager.class;
        synchronized (LoggerManager.class) {
            if (instance != null) return instance;
            instance = new LoggerManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LoggerManager() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("logger");
            Enumeration<String> enumeration = resourceBundle.getKeys();
            this.specialLoggerTypes = new HashMap();
            this.specialLoggerLevels = new HashMap();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                String string2 = resourceBundle.getString(string);
                if (string.equalsIgnoreCase("DEFAULT_LOGGER")) {
                    this.setDefaultLogger(string2);
                    continue;
                }
                if (string.equalsIgnoreCase("DEFAULT_LOG_LEVEL")) {
                    this.setDefaultLogLevel(string2);
                    continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n] = stringTokenizer.nextToken();
                    ++n;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i].trim();
                    if (string3 == null) continue;
                    if (string3.equalsIgnoreCase(LOGGER_SYSTEM_STR)) {
                        this.specialLoggerTypes.put(string, new Byte(1));
                        continue;
                    }
                    if (string3.equalsIgnoreCase(LOGGER_APACHE_COMMON_STR)) {
                        this.specialLoggerTypes.put(string, new Byte(10));
                        continue;
                    }
                    if (string3.equalsIgnoreCase(LOGGER_LOG4J_STR)) {
                        this.specialLoggerTypes.put(string, new Byte(30));
                        continue;
                    }
                    if (string3.equalsIgnoreCase(LOGGER_OVISE_STR)) {
                        this.specialLoggerTypes.put(string, new Byte(40));
                        continue;
                    }
                    if (string3.equalsIgnoreCase("INFO")) {
                        this.specialLoggerLevels.put(string, new Integer(20));
                        continue;
                    }
                    if (string3.equalsIgnoreCase("DEBUG")) {
                        this.specialLoggerLevels.put(string, new Integer(30));
                        continue;
                    }
                    if (string3.equalsIgnoreCase("ERROR")) {
                        this.specialLoggerLevels.put(string, new Integer(10));
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("TEST")) continue;
                    this.specialLoggerLevels.put(string, new Integer(40));
                }
            }
            this.createLoggerPackageList();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDefaultLogLevel(String string) {
        if (string.equalsIgnoreCase("INFO")) {
            this.defaultLogLevel = 20;
        } else if (string.equalsIgnoreCase("DEBUG")) {
            this.defaultLogLevel = 30;
        } else if (string.equalsIgnoreCase("ERROR")) {
            this.defaultLogLevel = 10;
        } else if (string.equalsIgnoreCase("TEST")) {
            this.defaultLogLevel = 40;
        }
    }

    public void setDefaultLogger(String string) {
        if (string.equalsIgnoreCase(LOGGER_SYSTEM_STR)) {
            this.defaultLoggerType = 1;
        } else if (string.equalsIgnoreCase(LOGGER_APACHE_COMMON_STR)) {
            this.defaultLoggerType = (byte)10;
        } else if (string.equalsIgnoreCase(LOGGER_LOG4J_STR)) {
            this.defaultLoggerType = (byte)30;
        } else if (string.equalsIgnoreCase(LOGGER_OVISE_STR)) {
            this.defaultLoggerType = (byte)40;
        }
    }

    private void createLoggerPackageList() {
        String[] stringArray = new String[this.specialLoggerTypes.size()];
        stringArray = this.specialLoggerTypes.keySet().toArray(stringArray);
        this.packagesForType = this.sortiereArray(stringArray);
        stringArray = new String[this.specialLoggerLevels.size()];
        stringArray = this.specialLoggerLevels.keySet().toArray(stringArray);
        this.packagesForLevel = this.sortiereArray(stringArray);
    }

    private String[] sortiereArray(String[] stringArray) {
        int[] nArray = this.getStrukturTiefen(stringArray);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            int n = nArray[0];
            int n2 = 0;
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] < n) continue;
                n = nArray[j];
                n2 = j;
            }
            stringArray2[i] = stringArray[n2];
            nArray[n2] = -1;
        }
        return stringArray2;
    }

    private int[] getStrukturTiefen(String[] stringArray) {
        int[] nArray = new int[this.specialLoggerTypes.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            nArray[i] = n = this.getPaketStrukturTiefe(stringArray[i]);
        }
        return nArray;
    }

    private int getPaketStrukturTiefe(String string) {
        int n = 0;
        int n2 = 1;
        while (n > -1) {
            n = string.indexOf(46, n + 1);
            ++n2;
        }
        return n2;
    }

    public void setLoggerType(byte by) {
        this.defaultLoggerType = by;
    }

    public byte getLoggerType(String string) {
        byte by = this.defaultLoggerType;
        if (this.packagesForType != null && string != null) {
            for (int i = 0; i < this.packagesForType.length; ++i) {
                Byte by2;
                if (!string.startsWith(this.packagesForType[i]) || (by2 = (Byte)this.specialLoggerTypes.get(this.packagesForType[i])) == null) continue;
                by = by2;
                break;
            }
        }
        return by;
    }

    public int getLogLevel(String string) {
        int n = this.defaultLogLevel;
        if (this.packagesForLevel != null && string != null && string.length() > 0) {
            for (int i = 0; i < this.packagesForLevel.length; ++i) {
                Integer n2;
                if (!string.startsWith(this.packagesForLevel[i]) || (n2 = (Integer)this.specialLoggerLevels.get(this.packagesForLevel[i])) == null) continue;
                n = n2;
                break;
            }
        }
        return n;
    }

    public int getLogLevel() {
        return this.defaultLogLevel;
    }

    public LoggerIfc getLogger(Class clazz) {
        String string = clazz.getName();
        byte by = this.getLoggerType(string);
        int n = this.getLogLevel(string);
        LoggerIfc loggerIfc = null;
        loggerIfc = this.getStandardLogger(string.substring(string.lastIndexOf(46) + 1), n);
        return loggerIfc;
    }

    private LoggerIfc getStandardLogger(String string, int n) {
        SystemLogger systemLogger = null;
        systemLogger = new SystemLogger(string, n);
        return systemLogger;
    }

    public LoggerIfc getLogger() {
        return this.getStandardLogger("-", this.defaultLogLevel);
    }

    public void setLogLevel(int n) {
        this.defaultLogLevel = n;
    }

    public void setLogLevelInfo() {
        this.defaultLogLevel = 20;
    }

    public void setLogLevelDebug() {
        this.defaultLogLevel = 30;
    }

    public void setLogLevelError() {
        this.defaultLogLevel = 10;
    }

    public void setLogLevelTest() {
        this.defaultLogLevel = 40;
    }
}

