/*
 * Decompiled with CFR 0.152.
 */
package de.werum.uvkp.plausi.logger;

import de.werum.uvkp.plausi.logger.GeneralLogger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SystemLogger
extends GeneralLogger {
    private String className = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss", Locale.GERMANY);

    public SystemLogger(String string, int n) {
        super(n);
        this.className = string;
    }

    @Override
    public void debug(String string) {
        if (!this.noDebug) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.dateFormat.format(new Date()));
            stringBuffer.append(" DEBUG ");
            stringBuffer.append('[');
            stringBuffer.append(this.className);
            stringBuffer.append(']').append(' ');
            stringBuffer.append(string);
            System.out.println(stringBuffer.toString());
        }
    }

    @Override
    public void info(String string) {
        if (!this.noInfo) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.dateFormat.format(new Date()));
            stringBuffer.append(" INFO ");
            stringBuffer.append('[');
            stringBuffer.append(this.className);
            stringBuffer.append(']').append(' ');
            stringBuffer.append(string);
            System.out.println(stringBuffer.toString());
        }
    }

    @Override
    public void test(String string) {
        if (!this.noTest) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.dateFormat.format(new Date()));
            stringBuffer.append(" TEST ");
            stringBuffer.append('[');
            stringBuffer.append(this.className);
            stringBuffer.append(']').append(' ');
            stringBuffer.append(string);
            System.out.println(stringBuffer.toString());
        }
    }

    @Override
    public void error(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dateFormat.format(new Date()));
        stringBuffer.append(" ERROR ");
        stringBuffer.append('[');
        stringBuffer.append(this.className);
        stringBuffer.append(']').append(' ');
        stringBuffer.append(string);
        System.err.println(stringBuffer.toString());
    }

    @Override
    public void error(String string, Throwable throwable) {
        this.error(string + this.throwableToString(throwable));
    }
}

