/*
 * Decompiled with CFR 0.152.
 */
package de.werum.uvkp.plausi.record;

import de.werum.uvkp.plausi.record.RecordDefinition;
import de.werum.uvkp.plausi.record.RecordDefinitionNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class RecordDefinitionFactory {
    private static final String RECORD_DEFINITIONS_CLASS_NAME_PATTERN = "de.werum.uvkp.plausi.record.generated.RecordDefinition_%s";
    private static final Map<String, RecordDefinition> cache = new HashMap<String, RecordDefinition>();

    private RecordDefinitionFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecordDefinition getRecordDefinition(String string) throws RecordDefinitionNotFoundException {
        RecordDefinition recordDefinition = cache.get(string);
        if (recordDefinition == null) {
            Map<String, RecordDefinition> map = cache;
            synchronized (map) {
                recordDefinition = cache.get(string);
                if (recordDefinition == null) {
                    try {
                        Class<?> clazz = Class.forName(String.format(RECORD_DEFINITIONS_CLASS_NAME_PATTERN, string));
                        recordDefinition = (RecordDefinition)clazz.newInstance();
                        cache.put(string, recordDefinition);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new RecordDefinitionNotFoundException(classNotFoundException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RecordDefinitionNotFoundException(illegalAccessException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new RecordDefinitionNotFoundException(instantiationException);
                    }
                }
            }
        }
        return recordDefinition;
    }
}

