/*
 * Decompiled with CFR 0.152.
 */
package de.werum.uvkp.plausi.runtime;

import de.statspez.pleditor.generator.masken.AbstractMaske;
import de.statspez.pleditor.generator.masken.DatumMaskenParser;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFactory;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.werum.uvkp.plausi.PlausiResult;
import de.werum.uvkp.plausi.record.RecordDefinition;
import de.werum.uvkp.plausi.record.RecordDefinitionFactory;
import de.werum.uvkp.plausi.record.RecordDefinitionNotFoundException;
import de.werum.uvkp.plausi.record.init.AsciiRecordInitializer;
import de.werum.uvkp.plausi.record.init.DataRecord;
import de.werum.uvkp.plausi.record.init.DataSetWrapper;
import de.werum.uvkp.plausi.runtime.DataFormatException;
import de.werum.uvkp.plausi.runtime.DefaultPlausiError;
import de.werum.uvkp.plausi.runtime.DefaultPlausiResult;

public class PlausiPerformer {
    public static final String DEFAULT_ENCODING = new String("ISO-8859-1");
    private static final String DEFAULT_MELDEJAHR_SCHALTTAG = new String("1031");
    private String ipMeldejahrSchalttag = null;

    public PlausiPerformer(String string) {
        this.ipMeldejahrSchalttag = string;
    }

    protected DataSetWrapper initDataSet(String string, String string2) throws DataFormatException {
        String string3;
        DataSetWrapper dataSetWrapper = null;
        if (string != null) {
            if (string2 == null || !string2.startsWith(string)) {
                throw new DataFormatException(string, "", string, 35, null, "Zul\u00e4ssig ist nur der Wert \"" + string + "\".");
            }
            string3 = string;
        } else {
            if (string2 == null || string2.length() < 4) {
                throw new DataFormatException("LEER", "", "LEER", 20, null, "Der Datensatz ist zu kurz. Es kann keine Satzkennung ermittelt werden.");
            }
            string3 = string2.substring(0, 4);
        }
        String string4 = "";
        if ("DSLN".equals(string3) || "DSAS".equals(string3)) {
            if (string2.length() < 41) {
                throw new DataFormatException(string3, string4, string3, 20, null, "Der Datensatz ist zu kurz. Es kann keine Version ermittelt werden.");
            }
            string4 = string2.substring(39, 41);
            try {
                Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException(string3, string4, string3, 45, null, "Die Version ist nicht numerisch.");
            }
            if ("DSLN".equals(string3)) {
                if (!"01".equals(string4) && !"02".equals(string4)) {
                    throw new DataFormatException(string3, string4, string3, 50, null, "Die Version ist unbekannt.");
                }
                this.check_MMDBAP(string2, 479, string3, string4);
            } else if ("DSAS".equals(string3)) {
                if (!"01".equals(string4) && !"02".equals(string4)) {
                    throw new DataFormatException(string3, string4, string3, 50, null, "Die Version ist unbekannt.");
                }
                this.check_MMDBAP(string2, 459, string3, string4);
            }
        } else if ("DSKO".equals(string3)) {
            if (string2.length() < 41) {
                throw new DataFormatException(string3, string4, string3, 20, null, "Der Datensatz ist zu kurz. Es kann keine Version ermittelt werden.");
            }
            string4 = string2.substring(39, 41);
            try {
                Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataFormatException(string3, string4, string3, 45, null, "Die Version ist nicht numerisch.");
            }
            if (!"04".equals(string4)) {
                throw new DataFormatException(string3, string4, string3, 50, null, "Die Version ist unbekannt.");
            }
        } else {
            throw new DataFormatException(string3, string4, string3, 40, null, "Der Datensatz mit dem Kennzeichen " + string3 + " ist unbekannt.");
        }
        String string5 = string3 + "_" + string4;
        try {
            RecordDefinition recordDefinition = RecordDefinitionFactory.getRecordDefinition(string5);
            AsciiRecordInitializer asciiRecordInitializer = new AsciiRecordInitializer(string3, string4, string5);
            DataRecord dataRecord = asciiRecordInitializer.initializeDataRecord(string2, recordDefinition);
            dataSetWrapper = new DataSetWrapper(dataRecord);
            dataSetWrapper.setSatzkennzeichen(string3);
            dataSetWrapper.setVersion(string4);
            dataSetWrapper.setPlausiType(string5);
        }
        catch (RecordDefinitionNotFoundException recordDefinitionNotFoundException) {
            throw new DataFormatException(string3, string4, string5, 40, null, "Der Datensatz mit dem Kennzeichen und Version " + string5 + " ist unbekannt.", recordDefinitionNotFoundException);
        }
        return dataSetWrapper;
    }

    public PlausiResult doPlausi(String string, String string2) {
        PlausiResult plausiResult = null;
        DataSetWrapper dataSetWrapper = null;
        try {
            dataSetWrapper = this.initDataSet(string, string2);
            plausiResult = this.doPlausi(dataSetWrapper);
        }
        catch (DataFormatException dataFormatException) {
            plausiResult = new DefaultPlausiResult(dataFormatException.getSatzkennzeichen(), dataFormatException.getVersion(), dataFormatException.getSatzart());
            this.handleDataFormatException((DefaultPlausiResult)plausiResult, dataFormatException);
        }
        return plausiResult;
    }

    protected PlausiResult doPlausi(DataSetWrapper dataSetWrapper) {
        DefaultPlausiResult defaultPlausiResult = new DefaultPlausiResult(dataSetWrapper.getSatzkennzeichen(), dataSetWrapper.getVersion(), dataSetWrapper.getPlausiType());
        String string = dataSetWrapper.getPlausiType();
        PlausiInterface plausiInterface = new PlausiFactory().createPlausi(string);
        if (plausiInterface != null) {
            if (dataSetWrapper.getDataFormatException() != null) {
                this.handleDataFormatException(defaultPlausiResult, dataSetWrapper.getDataFormatException());
            } else {
                PlausiKontext plausiKontext = null;
                try {
                    plausiKontext = this.createPlausiKontext(dataSetWrapper);
                }
                catch (Exception exception) {
                    DefaultPlausiError defaultPlausiError = new DefaultPlausiError();
                    defaultPlausiError.setErrorCode("SYST001");
                    defaultPlausiError.setErrorText("F\u00fcr den Typen \"" + string + "\" konnte keine Plausibilisierung durchgef\u00fchrt werden. " + exception.getMessage());
                    defaultPlausiError.setErrorType(4);
                    defaultPlausiResult.addError(defaultPlausiError);
                }
                if (plausiKontext != null) {
                    plausiInterface.gesamtPlausi((SatzInterface)dataSetWrapper, plausiKontext);
                    this.intiPlausiResult(dataSetWrapper, plausiKontext, defaultPlausiResult, plausiInterface);
                }
            }
        } else {
            DefaultPlausiError defaultPlausiError = new DefaultPlausiError();
            defaultPlausiError.setErrorCode("SYST001");
            defaultPlausiError.setErrorText("F\u00fcr den Typen \"" + string + "\" konnte keine Plausibilisierung durchgef\u00fchrt werden.");
            defaultPlausiError.setErrorType(4);
            defaultPlausiResult.addError(defaultPlausiError);
        }
        return defaultPlausiResult;
    }

    private void handleDataFormatException(DefaultPlausiResult defaultPlausiResult, DataFormatException dataFormatException) {
        DefaultPlausiError defaultPlausiError = new DefaultPlausiError();
        defaultPlausiError.setErrorCode("SYST001");
        defaultPlausiError.setErrorText(dataFormatException.getMessage());
        if (dataFormatException.getFieldPath() != null) {
            defaultPlausiError.setFieldname(dataFormatException.getFieldPath());
        }
        if (dataFormatException.getFormatErrorType() == 30 || dataFormatException.getFormatErrorType() == 40) {
            defaultPlausiError.setErrorType(4);
        } else {
            defaultPlausiError.setErrorType(2);
        }
        if ("DSLN".equals(dataFormatException.getSatzkennzeichen())) {
            switch (dataFormatException.getFormatErrorType()) {
                case 10: 
                case 15: 
                case 20: 
                case 25: {
                    defaultPlausiError.setErrorCode("DSLN910");
                    defaultPlausiError.setErrorText("Gesamtl\u00e4nge DSLN einschlie\u00dflich angeh\u00e4ngte Datenbausteine falsch");
                    break;
                }
                case 5: {
                    defaultPlausiError.setErrorCode("DSLN267");
                    defaultPlausiError.setErrorText("ANZAHL-UV nicht numerisch");
                    break;
                }
                case 35: {
                    defaultPlausiError.setErrorCode("DSLN001");
                    defaultPlausiError.setErrorText("KENNUNG ungleich DSLN");
                    break;
                }
                case 45: {
                    defaultPlausiError.setErrorCode("DSLN030");
                    defaultPlausiError.setErrorText("VERSIONS-NR-LN ist nicht numerisch");
                    break;
                }
                case 50: {
                    defaultPlausiError.setErrorCode("DSLN031");
                    defaultPlausiError.setErrorText("VERSIONS-NR-LN nicht zugelassen");
                    break;
                }
                case 55: {
                    defaultPlausiError.setErrorCode("DSLN249");
                    defaultPlausiError.setErrorText("MM-ANSPRECHPARTNER ungleich N oder J");
                }
            }
        } else if ("DSAS".equals(dataFormatException.getSatzkennzeichen())) {
            switch (dataFormatException.getFormatErrorType()) {
                case 5: 
                case 10: 
                case 15: 
                case 20: 
                case 25: {
                    defaultPlausiError.setErrorCode("DSAS910");
                    defaultPlausiError.setErrorText("Gesamtl\u00e4nge DSAS einschlie\u00dflich angeh\u00e4ngte Datenbausteine falsch");
                    break;
                }
                case 35: {
                    defaultPlausiError.setErrorCode("DSAS001");
                    defaultPlausiError.setErrorText("KENNUNG ungleich DSAS");
                    break;
                }
                case 45: {
                    defaultPlausiError.setErrorCode("DSAS030");
                    defaultPlausiError.setErrorText("VERSIONS-NR-AS ist nicht numerisch");
                    break;
                }
                case 50: {
                    defaultPlausiError.setErrorCode("DSAS031");
                    defaultPlausiError.setErrorText("VERSIONS-NR-AS nicht zugelassen");
                    break;
                }
                case 55: {
                    defaultPlausiError.setErrorCode("DSAS249");
                    defaultPlausiError.setErrorText("MM-ANSPRECHPARTNER ungleich N oder J");
                }
            }
        } else if ("DSKO".equals(dataFormatException.getSatzkennzeichen())) {
            switch (dataFormatException.getFormatErrorType()) {
                case 5: 
                case 10: 
                case 15: 
                case 20: 
                case 25: {
                    defaultPlausiError.setErrorCode("DSKO910");
                    defaultPlausiError.setErrorText("Unzul\u00e4ssige Gesamtl\u00e4nge DSKO");
                    break;
                }
                case 35: {
                    defaultPlausiError.setErrorCode("DSKO001");
                    defaultPlausiError.setErrorText("KENNUNG ungleich DSKO");
                    break;
                }
                case 45: {
                    defaultPlausiError.setErrorCode("DSKO040");
                    defaultPlausiError.setErrorText("VERSIONS-NR nicht numerisch");
                    break;
                }
                case 50: {
                    defaultPlausiError.setErrorCode("DSKO042");
                    defaultPlausiError.setErrorText("VERSIONS-NR nicht zugelassen");
                    break;
                }
            }
        }
        defaultPlausiResult.addError(defaultPlausiError);
    }

    public void intiPlausiResult(DataSetWrapper dataSetWrapper, PlausiKontext plausiKontext, DefaultPlausiResult defaultPlausiResult, PlausiInterface plausiInterface) {
        defaultPlausiResult.setPlausiVersion(plausiInterface.getPlausiVersionString());
        int n = plausiKontext.getAnzahlFehler();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                DefaultPlausiError defaultPlausiError;
                if (i == 8 && n > 9) {
                    defaultPlausiError = new DefaultPlausiError();
                    defaultPlausiError.setErrorType(2);
                    object2 = new StringBuffer();
                    ((StringBuffer)object2).append(dataSetWrapper.getSatzkennzeichen());
                    ((StringBuffer)object2).append("920");
                    defaultPlausiError.setErrorCode(((StringBuffer)object2).toString());
                    defaultPlausiError.setErrorText("Datensatz enth\u00e4lt mehr als 9 Fehler, Pr\u00fcfung abgebrochen");
                    defaultPlausiResult.addError(defaultPlausiError);
                    break;
                }
                defaultPlausiError = new DefaultPlausiError();
                object2 = plausiKontext.getFehler(i);
                defaultPlausiError.setErrorType(2);
                FeldDeskriptorInterface feldDeskriptorInterface = object2.getReferenzFeld();
                if (feldDeskriptorInterface == null && (object = object2.getFelder()) != null && ((FeldDeskriptorInterface[])object).length > 0) {
                    feldDeskriptorInterface = object[0];
                }
                if (feldDeskriptorInterface != null) {
                    defaultPlausiError.setFieldname(this.buildFieldname(feldDeskriptorInterface));
                }
                if (object2.getFehlerInfoTyp() == 3) {
                    defaultPlausiError.setErrorCode("FEHL002");
                    object = this.getErrorTextLength((PlausiFehler)object2);
                    defaultPlausiError.setErrorText((String)object);
                } else if (object2.getFehlerInfoTyp() == 1) {
                    defaultPlausiError.setErrorCode("FEHL001");
                    defaultPlausiError.setErrorText(this.getErrorTextMissingValue());
                } else if (object2.getFehlerInfoTyp() == 2) {
                    defaultPlausiError.setErrorCode("FEHL003");
                    object = this.getErrorTextType((PlausiFehler)object2);
                    defaultPlausiError.setErrorText((String)object);
                } else if (object2.getFehlerInfoTyp() == 4) {
                    defaultPlausiError.setErrorCode("FEHL004");
                    defaultPlausiError.setErrorText(this.getErrorTextValueRange((PlausiFehler)object2));
                } else {
                    object = object2.getFehlertextKurz();
                    if (object != null && ((String)object).length() >= 8 && ' ' == ((String)object).charAt(7)) {
                        defaultPlausiError.setErrorCode(((String)object).substring(0, 7));
                        defaultPlausiError.setErrorText(((String)object).substring(8));
                    } else if (object != null && ((String)object).length() >= 9 && ':' == ((String)object).charAt(7) && ' ' == ((String)object).charAt(8)) {
                        defaultPlausiError.setErrorCode(((String)object).substring(0, 7));
                        defaultPlausiError.setErrorText(((String)object).substring(9));
                    } else {
                        defaultPlausiError.setErrorCode("FEHL005");
                        defaultPlausiError.setErrorText((String)object);
                    }
                    if (defaultPlausiError.getErrorText() == null) {
                        defaultPlausiError.setErrorText("Kein Fehlertext verf\u00fcgbar.");
                    }
                }
                if (object2.istLaufzeitFehlerAufgetreten() && object2.getLaufzeitException() != null) {
                    defaultPlausiError.setThrowable(object2.getLaufzeitException());
                }
                defaultPlausiResult.addError(defaultPlausiError);
            }
        }
    }

    private String buildFieldname(FeldDeskriptorInterface feldDeskriptorInterface) {
        int[] nArray;
        String string = "";
        String string2 = "";
        if (feldDeskriptorInterface.getVorgaenger() != null) {
            string = this.buildFieldname(feldDeskriptorInterface.getVorgaenger());
        }
        if (feldDeskriptorInterface != null) {
            string2 = !"".equals(string) ? string + "." + feldDeskriptorInterface.getFeldNameTB() : feldDeskriptorInterface.getFeldNameTB();
        }
        if ((nArray = feldDeskriptorInterface.getIndizes()) != null && nArray.length > 0) {
            int n = nArray[0];
            string2 = string2 + "[" + n + "]";
        }
        return string2;
    }

    public String getErrorTextLength(PlausiFehler plausiFehler) {
        return "Das Feld enth\u00e4lt mehr als die zul\u00e4ssigen " + plausiFehler.getWertlaenge() + " Zeichen.";
    }

    public String getErrorTextMissingValue() {
        return "Das Datenfeld muss gef\u00fcllt sein.";
    }

    public String getErrorTextType(PlausiFehler plausiFehler) {
        String string;
        String string2 = "Feldinhalt muss " + plausiFehler.getMerkmalstyp() + " sein.";
        if (plausiFehler.getMaske() != null && (string = plausiFehler.getMaske()).startsWith("0")) {
            string2 = string2 + " Zahlwerte m\u00fcssen mit 0 aufgef\u00fcllt werden.";
        }
        return string2;
    }

    public String getErrorTextValueRange(PlausiFehler plausiFehler) {
        return "Der Wert liegt nicht im Wertebereich " + plausiFehler.getWertebereich() + ".";
    }

    private void check_MMDBAP(String string, int n, String string2, String string3) throws DataFormatException {
        if (string.length() < n) {
            throw new DataFormatException(string2, string3, string2, 20, null, "Der Datensatz ist zu kurz. Es kann nicht ermittelt werden, ob Datenbaustein DBAP \u0096 Ansprechpartner vorhanden ist.");
        }
        char c = string.charAt(n - 1);
        if (c != 'N' && c != 'J') {
            throw new DataFormatException(string2, string3, string2, 55, null, "Der MM-ANSPRECHPARTNER ungleich N oder J.");
        }
    }

    private PlausiKontext createPlausiKontext(DataSetWrapper dataSetWrapper) throws Exception {
        PlausiKontext plausiKontext = new PlausiKontext();
        String string = dataSetWrapper.getSatzkennzeichen();
        if ("DSLN".equals(string) || "DSAS".equals(string)) {
            String string2 = this.ipMeldejahrSchalttag;
            if (string2 != null) {
                AbstractMaske abstractMaske = new DatumMaskenParser().parse("MMTT");
                if (!abstractMaske.isWertGueltig(string2)) {
                    throw new Exception("Init-Parameter f\u00fcr Schalttag ist falsch. Der Wert muss im Format 'mmdd' (z.B " + DEFAULT_MELDEJAHR_SCHALTTAG + ") angegeben werden.");
                }
            } else {
                string2 = DEFAULT_MELDEJAHR_SCHALTTAG;
            }
            plausiKontext.setInitWerte((Object[])new String[]{string2});
        }
        return plausiKontext;
    }
}

