/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.frequency;

import de.statspez.pleditor.generator.codegen.analysis.complexity.datastructure.AbstractDatastructureComplexityResolver;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaConditionalStatement;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaForEachLoop;
import de.statspez.pleditor.generator.meta.MetaForNextLoop;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaStatementSequence;
import de.statspez.pleditor.generator.meta.MetaWhileLoop;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.Properties;
import java.util.Stack;

public class FrequencyImportExport {
    private Properties properties;
    private boolean read = true;

    public void importFrequencyFromProperties(MetaCustomPlausibilisierung plausi, Properties properties) {
        this.properties = properties;
        this.read = true;
        FunctionalFrequencyHandler programPropertiesHandler = new FunctionalFrequencyHandler();
        plausi.accept(programPropertiesHandler);
        DatastructureFrequencyHandler datastructurePropertiesHandler = new DatastructureFrequencyHandler();
        plausi.accept(datastructurePropertiesHandler);
    }

    public void exportFrequencyInProperties(MetaCustomPlausibilisierung plausi, Properties properties) {
        this.properties = properties;
        this.read = false;
        FunctionalFrequencyHandler programPropertiesHandler = new FunctionalFrequencyHandler();
        plausi.accept(programPropertiesHandler);
        DatastructureFrequencyHandler datastructurePropertiesHandler = new DatastructureFrequencyHandler();
        plausi.accept(datastructurePropertiesHandler);
    }

    public void importDefaultFrequency(MetaCustomPlausibilisierung plausi) {
        this.properties = null;
        FunctionalFrequencyHandler programPropertiesHandler = new FunctionalFrequencyHandler();
        plausi.accept(programPropertiesHandler);
    }

    private class DatastructureFrequencyHandler
    extends Traverser {
        private Stack field;

        private DatastructureFrequencyHandler() {
        }

        public void visitPlausibilisierung(MetaPlausibilisierung anObject) {
            this.field = new Stack();
            ((MetaCustomPlausibilisierung)anObject).rootThemenbereich().accept(this);
        }

        public void visitThemenbereich(MetaThemenbereich anObject) {
            this.visitElements(anObject.getFelder());
        }

        public void visitTBFeld(MetaTBFeld anObject) {
            int[] dimensions;
            this.field.push(anObject);
            MetaCustomTBFeld tbfield = (MetaCustomTBFeld)anObject;
            if (tbfield.getListe() && AbstractDatastructureComplexityResolver.isNDimensional(dimensions = tbfield.dimensions())) {
                if (FrequencyImportExport.this.read) {
                    Double frequency = this.getFrequencyFromProperties();
                    ((MetaCustomTBFeld)anObject).setDatastructureFrequency(frequency);
                } else {
                    this.addFrequencyToProperties(((MetaCustomTBFeld)anObject).getDatastructureFrequency());
                }
            }
            anObject.getKlasse().accept(this);
            this.field.pop();
        }

        private Double getFrequencyFromProperties() {
            Double frequency = null;
            if (FrequencyImportExport.this.properties != null) {
                Object obj;
                String key = this.generateKeyForProperties();
                if (FrequencyImportExport.this.properties.containsKey(key) && (obj = FrequencyImportExport.this.properties.get(key)) instanceof String) {
                    frequency = new Double((String)obj);
                }
            }
            return frequency;
        }

        private void addFrequencyToProperties(Double frequency) {
            if (FrequencyImportExport.this.properties != null) {
                String key = this.generateKeyForProperties();
                if (frequency == null) {
                    if (FrequencyImportExport.this.properties.containsKey(key)) {
                        FrequencyImportExport.this.properties.remove(key);
                    }
                } else {
                    FrequencyImportExport.this.properties.put(key, frequency.toString());
                }
            }
        }

        private String generateKeyForProperties() {
            StringBuffer buf = new StringBuffer("datastructure");
            int i = 0;
            while (i < this.field.size()) {
                buf.append('.');
                buf.append(((MetaTBFeld)this.field.get(i)).getName());
                ++i;
            }
            return buf.toString();
        }
    }

    private class FunctionalFrequencyHandler
    extends Traverser {
        private String currentThemenbereich;
        private String programName;
        private String loopID;
        private int forEachLoopIndex;
        private int forNextLoopIndex;
        private int whileLoopIndex;
        private int conditionalIndex;

        private FunctionalFrequencyHandler() {
        }

        public void visitThemenbereich(MetaThemenbereich anObject) {
            this.currentThemenbereich = anObject.getName();
            super.visitThemenbereich(anObject);
            this.currentThemenbereich = null;
        }

        public void visitForNextLoop(MetaForNextLoop aStatement) {
            ++this.forNextLoopIndex;
            this.loopID = "WDHF" + this.forNextLoopIndex;
            super.visitForNextLoop(aStatement);
        }

        public void visitForEachLoop(MetaForEachLoop aStatement) {
            ++this.forEachLoopIndex;
            this.loopID = "FJD" + this.forEachLoopIndex;
            super.visitForEachLoop(aStatement);
        }

        public void visitWhileLoop(MetaWhileLoop aStatement) {
            ++this.whileLoopIndex;
            this.loopID = "WDHSL" + this.whileLoopIndex;
            super.visitWhileLoop(aStatement);
        }

        public void visitProgram(MetaProgram aProgram) {
            this.programName = aProgram.name();
            this.forEachLoopIndex = 0;
            this.forNextLoopIndex = 0;
            this.whileLoopIndex = 0;
            this.conditionalIndex = 0;
            super.visitProgram(aProgram);
        }

        public void visitStatementSequence(MetaStatementSequence aSequence) {
            if (this.loopID != null) {
                if (FrequencyImportExport.this.read) {
                    Double frequency = this.getFrequencyFromProperties(this.loopID);
                    aSequence.setFunctionalFrequency(frequency);
                } else {
                    this.addFrequencyToProperties(this.loopID, aSequence.getFunctionalFrequency());
                }
                this.loopID = null;
            }
            super.visitStatementSequence(aSequence);
        }

        public void visitConditionalStatement(MetaConditionalStatement aStatement) {
            ++this.conditionalIndex;
            String trueLoopID = "WENN" + this.conditionalIndex + "." + "DANN";
            String falseLoopID = "WENN" + this.conditionalIndex + "." + "SONST";
            if (FrequencyImportExport.this.read) {
                Double trueFrequency = this.getFrequencyFromProperties(trueLoopID);
                Double falseFrequency = this.getFrequencyFromProperties(falseLoopID);
                if (aStatement.ifFalse().numberOfStatements() > 0) {
                    if (trueFrequency != null && falseFrequency != null) {
                        if (trueFrequency + falseFrequency != 1.0) {
                            throw new RuntimeException("Fehlerhafte Frequency-Angaben f\u00fcr Condition " + this.conditionalIndex);
                        }
                    } else if (trueFrequency != null) {
                        falseFrequency = new Double(1.0 - trueFrequency);
                    } else if (falseFrequency != null) {
                        trueFrequency = new Double(1.0 - falseFrequency);
                    }
                }
                aStatement.ifTrue().setFunctionalFrequency(trueFrequency);
                aStatement.ifFalse().setFunctionalFrequency(falseFrequency);
            } else {
                Double trueFrequency = aStatement.ifTrue().getFunctionalFrequency();
                Double falseFrequency = aStatement.ifFalse().getFunctionalFrequency();
                if (aStatement.ifFalse().numberOfStatements() > 0) {
                    if (trueFrequency != null && falseFrequency != null) {
                        if (trueFrequency + falseFrequency != 1.0) {
                            throw new RuntimeException("Fehlerhafte Frequency-Angaben f\u00fcr Condition " + this.conditionalIndex);
                        }
                    } else if (trueFrequency != null) {
                        falseFrequency = new Double(1.0 - trueFrequency);
                    } else if (falseFrequency != null) {
                        trueFrequency = new Double(1.0 - falseFrequency);
                    }
                }
                this.addFrequencyToProperties(trueLoopID, trueFrequency);
                this.addFrequencyToProperties(falseLoopID, falseFrequency);
            }
            super.visitConditionalStatement(aStatement);
        }

        private Double getFrequencyFromProperties(String loopID) {
            Double frequency = null;
            if (FrequencyImportExport.this.properties != null) {
                Object obj;
                String key = this.generateKeyForProperties(loopID);
                if (FrequencyImportExport.this.properties.containsKey(key) && (obj = FrequencyImportExport.this.properties.get(key)) instanceof String) {
                    frequency = new Double((String)obj);
                }
            }
            return frequency;
        }

        private void addFrequencyToProperties(String loopID, Double frequency) {
            if (FrequencyImportExport.this.properties != null) {
                String key = this.generateKeyForProperties(loopID);
                if (frequency == null) {
                    if (FrequencyImportExport.this.properties.containsKey(key)) {
                        FrequencyImportExport.this.properties.remove(key);
                    }
                } else {
                    FrequencyImportExport.this.properties.put(key, frequency.toString());
                }
            }
        }

        private String generateKeyForProperties(String loopID) {
            StringBuffer buf = new StringBuffer("program.");
            if (this.currentThemenbereich != null) {
                buf.append(this.currentThemenbereich);
                buf.append('.');
            }
            buf.append(this.programName);
            buf.append('.');
            buf.append(loopID);
            return buf.toString();
        }
    }
}

