/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.analysis.complexity.ui.program;

import de.statspez.pleditor.generator.codegen.analysis.complexity.program.ProgramComplexityResolver;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityChangeListener;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityNode;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.ComplexityUITreeCellRenderer;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.DoubleCellRenderer;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.PopupMenu;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.program.ProgramComplexityNode;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.program.ProgramComplexityNodeBuilder;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.program.ProgramComplexityTreeTableModel;
import de.statspez.pleditor.generator.codegen.analysis.complexity.ui.treetable.TreeTable;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class ProgramComplexityPanel
extends JPanel {
    private static final long serialVersionUID = 2405409406531500869L;
    private TreeTable table = new TreeTable();
    private ProgramComplexityTreeTableModel treeTableModel;
    private JScrollPane scrollPane;
    private List complexityChangeListeners;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ProgramComplexityPanel() {
        super(new BorderLayout());
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setSelectionMode(0);
        this.table.getTree().getSelectionModel().setSelectionMode(1);
        this.table.getTree().setRootVisible(false);
        this.table.setGridColor(SystemColor.control);
        this.table.setRowHeight(19);
        this.table.getTableHeader().setReorderingAllowed(false);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.statspez.pleditor.generator.codegen.analysis.complexity.ui.program.ProgramComplexityTreeTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.table.setDefaultRenderer(clazz, this.table.getTreeTableCellRenderer());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.table.setDefaultRenderer(clazz2, new DoubleCellRenderer());
        this.table.setTreeCellRenderer(new ComplexityUITreeCellRenderer());
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.scrollPane.getViewport().setBackground(this.table.getBackground());
        this.add((Component)this.scrollPane, "Center");
        this.complexityChangeListeners = new ArrayList();
    }

    public void addComplexityChangeListener(ComplexityChangeListener listener) {
        if (listener != null) {
            this.complexityChangeListeners.add(listener);
        }
    }

    public void removeComplexityChangeListener(ComplexityChangeListener listener) {
        if (listener != null) {
            this.complexityChangeListeners.remove(listener);
        }
    }

    public void addPopupMenu(final PopupMenu popupMenu) {
        MouseAdapter mousListener = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                int selectedRow;
                if (e.isPopupTrigger() && (selectedRow = ProgramComplexityPanel.this.table.getSelectedRow()) >= 0) {
                    ComplexityNode selectedNode = ProgramComplexityPanel.this.getSelectedComplexityNode();
                    boolean expandEnable = false;
                    if (!ProgramComplexityPanel.this.table.getTree().isExpanded(selectedRow)) {
                        expandEnable = selectedNode != null && !selectedNode.isLeaf();
                    }
                    popupMenu.setEnabledForExpand(expandEnable);
                    popupMenu.setEnabledForOpenElement(selectedNode);
                    popupMenu.setEnabledForDetails(selectedNode);
                    popupMenu.getJPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }
        };
        this.table.addMouseListener(mousListener);
    }

    public Point getDetailsLocation() {
        Point location = null;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow != -1) {
            Rectangle rect = this.table.getCellRect(selectedRow, 1, true);
            Point tableLocation = this.table.getLocationOnScreen();
            Point point = this.scrollPane.getViewport().toViewCoordinates(new Point(rect.x, rect.y));
            location = new Point(tableLocation.x + point.x, tableLocation.y + point.y);
        }
        return location;
    }

    public void setPlausibilisierung(MetaCustomPlausibilisierung plausi, boolean editable) {
        if (plausi == null) {
            throw new IllegalArgumentException("Plausibilisierung muss angegeben werden.");
        }
        ProgramComplexityNodeBuilder builder = new ProgramComplexityNodeBuilder();
        ProgramComplexityNode rootNode = builder.build(plausi);
        this.treeTableModel = new ProgramComplexityTreeTableModel(rootNode, editable);
        this.treeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeStructureChanged(TreeModelEvent e) {
            }

            public void treeNodesRemoved(TreeModelEvent e) {
            }

            public void treeNodesInserted(TreeModelEvent e) {
            }

            public void treeNodesChanged(TreeModelEvent e) {
                ProgramComplexityPanel.this.doCalculateComplexity();
            }
        });
        this.table.setModel(this.treeTableModel);
        this.table.setTreeCellRenderer(new ComplexityUITreeCellRenderer());
        this.doCalculateComplexity();
    }

    public void doCalculateComplexity() {
        MetaCustomPlausibilisierung plausi = this.getPlausi();
        if (plausi != null) {
            ProgramComplexityResolver programComplexityResolver = new ProgramComplexityResolver();
            programComplexityResolver.resolveComplexity(plausi, null);
        }
        this.fireComplexityChanged();
        this.table.repaint();
    }

    public MetaCustomPlausibilisierung getPlausi() {
        ComplexityNode rootNode;
        MetaCustomPlausibilisierung plausi = null;
        if (this.treeTableModel != null && (rootNode = (ComplexityNode)this.treeTableModel.getRoot()) != null) {
            plausi = (MetaCustomPlausibilisierung)rootNode.getElement();
        }
        return plausi;
    }

    public final void expand() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            TreePath selectedPath = this.table.getTree().getPathForRow(selectedRow);
            this.expandAll(selectedPath, true);
        }
    }

    public final void expandAll(boolean expand) {
        ComplexityNode root = (ComplexityNode)this.table.getTree().getModel().getRoot();
        this.expandAll(new TreePath(root), expand);
    }

    public final void expandAll(TreePath parent, boolean expand) {
        ComplexityNode node = (ComplexityNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            int i = 0;
            while (i < node.getChildCount()) {
                ComplexityNode n = node.getChild(i);
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(path, expand);
                ++i;
            }
        }
        if (expand) {
            this.table.getTree().expandPath(parent);
        } else {
            this.table.getTree().collapsePath(parent);
        }
    }

    public ComplexityNode getSelectedComplexityNode() {
        ComplexityNode result = null;
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            TreePath selectedPath = this.table.getTree().getPathForRow(selectedRow);
            result = (ComplexityNode)selectedPath.getLastPathComponent();
        }
        return result;
    }

    private void fireComplexityChanged() {
        int i = 0;
        while (i < this.complexityChangeListeners.size()) {
            ((ComplexityChangeListener)this.complexityChangeListeners.get(i)).complexityChanged();
            ++i;
        }
    }
}

