/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.runtime;

import de.statspez.pleditor.generator.runtime.InvalidValue;
import de.statspez.pleditor.generator.runtime.NilValue;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueFactory;

public class OperatorLib {
    public static Value plus(PlausiRuntimeContext context, Value a, Value b) {
        if (a == null || b == null) {
            String fehler = "Plusoperator: Ung\u00fcltige Parameter a = " + a + ", b = " + b + ".";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        if (!a.isValid() || a == NilValue.instance()) {
            if (!b.isValid() || b == NilValue.instance()) {
                return InvalidValue.instance();
            }
            return b;
        }
        if (!b.isValid() || b == NilValue.instance()) {
            return a;
        }
        return ValueFactory.instance().valueFor(a.asDouble() + b.asDouble());
    }

    public static Value minus(PlausiRuntimeContext context, Value a, Value b) {
        if (a == null || b == null) {
            String fehler = "Minusoperator: Ung\u00fcltige Parameter a = " + a + ", b = " + b + ".";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        if (!a.isValid() || a == NilValue.instance()) {
            if (!b.isValid() || b == NilValue.instance()) {
                return InvalidValue.instance();
            }
            return ValueFactory.instance().valueFor(b.asDouble() * -1.0);
        }
        if (!b.isValid() || b == NilValue.instance()) {
            return a;
        }
        return ValueFactory.instance().valueFor(a.asDouble() - b.asDouble());
    }

    public static Value mult(PlausiRuntimeContext context, Value a, Value b) {
        if (a == null || b == null) {
            String fehler = "Multiplikationsoperator: Ung\u00fcltige Parameter a = " + a + ", b = " + b + ".";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        if (!a.isValid() || a == NilValue.instance() || !b.isValid() || b == NilValue.instance()) {
            return InvalidValue.instance();
        }
        return ValueFactory.instance().valueFor(a.asDouble() * b.asDouble());
    }

    public static Value div(PlausiRuntimeContext context, Value a, Value b) {
        if (a == null || b == null) {
            String fehler = "Divisionsoperator: Ung\u00fcltige Parameter a = " + a + ", b = " + b + ".";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        if (!b.isValid() || b == NilValue.instance()) {
            String fehler = "Divisionsoperator: Division durch Null-Wert.";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        if (b.eq(ValueFactory.instance().valueFor(0.0))) {
            String fehler = "Divisionsoperator: Division durch Null (" + b + ").";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        if (!a.isValid() || a == NilValue.instance()) {
            return InvalidValue.instance();
        }
        return ValueFactory.instance().valueFor(a.asDouble() / b.asDouble());
    }

    public static Value contains(PlausiRuntimeContext context, Value a, Value b) {
        if (a == null || b == null) {
            String fehler = "IN-Operator: Ung\u00fcltige Parameter a = " + a + ", b = " + b + ".";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        return ValueFactory.instance().valueFor(a.contains(b));
    }

    public static Value eq(PlausiRuntimeContext context, Value a, Value b) {
        if (a == null || b == null) {
            String fehler = "Gleich-Operator: Ung\u00fcltige Parameter a = " + a + ", b = " + b + ".";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        return ValueFactory.instance().valueFor(a.eq(b));
    }

    public static Value ne(PlausiRuntimeContext context, Value a, Value b) {
        if (a == null || b == null) {
            String fehler = "Ungleich-Operator: Ung\u00fcltige Parameter a = " + a + ", b = " + b + ".";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        return ValueFactory.instance().valueFor(a.ne(b));
    }

    public static Value gt(PlausiRuntimeContext context, Value a, Value b) {
        if (a == null || b == null) {
            String fehler = "Gr\u00f6\u00dfer-Als-Operator: Ung\u00fcltige Parameter a = " + a + ", b = " + b + ".";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        return ValueFactory.instance().valueFor(a.gt(b));
    }

    public static Value ge(PlausiRuntimeContext context, Value a, Value b) {
        if (a == null || b == null) {
            String fehler = "Gr\u00f6\u00dfer-Oder-Gleich-Operator: Ung\u00fcltige Parameter a = " + a + ", b = " + b + ".";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        return ValueFactory.instance().valueFor(a.ge(b));
    }

    public static Value lt(PlausiRuntimeContext context, Value a, Value b) {
        if (a == null || b == null) {
            String fehler = "Kleiner-Als-Operator: Ung\u00fcltige Parameter a = " + a + ", b = " + b + ".";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        return ValueFactory.instance().valueFor(a.lt(b));
    }

    public static Value le(PlausiRuntimeContext context, Value a, Value b) {
        if (a == null || b == null) {
            String fehler = "Kleiner-Oder-Gleich-Operator: Ung\u00fcltige Parameter a = " + a + ", b = " + b + ".";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        return ValueFactory.instance().valueFor(a.le(b));
    }

    public static Value not(PlausiRuntimeContext context, Value a) {
        if (a == null) {
            String fehler = "ODER-Operator: Ung\u00fcltige Parameter a = " + a + ".";
            context.getLogger().error(fehler);
            throw new IllegalArgumentException(fehler);
        }
        return ValueFactory.instance().valueFor(!a.asBoolean());
    }
}

