/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.test.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RuntimeInfos {
    public static final String RUNTIMEVALUE_SEPARATOR = " ";
    private HashMap laufzeitMap = new HashMap();
    private HashMap frequenceMap = new HashMap();
    private HashMap datastructureFrequenceMap = new HashMap();

    public void fuegeLaufzeitHinzu(String name, Long laufzeit) {
        ArrayList<Long> longs = (ArrayList<Long>)this.laufzeitMap.get(name);
        if (longs == null) {
            longs = new ArrayList<Long>();
            this.laufzeitMap.put(name, longs);
        }
        longs.add(laufzeit);
    }

    public void fuegeFrequenzHinzu(String programmName, String frequenzID, Long frequenz) {
        ArrayList<Long> longs;
        HashMap<String, ArrayList<Long>> programFrequenceMap = (HashMap<String, ArrayList<Long>>)this.frequenceMap.get(programmName);
        if (programFrequenceMap == null) {
            programFrequenceMap = new HashMap<String, ArrayList<Long>>();
            this.frequenceMap.put(programmName, programFrequenceMap);
        }
        if ((longs = (ArrayList<Long>)programFrequenceMap.get(frequenzID)) == null) {
            longs = new ArrayList<Long>();
            programFrequenceMap.put(frequenzID, longs);
        }
        longs.add(frequenz);
    }

    public void fuegeDatastructureFrequenzHinzu(String fieldName, Long frequenz) {
        this.datastructureFrequenceMap.put(fieldName, frequenz);
    }

    public Collection gibFrequencyIDs(String programName) {
        HashMap programFrequenceMap = (HashMap)this.frequenceMap.get(programName);
        Collection<Object> result = programFrequenceMap != null ? programFrequenceMap.keySet() : new ArrayList();
        return result;
    }

    public Long gibFrequenz(String programName, String frequenzID) {
        List frequenzList;
        Long result = null;
        HashMap programFrequenzMap = (HashMap)this.frequenceMap.get(programName);
        if (programFrequenzMap != null && (frequenzList = (List)programFrequenzMap.get(frequenzID)) != null && frequenzList.size() > 0) {
            long summe = 0L;
            int i = 0;
            while (i < frequenzList.size()) {
                summe += ((Long)frequenzList.get(i)).longValue();
                ++i;
            }
            result = new Long(summe / (long)frequenzList.size());
        }
        return result;
    }

    public Collection gibProgrammNamen() {
        return this.laufzeitMap.keySet();
    }

    public long gibGesamtdauer(String programName) {
        List laufzeitList;
        long result = 0L;
        if (this.laufzeitMap.containsKey(programName) && (laufzeitList = this.laufzeitList(programName)) != null) {
            int i = 0;
            while (i < laufzeitList.size()) {
                Long laufzeit = (Long)laufzeitList.get(i);
                if (laufzeit != null) {
                    result += laufzeit.longValue();
                }
                ++i;
            }
        }
        return result;
    }

    public long gibDurchschnittdauer(String programName) {
        long result = 0L;
        if (this.laufzeitMap.containsKey(programName)) {
            result = this.gibGesamtdauer(programName) / this.gibAufrufAnzahl(programName);
        }
        return result;
    }

    public long gibAufrufAnzahl(String programName) {
        long result = 0L;
        if (this.laufzeitMap.containsKey(programName)) {
            result = this.laufzeitList(programName).size();
        }
        return result;
    }

    public String gibLaufzeitwerte(String programName) {
        List laufzeitList = this.laufzeitList(programName);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < laufzeitList.size()) {
            if (i > 0) {
                buf.append(RUNTIMEVALUE_SEPARATOR);
            }
            buf.append(laufzeitList.get(i));
            ++i;
        }
        return buf.toString();
    }

    private List laufzeitList(String programName) {
        List laufzeitList = (List)this.laufzeitMap.get(programName);
        if (laufzeitList == null) {
            throw new RuntimeException("Programm '" + programName + "' nicht vorhanden");
        }
        return laufzeitList;
    }

    public Iterator gibDatastructureKeys() {
        return this.datastructureFrequenceMap.keySet().iterator();
    }

    public Long gibDatastructureFrequenz(String key) {
        return (Long)this.datastructureFrequenceMap.get(key);
    }
}

