/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.ui.editor;

import de.statspez.pleditor.ui.editor.marker.Marker;
import de.statspez.pleditor.ui.editor.marker.MarkerContainer;
import de.statspez.pleditor.ui.editor.marker.MarkerHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class LineNumberJList
extends JList
implements ListSelectionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final int MARGIN_RIGHT = 2;
    private static final int MARKER_SIZE = 18;
    private int minWidth;
    private JTextComponent textComponent;
    private MarkerHandler markerHandler;
    private Map markers = new HashMap();
    private int currentCursorLine;

    public LineNumberJList(JTextComponent textComponent) {
        this.textComponent = textComponent;
        this.textComponent.addPropertyChangeListener("document", this);
        this.currentCursorLine = this.getCurrentCursorLineFromTextComp();
        this.setFocusable(false);
        this.addListSelectionListener(this);
        this.setModel(new LineNumberListModel());
        this.setCellRenderer(new LineNumberRenderer());
        this.setFont(textComponent.getFont());
        int height = textComponent.getFontMetrics(textComponent.getFont()).getHeight();
        int width = textComponent.getFontMetrics(textComponent.getFont()).stringWidth("999");
        this.setFixedCellHeight(height);
        this.setBorder(new LineNumberBorder());
        this.addMouseListener(new DoubleClickListener());
        this.minWidth = width + 2;
    }

    public Color getBackground() {
        return UIManager.getColor("Panel.background");
    }

    public Dimension getPreferredSize() {
        int width = this.minWidth;
        if (this.markerHandler != null) {
            width += 18;
        }
        Dimension d = super.getPreferredSize();
        if (d.width < width) {
            d = new Dimension(width, d.height);
        }
        return d;
    }

    public void valueChanged(ListSelectionEvent e) {
        Element element;
        int offset;
        if (e.getValueIsAdjusting()) {
            return;
        }
        int selectedLine = this.getSelectedIndex();
        if (selectedLine == -1) {
            return;
        }
        Element root = this.textComponent.getDocument().getDefaultRootElement();
        int currentLine = root.getElementIndex(offset = this.textComponent.getCaretPosition());
        if (selectedLine != currentLine && (element = root.getElement(selectedLine)) != null) {
            this.textComponent.setCaretPosition(element.getStartOffset());
        }
    }

    private int getCurrentCursorLineFromTextComp() {
        Element root = this.textComponent.getDocument().getDefaultRootElement();
        int offset = this.textComponent.getCaretPosition();
        int line = root.getElementIndex(offset);
        return line;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt != null && "document".equals(evt.getPropertyName())) {
            Element root = this.textComponent.getDocument().getDefaultRootElement();
            int offset = this.textComponent.getCaretPosition();
            int line = root.getElementIndex(offset);
            this.setSelectedIndex(line);
        }
    }

    public static void main(String[] args) {
        JTextArea textArea = new JTextArea();
        JScrollPane scrollPane = new JScrollPane(textArea);
        LineNumberJList list = new LineNumberJList(textArea);
        scrollPane.setRowHeaderView(list);
        JFrame frame = new JFrame("Line Number JList");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)scrollPane, "Center");
        frame.setSize(400, 300);
        frame.setVisible(true);
    }

    public void setMarkerHandler(MarkerHandler markerHandler) {
        this.markerHandler = markerHandler;
    }

    public void addMarker(Marker marker) {
        if (marker != null) {
            if (this.markers.containsKey(new Integer(marker.getLine()))) {
                MarkerContainer markerContainer = (MarkerContainer)this.markers.get(new Integer(marker.getLine()));
                markerContainer.addMarker(marker);
            } else {
                MarkerContainer markerContainer = new MarkerContainer(this.getLineStartOffset(marker.getLine()));
                markerContainer.addMarker(marker);
                this.markers.put(new Integer(marker.getLine()), markerContainer);
            }
        }
    }

    public void removeMarker(int line, int type) {
        boolean toRemoveContainer = false;
        Integer key = new Integer(line);
        if (this.markers.containsKey(key)) {
            MarkerContainer markerContainer = (MarkerContainer)this.markers.get(key);
            markerContainer.removeMarker(type);
            if (markerContainer.getMarker() == null) {
                toRemoveContainer = true;
            }
        }
        if (toRemoveContainer) {
            this.markers.remove(key);
        }
    }

    public void removeAllMarker(int type) {
        Set keySet = this.markers.keySet();
        ArrayList toRemoveContainer = new ArrayList();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            MarkerContainer markerContainer = (MarkerContainer)this.markers.get(object);
            markerContainer.removeMarker(type);
            if (markerContainer.getMarker() != null) continue;
            toRemoveContainer.add(object);
        }
        int i = 0;
        while (i < toRemoveContainer.size()) {
            this.markers.remove(toRemoveContainer.get(i));
            ++i;
        }
    }

    public int getLineStartOffset(int lineToSelect) {
        int result = 0;
        if (this.textComponent != null && this.textComponent.getDocument() != null && this.textComponent.getDocument().getDefaultRootElement() != null && lineToSelect - 1 >= 0 && this.textComponent.getDocument().getDefaultRootElement().getElement(lineToSelect - 1) != null) {
            result = this.textComponent.getDocument().getDefaultRootElement().getElement(lineToSelect - 1).getStartOffset();
        }
        return result;
    }

    private class DoubleClickListener
    implements MouseListener {
        private DoubleClickListener() {
        }

        public void mouseClicked(MouseEvent event) {
            int clickCount = event.getClickCount();
            if (clickCount == 2 && LineNumberJList.this.markerHandler != null) {
                int selectedIndex = LineNumberJList.this.getSelectedIndex() + 1;
                LineNumberJList.this.markerHandler.click(selectedIndex);
                LineNumberJList.this.repaint();
            }
            LineNumberJList.this.textComponent.requestFocus();
        }

        public void mouseEntered(MouseEvent event) {
        }

        public void mouseExited(MouseEvent event) {
        }

        public void mousePressed(MouseEvent event) {
        }

        public void mouseReleased(MouseEvent event) {
        }
    }

    private class LineNumberBorder
    extends AbstractBorder {
        private LineNumberBorder() {
        }

        public Insets getBorderInsets(Component c) {
            Insets insets;
            int top = 0;
            Border border = LineNumberJList.this.textComponent.getBorder();
            if (border != null && (insets = border.getBorderInsets(LineNumberJList.this.textComponent)) != null) {
                top = insets.top;
            }
            return new Insets(top, 0, 0, 0);
        }
    }

    class LineNumberListModel
    extends AbstractListModel
    implements CaretListener,
    DocumentListener {
        private static final long serialVersionUID = 1L;
        private int currentLines;

        public LineNumberListModel() {
            LineNumberJList.this.textComponent.getDocument().addDocumentListener(this);
            LineNumberJList.this.textComponent.addCaretListener(this);
        }

        public int getSize() {
            Element root = LineNumberJList.this.textComponent.getDocument().getDefaultRootElement();
            return root.getElementCount();
        }

        public Object getElementAt(int index) {
            Element root = LineNumberJList.this.textComponent.getDocument().getDefaultRootElement();
            int lines = root.getElementCount();
            if (index < lines) {
                return "" + (index + 1);
            }
            return "";
        }

        public void caretUpdate(CaretEvent e) {
            LineNumberJList.this.currentCursorLine = LineNumberJList.this.getCurrentCursorLineFromTextComp();
            LineNumberJList.this.setSelectedIndex(LineNumberJList.this.currentCursorLine);
        }

        public void insertUpdate(DocumentEvent e) {
            Element root = LineNumberJList.this.textComponent.getDocument().getDefaultRootElement();
            int lines = root.getElementCount();
            int lineCount = lines - this.currentLines;
            int offset = e.getOffset();
            int length = e.getLength();
            if (LineNumberJList.this.markerHandler != null) {
                Set keySet = LineNumberJList.this.markers.keySet();
                ArrayList<Integer> marksToPositionate = new ArrayList<Integer>();
                Iterator iterator = keySet.iterator();
                while (iterator.hasNext()) {
                    Integer next = (Integer)iterator.next();
                    MarkerContainer container = (MarkerContainer)LineNumberJList.this.markers.get(next);
                    if (container.getOffset() < offset + length && container.getOffset() != offset) continue;
                    marksToPositionate.add(next);
                }
                Collections.sort(marksToPositionate);
                int i = 0;
                while (i < marksToPositionate.size()) {
                    LineNumberJList.this.markerHandler.removeMarker((Integer)marksToPositionate.get(i));
                    LineNumberJList.this.markerHandler.addMarker((Integer)marksToPositionate.get(i) + lineCount);
                    ++i;
                }
            }
            if (lines > this.currentLines) {
                this.fireIntervalAdded(this, this.currentLines, lines);
                this.currentLines = lines;
            }
        }

        public void removeUpdate(DocumentEvent e) {
            ArrayList<Integer> markerToRemove;
            Iterator iterator;
            Set keySet;
            Element root = LineNumberJList.this.textComponent.getDocument().getDefaultRootElement();
            int lines = root.getElementCount();
            int offset = e.getOffset();
            int length = e.getLength();
            int lineCount = this.currentLines - lines;
            if (LineNumberJList.this.markerHandler != null) {
                Integer integer;
                keySet = LineNumberJList.this.markers.keySet();
                iterator = keySet.iterator();
                markerToRemove = new ArrayList<Integer>();
                ArrayList<Integer> markerToReplace = new ArrayList<Integer>();
                while (iterator.hasNext()) {
                    Integer next = (Integer)iterator.next();
                    MarkerContainer container = (MarkerContainer)LineNumberJList.this.markers.get(next);
                    if (container.getOffset() >= offset && container.getOffset() < offset + length) {
                        markerToRemove.add(next);
                    }
                    if (container.getOffset() < offset + length) continue;
                    markerToReplace.add(next);
                }
                Collections.sort(markerToRemove);
                Collections.sort(markerToReplace);
                int i = 0;
                while (i < markerToRemove.size()) {
                    integer = (Integer)markerToRemove.get(i);
                    LineNumberJList.this.markerHandler.removeMarker(integer);
                    ++i;
                }
                i = 0;
                while (i < markerToReplace.size()) {
                    integer = (Integer)markerToReplace.get(i);
                    LineNumberJList.this.markerHandler.removeMarker(integer);
                    LineNumberJList.this.markerHandler.addMarker(integer - lineCount);
                    ++i;
                }
            }
            if (lines < this.currentLines) {
                if (LineNumberJList.this.markerHandler != null) {
                    keySet = LineNumberJList.this.markers.keySet();
                    iterator = keySet.iterator();
                    markerToRemove = new ArrayList();
                    while (iterator.hasNext()) {
                        Integer next = (Integer)iterator.next();
                        if (lines >= next) continue;
                        markerToRemove.add(next);
                    }
                    Collections.sort(markerToRemove);
                    int i = 0;
                    while (i < markerToRemove.size()) {
                        Integer integer = (Integer)markerToRemove.get(i);
                        LineNumberJList.this.markerHandler.removeMarker(integer);
                        LineNumberJList.this.markerHandler.addMarker(integer - lineCount);
                        ++i;
                    }
                }
                this.fireIntervalRemoved(this, this.currentLines, lines);
                this.currentLines = lines;
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    class LineNumberRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        private int line = 0;

        LineNumberRenderer() {
            if (LineNumberJList.this.markerHandler != null) {
                this.setBorder(new EmptyBorder(0, 18, 0, 2));
            } else {
                this.setBorder(new EmptyBorder(0, 0, 0, 2));
            }
            this.setHorizontalAlignment(4);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, false, false);
            this.setBackground(LineNumberJList.this.currentCursorLine == index ? Color.yellow : Color.lightGray);
            this.line = index + 1;
            return this;
        }

        public void paint(Graphics g) {
            MarkerContainer markerContainer;
            super.paint(g);
            if (LineNumberJList.this.markerHandler != null && (markerContainer = (MarkerContainer)LineNumberJList.this.markers.get(new Integer(this.line))) != null && markerContainer.getMarker() != null) {
                markerContainer.getMarker().getIcon().paintIcon(this, g, 0, 0);
            }
        }
    }
}

